/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.QueryParams;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.server.HttpStatusException;
import com.linecorp.armeria.server.RoutingContextWrapper;
import com.linecorp.armeria.server.RoutingStatus;
import com.linecorp.armeria.server.VirtualHost;
import java.util.List;
import java.util.Objects;

public interface RoutingContext {
    public VirtualHost virtualHost();

    public String hostname();

    public HttpMethod method();

    public String path();

    @Nullable
    public String query();

    public QueryParams params();

    @Nullable
    public MediaType contentType();

    public List<MediaType> acceptTypes();

    public RequestHeaders headers();

    public RoutingStatus status();

    public void deferStatusException(HttpStatusException var1);

    @Nullable
    public HttpStatusException deferredStatusException();

    default public RoutingContext overridePath(final String path) {
        Objects.requireNonNull(path, "path");
        return new RoutingContextWrapper(this){

            @Override
            public String path() {
                return path;
            }
        };
    }

    @Deprecated
    public boolean isCorsPreflight();

    default public boolean requiresMatchingParamsPredicates() {
        return true;
    }

    default public boolean requiresMatchingHeadersPredicates() {
        return true;
    }
}

