/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.Splitter;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpServerCodec;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.util.AsciiString;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.ObjectUtil;
import java.util.Collection;
import java.util.List;

final class HttpServerUpgradeHandler
extends ChannelInboundHandlerAdapter {
    private static final FullHttpResponse UPGRADE_RESPONSE = HttpServerUpgradeHandler.newUpgradeResponse();
    private static final Splitter COMMA_SPLITTER = Splitter.on(',').omitEmptyStrings().trimResults();
    private final HttpServerCodec sourceCodec;
    private final UpgradeCodecFactory upgradeCodecFactory;
    @Nullable
    private UpgradeCodec upgradeCodec;
    private boolean handlingUpgrade;

    HttpServerUpgradeHandler(HttpServerCodec sourceCodec, UpgradeCodecFactory upgradeCodecFactory) {
        this.sourceCodec = (HttpServerCodec)ObjectUtil.checkNotNull((Object)sourceCodec, (String)"sourceCodec");
        this.upgradeCodecFactory = (UpgradeCodecFactory)ObjectUtil.checkNotNull((Object)upgradeCodecFactory, (String)"upgradeCodecFactory");
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        HttpRequest req;
        if (msg instanceof HttpRequest && (req = (HttpRequest)msg).headers().contains((CharSequence)HttpHeaderNames.UPGRADE) && this.upgrade(ctx, req)) {
            this.handlingUpgrade = true;
            return;
        }
        ctx.fireChannelRead(msg);
        if (this.handlingUpgrade && msg instanceof LastHttpContent) {
            this.sourceCodec.upgradeFrom(ctx);
            ctx.fireChannelReadComplete();
            ctx.pipeline().remove((ChannelHandler)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean upgrade(ChannelHandlerContext ctx, HttpRequest request) {
        List<String> requestedProtocols = COMMA_SPLITTER.splitToList(request.headers().get((CharSequence)HttpHeaderNames.UPGRADE));
        int numRequestedProtocols = requestedProtocols.size();
        for (int i = 0; i < numRequestedProtocols; ++i) {
            CharSequence protocol = requestedProtocols.get(i);
            if (!AsciiString.contentEquals((CharSequence)Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME, (CharSequence)protocol)) continue;
            this.upgradeCodec = this.upgradeCodecFactory.newUpgradeCodec();
            break;
        }
        if (this.upgradeCodec == null) {
            return false;
        }
        List connectionHeaderValues = request.headers().getAll((CharSequence)HttpHeaderNames.CONNECTION);
        if (connectionHeaderValues == null || connectionHeaderValues.isEmpty()) {
            return false;
        }
        List values = connectionHeaderValues.stream().flatMap(COMMA_SPLITTER::splitToStream).collect(ImmutableList.toImmutableList());
        if (!AsciiString.containsContentEqualsIgnoreCase((Collection)values, (CharSequence)HttpHeaderNames.UPGRADE) || !AsciiString.containsContentEqualsIgnoreCase((Collection)values, (CharSequence)Http2CodecUtil.HTTP_UPGRADE_SETTINGS_HEADER)) {
            return false;
        }
        if (!request.headers().contains(Http2CodecUtil.HTTP_UPGRADE_SETTINGS_HEADER)) {
            return false;
        }
        if (!this.upgradeCodec.prepareUpgradeResponse(ctx, request)) {
            return false;
        }
        UpgradeEvent event = new UpgradeEvent(request);
        try {
            ChannelFuture writeComplete = ctx.writeAndFlush((Object)UPGRADE_RESPONSE.retain());
            this.sourceCodec.removeOutboundHandler();
            assert (this.upgradeCodec != null);
            this.upgradeCodec.upgradeTo(ctx);
            ctx.fireUserEventTriggered((Object)event.retain());
            writeComplete.addListener((GenericFutureListener)ChannelFutureListener.CLOSE_ON_FAILURE);
        }
        finally {
            event.release();
        }
        return true;
    }

    private static FullHttpResponse newUpgradeResponse() {
        DefaultFullHttpResponse res = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.SWITCHING_PROTOCOLS, Unpooled.EMPTY_BUFFER, true);
        res.headers().add((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.UPGRADE);
        res.headers().add((CharSequence)HttpHeaderNames.UPGRADE, (Object)Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME);
        return res;
    }

    @FunctionalInterface
    static interface UpgradeCodecFactory {
        public UpgradeCodec newUpgradeCodec();
    }

    static interface UpgradeCodec {
        public boolean prepareUpgradeResponse(ChannelHandlerContext var1, HttpRequest var2);

        public void upgradeTo(ChannelHandlerContext var1);
    }

    static final class UpgradeEvent
    implements ReferenceCounted {
        private final HttpRequest upgradeRequest;

        UpgradeEvent(HttpRequest upgradeRequest) {
            this.upgradeRequest = upgradeRequest;
        }

        public CharSequence protocol() {
            return Http2CodecUtil.HTTP_UPGRADE_PROTOCOL_NAME;
        }

        public HttpRequest upgradeRequest() {
            return this.upgradeRequest;
        }

        public int refCnt() {
            return ReferenceCountUtil.refCnt((Object)this.upgradeRequest);
        }

        public UpgradeEvent retain() {
            ReferenceCountUtil.retain((Object)this.upgradeRequest);
            return this;
        }

        public UpgradeEvent retain(int increment) {
            ReferenceCountUtil.retain((Object)this.upgradeRequest);
            return this;
        }

        public UpgradeEvent touch() {
            ReferenceCountUtil.touch((Object)this.upgradeRequest);
            return this;
        }

        public UpgradeEvent touch(Object hint) {
            ReferenceCountUtil.touch((Object)this.upgradeRequest, (Object)hint);
            return this;
        }

        public boolean release() {
            return ReferenceCountUtil.release((Object)this.upgradeRequest);
        }

        public boolean release(int decrement) {
            return ReferenceCountUtil.release((Object)this.upgradeRequest, (int)decrement);
        }

        public String toString() {
            return "UpgradeEvent [protocol=" + this.protocol() + ", upgradeRequest=" + this.upgradeRequest + ']';
        }
    }
}

