/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.ContentTooLargeException;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.stream.ClosedStreamException;
import com.linecorp.armeria.internal.common.ArmeriaHttpUtil;
import com.linecorp.armeria.internal.common.Http2GoAwayHandler;
import com.linecorp.armeria.internal.common.InboundTrafficController;
import com.linecorp.armeria.internal.common.KeepAliveHandler;
import com.linecorp.armeria.server.DecodedHttpRequest;
import com.linecorp.armeria.server.DecodedHttpRequestWriter;
import com.linecorp.armeria.server.HttpStatusException;
import com.linecorp.armeria.server.Routed;
import com.linecorp.armeria.server.RoutingContext;
import com.linecorp.armeria.server.ServerConfig;
import com.linecorp.armeria.server.ServerHttp2ObjectEncoder;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.ServiceRouteUtil;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2EventAdapter;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.handler.codec.http2.Http2Stream;
import io.netty.util.AsciiString;
import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Http2RequestDecoder
extends Http2EventAdapter {
    private static final Logger logger = LoggerFactory.getLogger(Http2RequestDecoder.class);
    private static final ResponseHeaders CONTINUE_RESPONSE = ResponseHeaders.of(HttpStatus.CONTINUE);
    private final ServerConfig cfg;
    private final Channel channel;
    private final String scheme;
    @Nullable
    private ServerHttp2ObjectEncoder encoder;
    private final InboundTrafficController inboundTrafficController;
    private final KeepAliveHandler keepAliveHandler;
    private final Http2GoAwayHandler goAwayHandler;
    private final IntObjectMap<DecodedHttpRequest> requests = new IntObjectHashMap();
    private int nextId;

    Http2RequestDecoder(ServerConfig cfg, Channel channel, String scheme, KeepAliveHandler keepAliveHandler) {
        this.cfg = cfg;
        this.channel = channel;
        this.scheme = scheme;
        this.inboundTrafficController = InboundTrafficController.ofHttp2(channel, cfg.http2InitialConnectionWindowSize());
        this.keepAliveHandler = keepAliveHandler;
        this.goAwayHandler = new Http2GoAwayHandler();
    }

    Http2GoAwayHandler goAwayHandler() {
        return this.goAwayHandler;
    }

    void initEncoder(ServerHttp2ObjectEncoder encoder) {
        if (this.encoder == null) {
            this.encoder = encoder;
        }
    }

    public void onSettingsRead(ChannelHandlerContext ctx, Http2Settings settings) {
        ctx.fireChannelRead((Object)settings);
    }

    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers nettyHeaders, int padding, boolean endOfStream) throws Http2Exception {
        this.keepAliveChannelRead(true);
        DecodedHttpRequest req = (DecodedHttpRequest)this.requests.get(streamId);
        if (req == null) {
            Routed<ServiceConfig> routed;
            assert (this.encoder != null);
            boolean hasInvalidExpectHeader = !this.handle100Continue(streamId, nettyHeaders);
            CharSequence methodText = nettyHeaders.method();
            if (methodText == null) {
                this.writeErrorResponse(streamId, null, HttpStatus.BAD_REQUEST, "Missing method", null);
                return;
            }
            HttpMethod method = HttpMethod.tryParse(methodText.toString());
            if (method == null) {
                this.writeErrorResponse(streamId, null, HttpStatus.METHOD_NOT_ALLOWED, "Unsupported method", null);
                return;
            }
            RequestHeaders headers = ArmeriaHttpUtil.toArmeriaRequestHeaders(ctx, nettyHeaders, endOfStream, this.scheme, this.cfg);
            if (method == HttpMethod.CONNECT && !nettyHeaders.contains((Object)HttpHeaderNames.PROTOCOL)) {
                this.writeErrorResponse(streamId, headers, HttpStatus.METHOD_NOT_ALLOWED, "Unsupported method", null);
                return;
            }
            String contentLengthStr = headers.get((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
            if (contentLengthStr != null) {
                long contentLength;
                try {
                    contentLength = Long.parseLong(contentLengthStr);
                }
                catch (NumberFormatException ignored) {
                    contentLength = -1L;
                }
                if (contentLength < 0L) {
                    this.writeErrorResponse(streamId, headers, HttpStatus.BAD_REQUEST, "Invalid content length", null);
                    return;
                }
            }
            if (hasInvalidExpectHeader) {
                this.writeErrorResponse(streamId, headers, HttpStatus.EXPECTATION_FAILED, null, null);
                return;
            }
            RoutingContext routingCtx = ServiceRouteUtil.newRoutingContext(this.cfg, ctx.channel(), headers);
            if (routingCtx.status().routeMustExist()) {
                try {
                    routed = routingCtx.virtualHost().findServiceConfig(routingCtx, true);
                }
                catch (Throwable cause) {
                    logger.warn("{} Unexpected exception: {}", new Object[]{ctx.channel(), headers, cause});
                    this.writeErrorResponse(streamId, headers, HttpStatus.INTERNAL_SERVER_ERROR, null, cause);
                    return;
                }
                assert (routed.isPresent());
            } else {
                routed = null;
            }
            int id = ++this.nextId;
            EventLoop eventLoop = ctx.channel().eventLoop();
            req = DecodedHttpRequest.of(endOfStream, eventLoop, id, streamId, headers, true, this.inboundTrafficController, routingCtx, routed);
            this.requests.put(streamId, (Object)req);
            if (!req.isAggregated()) {
                ctx.fireChannelRead((Object)req);
            }
        } else {
            HttpHeaders trailers = ArmeriaHttpUtil.toArmeria(nettyHeaders, true, endOfStream);
            DecodedHttpRequestWriter decodedReq = (DecodedHttpRequestWriter)req;
            try {
                decodedReq.write(trailers);
                if (req.isAggregated()) {
                    ctx.fireChannelRead((Object)req);
                }
            }
            catch (Throwable t) {
                decodedReq.close(t);
                throw Http2Exception.connectionError((Http2Error)Http2Error.INTERNAL_ERROR, (Throwable)t, (String)"failed to consume a HEADERS frame", (Object[])new Object[0]);
            }
        }
    }

    public void onHeadersRead(ChannelHandlerContext ctx, int streamId, Http2Headers headers, int streamDependency, short weight, boolean exclusive, int padding, boolean endOfStream) throws Http2Exception {
        this.onHeadersRead(ctx, streamId, headers, padding, endOfStream);
    }

    private boolean handle100Continue(int streamId, Http2Headers headers) {
        CharSequence expectValue = (CharSequence)headers.get((Object)HttpHeaderNames.EXPECT);
        if (expectValue == null) {
            return true;
        }
        if (!AsciiString.contentEqualsIgnoreCase((CharSequence)HttpHeaderValues.CONTINUE, (CharSequence)expectValue)) {
            return false;
        }
        assert (this.encoder != null);
        this.encoder.writeHeaders(0, streamId, CONTINUE_RESPONSE, false);
        headers.remove((Object)HttpHeaderNames.EXPECT);
        return true;
    }

    public void onStreamClosed(Http2Stream stream) {
        this.goAwayHandler.onStreamClosed(this.channel, stream);
        DecodedHttpRequest req = (DecodedHttpRequest)this.requests.remove(stream.id());
        if (req != null && !req.isComplete()) {
            req.close(ClosedStreamException.get());
        }
    }

    public int onDataRead(ChannelHandlerContext ctx, int streamId, ByteBuf data, int padding, boolean endOfStream) throws Http2Exception {
        this.keepAliveChannelRead(false);
        DecodedHttpRequest req = (DecodedHttpRequest)this.requests.get(streamId);
        if (req == null) {
            throw Http2Exception.connectionError((Http2Error)Http2Error.PROTOCOL_ERROR, (String)"received a DATA Frame for an unknown stream: %d", (Object[])new Object[]{streamId});
        }
        int dataLength = data.readableBytes();
        if (dataLength == 0) {
            if (endOfStream) {
                req.close();
                if (req.isAggregated()) {
                    ctx.fireChannelRead((Object)req);
                }
            }
            return padding;
        }
        DecodedHttpRequestWriter decodedReq = (DecodedHttpRequestWriter)req;
        decodedReq.increaseTransferredBytes(dataLength);
        long maxContentLength = decodedReq.maxRequestLength();
        long transferredLength = decodedReq.transferredBytes();
        if (maxContentLength > 0L && transferredLength > maxContentLength) {
            assert (this.encoder != null);
            Http2Stream stream = this.encoder.findStream(streamId);
            if (Http2RequestDecoder.isWritable(stream)) {
                ContentTooLargeException cause = ContentTooLargeException.builder().maxContentLength(maxContentLength).contentLength(req.headers()).transferred(transferredLength).build();
                this.writeErrorResponse(streamId, req.headers(), HttpStatus.REQUEST_ENTITY_TOO_LARGE, null, cause);
                if (decodedReq.isOpen()) {
                    decodedReq.close(HttpStatusException.of(HttpStatus.REQUEST_ENTITY_TOO_LARGE, (Throwable)cause));
                }
            } else {
                decodedReq.abort();
            }
        } else if (decodedReq.isOpen()) {
            try {
                decodedReq.write(HttpData.wrap(data.retain()).withEndOfStream(endOfStream));
                if (endOfStream && decodedReq.isAggregated()) {
                    ctx.fireChannelRead((Object)req);
                }
            }
            catch (Throwable t) {
                decodedReq.close(t);
                throw Http2Exception.connectionError((Http2Error)Http2Error.INTERNAL_ERROR, (Throwable)t, (String)"failed to consume a DATA frame", (Object[])new Object[0]);
            }
        }
        return dataLength + padding;
    }

    private static boolean isWritable(@Nullable Http2Stream stream) {
        if (stream == null) {
            return false;
        }
        switch (stream.state()) {
            case OPEN: 
            case HALF_CLOSED_REMOTE: {
                return !stream.isHeadersSent();
            }
        }
        return false;
    }

    private void writeErrorResponse(int streamId, @Nullable RequestHeaders headers, HttpStatus status, @Nullable String message, @Nullable Throwable cause) {
        assert (this.encoder != null);
        this.encoder.writeErrorResponse(0, streamId, this.cfg.defaultVirtualHost().fallbackServiceConfig(), headers, status, message, cause);
    }

    public void onRstStreamRead(ChannelHandlerContext ctx, int streamId, long errorCode) throws Http2Exception {
        this.keepAliveChannelRead(false);
        DecodedHttpRequest req = (DecodedHttpRequest)this.requests.get(streamId);
        if (req == null) {
            throw Http2Exception.connectionError((Http2Error)Http2Error.PROTOCOL_ERROR, (String)"received a RST_STREAM frame for an unknown stream: %d", (Object[])new Object[]{streamId});
        }
        ClosedStreamException cause = new ClosedStreamException("received a RST_STREAM frame: " + Http2Error.valueOf((long)errorCode));
        req.abortResponse(cause, true);
    }

    public void onPushPromiseRead(ChannelHandlerContext ctx, int streamId, int promisedStreamId, Http2Headers headers, int padding) throws Http2Exception {
        throw Http2Exception.connectionError((Http2Error)Http2Error.PROTOCOL_ERROR, (String)"received a PUSH_PROMISE frame which only a server can send", (Object[])new Object[0]);
    }

    public void onGoAwaySent(int lastStreamId, long errorCode, ByteBuf debugData) {
        this.goAwayHandler.onGoAwaySent(this.channel, lastStreamId, errorCode, debugData);
    }

    public void onGoAwayReceived(int lastStreamId, long errorCode, ByteBuf debugData) {
        this.goAwayHandler.onGoAwayReceived(this.channel, lastStreamId, errorCode, debugData);
    }

    public void onPingAckRead(ChannelHandlerContext ctx, long data) {
        if (this.keepAliveHandler.isHttp2()) {
            this.keepAliveHandler.onPingAck(data);
        }
    }

    public void onPingRead(ChannelHandlerContext ctx, long data) {
        this.keepAliveHandler.onPing();
    }

    private void keepAliveChannelRead(boolean increaseNumRequests) {
        this.keepAliveHandler.onReadOrWrite();
        if (increaseNumRequests) {
            this.keepAliveHandler.increaseNumRequests();
        }
    }
}

