/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.ClosedSessionException;
import com.linecorp.armeria.common.ContentTooLargeException;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpRequestWriter;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.ProtocolViolationException;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.ArmeriaHttpUtil;
import com.linecorp.armeria.internal.common.Http1ObjectEncoder;
import com.linecorp.armeria.internal.common.InboundTrafficController;
import com.linecorp.armeria.internal.common.InitiateConnectionShutdown;
import com.linecorp.armeria.internal.common.KeepAliveHandler;
import com.linecorp.armeria.internal.common.NoopKeepAliveHandler;
import com.linecorp.armeria.internal.shaded.guava.base.Ascii;
import com.linecorp.armeria.server.DecodedHttpRequest;
import com.linecorp.armeria.server.DecodedHttpRequestWriter;
import com.linecorp.armeria.server.EmptyContentDecodedHttpRequest;
import com.linecorp.armeria.server.Http2ServerConnectionHandler;
import com.linecorp.armeria.server.HttpServerUpgradeHandler;
import com.linecorp.armeria.server.HttpStatusException;
import com.linecorp.armeria.server.Routed;
import com.linecorp.armeria.server.RoutingContext;
import com.linecorp.armeria.server.ServerConfig;
import com.linecorp.armeria.server.ServerHttp1ObjectEncoder;
import com.linecorp.armeria.server.ServerHttp2ObjectEncoder;
import com.linecorp.armeria.server.ServerHttpObjectEncoder;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.ServiceRouteUtil;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.handler.codec.DecoderResult;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpExpectationFailedEvent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http2.Http2CodecUtil;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Settings;
import io.netty.util.AsciiString;
import io.netty.util.ReferenceCountUtil;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class Http1RequestDecoder
extends ChannelDuplexHandler {
    private static final Logger logger = LoggerFactory.getLogger(Http1RequestDecoder.class);
    private static final Http2Settings DEFAULT_HTTP2_SETTINGS = new Http2Settings();
    private static final ResponseHeaders CONTINUE_RESPONSE = ResponseHeaders.of(HttpStatus.CONTINUE);
    private final ServerConfig cfg;
    private final AsciiString scheme;
    private final InboundTrafficController inboundTrafficController;
    private ServerHttpObjectEncoder encoder;
    @Nullable
    private DecodedHttpRequest req;
    private int receivedRequests;
    private boolean discarding;

    Http1RequestDecoder(ServerConfig cfg, Channel channel, AsciiString scheme, ServerHttp1ObjectEncoder encoder) {
        this.cfg = cfg;
        this.scheme = scheme;
        this.inboundTrafficController = InboundTrafficController.ofHttp1(channel);
        this.encoder = encoder;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.maybeInitializeKeepAliveHandler(ctx);
        super.handlerAdded(ctx);
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.destroyKeepAliveHandler();
        super.handlerRemoved(ctx);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.maybeInitializeKeepAliveHandler(ctx);
        super.channelActive(ctx);
    }

    public void channelUnregistered(ChannelHandlerContext ctx) throws Exception {
        super.channelUnregistered(ctx);
        if (this.req instanceof HttpRequestWriter) {
            ((HttpRequestWriter)((Object)this.req)).close(ClosedSessionException.get());
        }
        this.destroyKeepAliveHandler();
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.destroyKeepAliveHandler();
        super.channelInactive(ctx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (!(msg instanceof HttpObject)) {
            ctx.fireChannelRead(msg);
            return;
        }
        KeepAliveHandler keepAliveHandler = this.encoder.keepAliveHandler();
        keepAliveHandler.onReadOrWrite();
        DecodedHttpRequest req = this.req;
        int id = req != null ? req.id() : (this.receivedRequests = this.receivedRequests + 1);
        try {
            if (this.discarding) {
                return;
            }
            if (req == null) {
                if (msg instanceof HttpRequest) {
                    Routed<ServiceConfig> routed;
                    boolean contentEmpty;
                    keepAliveHandler.increaseNumRequests();
                    HttpRequest nettyReq = (HttpRequest)msg;
                    if (!nettyReq.decoderResult().isSuccess()) {
                        this.fail(id, null, HttpStatus.BAD_REQUEST, "Decoder failure", null);
                        return;
                    }
                    HttpMethod nettyMethod = nettyReq.method();
                    if (!com.linecorp.armeria.common.HttpMethod.isSupported(nettyMethod.name())) {
                        this.fail(id, null, HttpStatus.METHOD_NOT_ALLOWED, "Unsupported method", null);
                        return;
                    }
                    boolean hasInvalidExpectHeader = !this.handle100Continue(id, nettyReq);
                    RequestHeaders headers = ArmeriaHttpUtil.toArmeria(ctx, nettyReq, this.cfg, this.scheme.toString());
                    if (headers.method() == com.linecorp.armeria.common.HttpMethod.CONNECT) {
                        this.fail(id, headers, HttpStatus.METHOD_NOT_ALLOWED, "Unsupported method", null);
                        return;
                    }
                    String contentLengthStr = headers.get((CharSequence)HttpHeaderNames.CONTENT_LENGTH);
                    if (contentLengthStr != null) {
                        long contentLength;
                        try {
                            contentLength = Long.parseLong(contentLengthStr);
                        }
                        catch (NumberFormatException ignored) {
                            contentLength = -1L;
                        }
                        if (contentLength < 0L) {
                            this.fail(id, headers, HttpStatus.BAD_REQUEST, "Invalid content length", null);
                            return;
                        }
                        contentEmpty = contentLength == 0L;
                    } else {
                        contentEmpty = true;
                    }
                    if (hasInvalidExpectHeader) {
                        ctx.pipeline().fireUserEventTriggered((Object)HttpExpectationFailedEvent.INSTANCE);
                        this.fail(id, headers, HttpStatus.EXPECTATION_FAILED, null, null);
                        return;
                    }
                    RoutingContext routingCtx = ServiceRouteUtil.newRoutingContext(this.cfg, ctx.channel(), headers);
                    if (routingCtx.status().routeMustExist()) {
                        try {
                            routed = routingCtx.virtualHost().findServiceConfig(routingCtx, true);
                        }
                        catch (Throwable cause) {
                            logger.warn("{} Unexpected exception: {}", new Object[]{ctx.channel(), headers, cause});
                            this.fail(id, headers, HttpStatus.INTERNAL_SERVER_ERROR, null, cause);
                            ReferenceCountUtil.release((Object)msg);
                            return;
                        }
                        assert (routed.isPresent());
                    } else {
                        routed = null;
                    }
                    boolean keepAlive = HttpUtil.isKeepAlive((HttpMessage)nettyReq);
                    boolean endOfStream = contentEmpty && !HttpUtil.isTransferEncodingChunked((HttpMessage)nettyReq);
                    EventLoop eventLoop = ctx.channel().eventLoop();
                    this.req = req = DecodedHttpRequest.of(endOfStream, eventLoop, id, 1, headers, keepAlive, this.inboundTrafficController, routingCtx, routed);
                    if (!req.isAggregated()) {
                        ctx.fireChannelRead((Object)req);
                    }
                } else {
                    this.fail(id, null, HttpStatus.BAD_REQUEST, "Invalid decoder state", null);
                    return;
                }
            }
            if (msg instanceof LastHttpContent && this.encoder instanceof ServerHttp2ObjectEncoder) {
                ctx.pipeline().remove((ChannelHandler)this);
            }
            if (msg instanceof LastHttpContent && req instanceof EmptyContentDecodedHttpRequest) {
                this.req = null;
            } else if (msg instanceof HttpContent) {
                assert (req instanceof DecodedHttpRequestWriter);
                DecodedHttpRequestWriter decodedReq = (DecodedHttpRequestWriter)req;
                HttpContent content = (HttpContent)msg;
                DecoderResult decoderResult = content.decoderResult();
                if (!decoderResult.isSuccess()) {
                    this.fail(id, decodedReq.headers(), HttpStatus.BAD_REQUEST, Http2Error.PROTOCOL_ERROR, "Decoder failure", null);
                    ProtocolViolationException cause = new ProtocolViolationException(decoderResult.cause());
                    decodedReq.close(HttpStatusException.of(HttpStatus.BAD_REQUEST, (Throwable)cause));
                    return;
                }
                ByteBuf data = content.content();
                int dataLength = data.readableBytes();
                if (dataLength != 0) {
                    decodedReq.increaseTransferredBytes(dataLength);
                    long maxContentLength = decodedReq.maxRequestLength();
                    long transferredLength = decodedReq.transferredBytes();
                    if (maxContentLength > 0L && transferredLength > maxContentLength) {
                        ContentTooLargeException cause = ContentTooLargeException.builder().maxContentLength(maxContentLength).contentLength(req.headers()).transferred(transferredLength).build();
                        this.fail(id, decodedReq.headers(), HttpStatus.REQUEST_ENTITY_TOO_LARGE, Http2Error.CANCEL, null, cause);
                        decodedReq.close(HttpStatusException.of(HttpStatus.REQUEST_ENTITY_TOO_LARGE, (Throwable)cause));
                        return;
                    }
                    if (decodedReq.isOpen()) {
                        decodedReq.write(HttpData.wrap(data.retain()));
                    }
                }
                if (msg instanceof LastHttpContent) {
                    HttpHeaders trailingHeaders = ((LastHttpContent)msg).trailingHeaders();
                    if (!trailingHeaders.isEmpty()) {
                        decodedReq.write(ArmeriaHttpUtil.toArmeria(trailingHeaders));
                    }
                    decodedReq.close();
                    if (decodedReq.isAggregated()) {
                        ctx.fireChannelRead((Object)decodedReq);
                    }
                    this.req = null;
                }
            }
        }
        catch (URISyntaxException e) {
            if (req != null) {
                this.fail(id, req.headers(), HttpStatus.BAD_REQUEST, Http2Error.CANCEL, "Invalid request path", e);
                req.close(HttpStatusException.of(HttpStatus.BAD_REQUEST, (Throwable)e));
            } else {
                this.fail(id, null, HttpStatus.BAD_REQUEST, Http2Error.CANCEL, "Invalid request path", e);
            }
        }
        catch (Throwable t) {
            if (req != null) {
                this.fail(id, req.headers(), HttpStatus.INTERNAL_SERVER_ERROR, Http2Error.INTERNAL_ERROR, null, t);
                req.close(HttpStatusException.of(HttpStatus.INTERNAL_SERVER_ERROR, t));
            } else {
                this.fail(id, null, HttpStatus.INTERNAL_SERVER_ERROR, Http2Error.INTERNAL_ERROR, null, t);
                logger.warn("Unexpected exception:", t);
            }
        }
        finally {
            ReferenceCountUtil.release((Object)msg);
        }
    }

    private boolean handle100Continue(int id, HttpRequest nettyReq) {
        HttpHeaders nettyHeaders = nettyReq.headers();
        if (nettyReq.protocolVersion().compareTo(HttpVersion.HTTP_1_1) < 0) {
            return true;
        }
        String expectValue = nettyHeaders.get((CharSequence)HttpHeaderNames.EXPECT);
        if (expectValue == null) {
            return true;
        }
        if (!Ascii.equalsIgnoreCase("100-continue", expectValue)) {
            return false;
        }
        this.encoder.writeHeaders(id, 1, CONTINUE_RESPONSE, false);
        nettyHeaders.remove((CharSequence)HttpHeaderNames.EXPECT);
        return true;
    }

    private void fail(int id, @Nullable RequestHeaders headers, HttpStatus status, Http2Error error, @Nullable String message, @Nullable Throwable cause) {
        if (this.encoder.isResponseHeadersSent(id, 1)) {
            this.encoder.writeReset(id, 1, error);
        } else {
            this.fail(id, headers, status, message, cause);
        }
    }

    private void fail(int id, @Nullable RequestHeaders headers, HttpStatus status, @Nullable String message, @Nullable Throwable cause) {
        this.discarding = true;
        this.req = null;
        this.encoder.writeErrorResponse(id, 1, this.cfg.defaultVirtualHost().fallbackServiceConfig(), headers, status, message, cause);
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (evt instanceof HttpServerUpgradeHandler.UpgradeEvent) {
            ChannelPipeline pipeline = ctx.pipeline();
            ChannelHandlerContext connectionHandlerCtx = pipeline.context(Http2ServerConnectionHandler.class);
            Http2ServerConnectionHandler connectionHandler = (Http2ServerConnectionHandler)connectionHandlerCtx.handler();
            this.encoder.close();
            this.encoder = connectionHandler.getOrCreateResponseEncoder(connectionHandlerCtx);
            ctx.fireChannelRead((Object)DEFAULT_HTTP2_SETTINGS);
            HttpRequest nettyReq = ((HttpServerUpgradeHandler.UpgradeEvent)evt).upgradeRequest();
            nettyReq.headers().remove((CharSequence)HttpHeaderNames.CONNECTION);
            nettyReq.headers().remove((CharSequence)HttpHeaderNames.UPGRADE);
            nettyReq.headers().remove(Http2CodecUtil.HTTP_UPGRADE_SETTINGS_HEADER);
            if (logger.isDebugEnabled()) {
                logger.debug("{} Handling the pre-upgrade request ({}): {} {} {}", new Object[]{ctx.channel(), ((HttpServerUpgradeHandler.UpgradeEvent)evt).protocol(), nettyReq.method(), nettyReq.uri(), nettyReq.protocolVersion()});
            }
            this.channelRead(ctx, nettyReq);
            return;
        }
        if (evt instanceof InitiateConnectionShutdown && this.encoder instanceof ServerHttp1ObjectEncoder) {
            this.destroyKeepAliveHandler();
            ((ServerHttp1ObjectEncoder)this.encoder).initiateConnectionShutdown();
            return;
        }
        ctx.fireUserEventTriggered(evt);
    }

    private void maybeInitializeKeepAliveHandler(ChannelHandlerContext ctx) {
        KeepAliveHandler keepAliveHandler = this.encoder.keepAliveHandler();
        if (keepAliveHandler != NoopKeepAliveHandler.INSTANCE && ctx.channel().isActive() && ctx.channel().isRegistered()) {
            keepAliveHandler.initialize(ctx);
        }
    }

    private void destroyKeepAliveHandler() {
        if (this.encoder instanceof Http1ObjectEncoder) {
            this.encoder.keepAliveHandler().destroy();
        }
    }
}

