/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.HttpStatusException;
import com.linecorp.armeria.server.RoutingContext;
import com.linecorp.armeria.server.RoutingStatus;
import com.linecorp.armeria.server.ServiceRequestContext;

final class FallbackService
implements HttpService {
    static final FallbackService INSTANCE = new FallbackService();

    private FallbackService() {
    }

    @Override
    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        RoutingContext routingCtx = ctx.routingContext();
        HttpStatusException cause = FallbackService.getStatusException(routingCtx);
        if (cause.httpStatus() == HttpStatus.NOT_FOUND) {
            return FallbackService.handleNotFound(ctx, routingCtx, cause);
        }
        throw cause;
    }

    private static HttpStatusException getStatusException(RoutingContext routingCtx) {
        if (routingCtx.status() == RoutingStatus.CORS_PREFLIGHT) {
            return HttpStatusException.of(HttpStatus.FORBIDDEN);
        }
        HttpStatusException cause = routingCtx.deferredStatusException();
        if (cause == null) {
            return HttpStatusException.of(HttpStatus.NOT_FOUND);
        }
        return cause;
    }

    private static HttpResponse handleNotFound(ServiceRequestContext ctx, RoutingContext routingCtx, HttpStatusException cause) {
        String oldPath = routingCtx.path();
        if (oldPath.charAt(oldPath.length() - 1) == '/') {
            throw cause;
        }
        String newPath = oldPath + '/';
        if (!ctx.config().virtualHost().findServiceConfig(routingCtx.overridePath(newPath)).isPresent()) {
            throw cause;
        }
        String location = routingCtx.query() == null ? newPath : newPath + '?' + routingCtx.query();
        return HttpResponse.of(ResponseHeaders.builder(HttpStatus.TEMPORARY_REDIRECT).add((CharSequence)HttpHeaderNames.LOCATION, location).build());
    }
}

