/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.ArmeriaHttpUtil;
import com.linecorp.armeria.internal.server.RouteUtil;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.server.AbstractPathMapping;
import com.linecorp.armeria.server.PathMapping;
import com.linecorp.armeria.server.RoutePathType;
import com.linecorp.armeria.server.RoutingContext;
import com.linecorp.armeria.server.RoutingResult;
import com.linecorp.armeria.server.RoutingResultBuilder;
import java.util.List;
import java.util.Set;

final class ExactPathMapping
extends AbstractPathMapping {
    private final String prefix;
    private final String exactPath;
    private final List<String> paths;

    ExactPathMapping(String exactPath) {
        this("", exactPath);
    }

    private ExactPathMapping(String prefix, String exactPath) {
        this.prefix = prefix;
        this.exactPath = RouteUtil.ensureAbsolutePath(exactPath, "exactPath");
        this.paths = ImmutableList.of(exactPath, exactPath);
    }

    @Override
    PathMapping doWithPrefix(String prefix) {
        return new ExactPathMapping(prefix, ArmeriaHttpUtil.concatPaths(prefix, this.exactPath));
    }

    @Override
    @Nullable
    RoutingResultBuilder doApply(RoutingContext routingCtx) {
        return this.exactPath.equals(routingCtx.path()) ? RoutingResult.builder().path(ExactPathMapping.mappedPath(this.prefix, routingCtx.path())).query(routingCtx.query()) : null;
    }

    @Override
    public Set<String> paramNames() {
        return ImmutableSet.of();
    }

    @Override
    public String patternString() {
        return this.exactPath;
    }

    @Override
    public RoutePathType pathType() {
        return RoutePathType.EXACT;
    }

    @Override
    public List<String> paths() {
        return this.paths;
    }

    public int hashCode() {
        return this.exactPath.hashCode();
    }

    public boolean equals(@Nullable Object obj) {
        return obj instanceof ExactPathMapping && (this == obj || this.exactPath.equals(((ExactPathMapping)obj).exactPath));
    }
}

