/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.stream.SubscriptionOption;
import com.linecorp.armeria.server.DecodedHttpRequest;
import com.linecorp.armeria.server.Routed;
import com.linecorp.armeria.server.RoutingContext;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.ServiceRequestContext;
import io.netty.channel.EventLoop;
import io.netty.util.concurrent.EventExecutor;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;

final class EmptyContentDecodedHttpRequest
implements DecodedHttpRequest {
    private final HttpRequest delegate;
    private final EventLoop eventLoop;
    private final int id;
    private final int streamId;
    private final boolean keepAlive;
    private final RoutingContext routingContext;
    @Nullable
    private final Routed<ServiceConfig> routed;
    @Nullable
    private ServiceRequestContext ctx;
    @Nullable
    private HttpResponse response;
    private boolean isResponseAborted;

    EmptyContentDecodedHttpRequest(EventLoop eventLoop, int id, int streamId, RequestHeaders headers, boolean keepAlive, RoutingContext routingContext, @Nullable Routed<ServiceConfig> routed) {
        this.delegate = HttpRequest.of(headers);
        this.eventLoop = eventLoop;
        this.id = id;
        this.streamId = streamId;
        this.keepAlive = keepAlive;
        this.routingContext = routingContext;
        this.routed = routed;
    }

    @Override
    public void init(ServiceRequestContext ctx) {
        this.ctx = ctx;
    }

    @Override
    public RoutingContext routingContext() {
        return this.routingContext;
    }

    @Override
    public Routed<ServiceConfig> route() {
        return this.routed;
    }

    @Override
    public int id() {
        return this.id;
    }

    @Override
    public int streamId() {
        return this.streamId;
    }

    @Override
    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    @Override
    public boolean isOpen() {
        return this.delegate.isOpen();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public long demand() {
        return this.delegate.demand();
    }

    @Override
    public CompletableFuture<Void> whenComplete() {
        return this.delegate.whenComplete();
    }

    @Override
    public void subscribe(Subscriber<? super HttpObject> subscriber, EventExecutor executor) {
        this.delegate.subscribe(subscriber, executor);
    }

    @Override
    public void subscribe(Subscriber<? super HttpObject> subscriber, EventExecutor executor, SubscriptionOption ... options) {
        this.delegate.subscribe(subscriber, executor, options);
    }

    public EventLoop defaultSubscriberExecutor() {
        return this.eventLoop;
    }

    @Override
    public void abort() {
        this.delegate.abort();
    }

    @Override
    public void abort(Throwable cause) {
        this.delegate.abort(cause);
    }

    @Override
    public CompletableFuture<List<HttpObject>> collect(EventExecutor executor, SubscriptionOption ... options) {
        return this.delegate.collect(executor, options);
    }

    @Override
    public RequestHeaders headers() {
        return this.delegate.headers();
    }

    @Override
    public void close() {
    }

    @Override
    public void close(Throwable cause) {
    }

    @Override
    public void setResponse(HttpResponse response) {
        if (this.isResponseAborted) {
            if (!response.isComplete()) {
                response.abort();
            }
        } else {
            this.response = response;
        }
    }

    @Override
    public void abortResponse(Throwable cause, boolean cancel) {
        this.isResponseAborted = true;
        if (cancel && this.ctx != null) {
            this.ctx.cancel(cause);
        }
        if (this.response != null && !this.response.isComplete()) {
            this.response.abort(cause);
        }
    }

    @Override
    public boolean isAggregated() {
        return false;
    }
}

