/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.ContextAwareEventLoop;
import com.linecorp.armeria.common.ContextAwareScheduledExecutorService;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpHeadersBuilder;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.NonWrappingRequestContext;
import com.linecorp.armeria.common.QueryParams;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.RequestId;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.common.logging.RequestLogAccess;
import com.linecorp.armeria.common.logging.RequestLogBuilder;
import com.linecorp.armeria.common.util.TextFormatter;
import com.linecorp.armeria.common.util.TimeoutMode;
import com.linecorp.armeria.common.util.UnmodifiableFuture;
import com.linecorp.armeria.internal.common.CancellationScheduler;
import com.linecorp.armeria.internal.common.InitiateConnectionShutdown;
import com.linecorp.armeria.internal.common.util.TemporaryThreadLocals;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.server.ProxiedAddresses;
import com.linecorp.armeria.server.RoutingContext;
import com.linecorp.armeria.server.RoutingResult;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.ServiceRequestContext;
import io.micrometer.core.instrument.MeterRegistry;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.util.AttributeKey;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.net.ssl.SSLSession;

public final class DefaultServiceRequestContext
extends NonWrappingRequestContext
implements ServiceRequestContext {
    private static final AtomicReferenceFieldUpdater<DefaultServiceRequestContext, HttpHeaders> additionalResponseHeadersUpdater = AtomicReferenceFieldUpdater.newUpdater(DefaultServiceRequestContext.class, HttpHeaders.class, "additionalResponseHeaders");
    private static final AtomicReferenceFieldUpdater<DefaultServiceRequestContext, HttpHeaders> additionalResponseTrailersUpdater = AtomicReferenceFieldUpdater.newUpdater(DefaultServiceRequestContext.class, HttpHeaders.class, "additionalResponseTrailers");
    private static final InetSocketAddress UNKNOWN_ADDR = new InetSocketAddress("0.0.0.0", 1);
    private final Channel ch;
    private final ServiceConfig cfg;
    private final RoutingContext routingContext;
    private final RoutingResult routingResult;
    private final CancellationScheduler requestCancellationScheduler;
    @Nullable
    private final SSLSession sslSession;
    private final ProxiedAddresses proxiedAddresses;
    private final InetAddress clientAddress;
    private final RequestLogBuilder log;
    @Nullable
    private ContextAwareEventLoop contextAwareEventLoop;
    @Nullable
    private ContextAwareScheduledExecutorService blockingTaskExecutor;
    private long maxRequestLength;
    private volatile HttpHeaders additionalResponseHeaders;
    private volatile HttpHeaders additionalResponseTrailers;
    @Nullable
    private String strVal;

    public DefaultServiceRequestContext(ServiceConfig cfg, Channel ch, MeterRegistry meterRegistry, SessionProtocol sessionProtocol, RequestId id, RoutingContext routingContext, RoutingResult routingResult, HttpRequest req, @Nullable SSLSession sslSession, ProxiedAddresses proxiedAddresses, InetAddress clientAddress, long requestStartTimeNanos, long requestStartTimeMicros) {
        this(cfg, ch, meterRegistry, sessionProtocol, id, routingContext, routingResult, req, sslSession, proxiedAddresses, clientAddress, null, requestStartTimeNanos, requestStartTimeMicros, HttpHeaders.of(), HttpHeaders.of());
    }

    DefaultServiceRequestContext(ServiceConfig cfg, Channel ch, MeterRegistry meterRegistry, SessionProtocol sessionProtocol, RequestId id, RoutingContext routingContext, RoutingResult routingResult, HttpRequest req, @Nullable SSLSession sslSession, ProxiedAddresses proxiedAddresses, InetAddress clientAddress, @Nullable CancellationScheduler requestCancellationScheduler, long requestStartTimeNanos, long requestStartTimeMicros, HttpHeaders additionalResponseHeaders, HttpHeaders additionalResponseTrailers) {
        super(meterRegistry, sessionProtocol, id, Objects.requireNonNull(routingContext, "routingContext").method(), routingContext.path(), Objects.requireNonNull(routingResult, "routingResult").query(), Objects.requireNonNull(req, "req"), null, null);
        this.ch = Objects.requireNonNull(ch, "ch");
        this.cfg = Objects.requireNonNull(cfg, "cfg");
        this.routingContext = routingContext;
        this.routingResult = routingResult;
        this.requestCancellationScheduler = requestCancellationScheduler != null ? requestCancellationScheduler : new CancellationScheduler(TimeUnit.MILLISECONDS.toNanos(cfg.requestTimeoutMillis()));
        this.sslSession = sslSession;
        this.proxiedAddresses = Objects.requireNonNull(proxiedAddresses, "proxiedAddresses");
        this.clientAddress = Objects.requireNonNull(clientAddress, "clientAddress");
        this.log = RequestLog.builder(this);
        this.log.startRequest(requestStartTimeNanos, requestStartTimeMicros);
        this.log.session(ch, sessionProtocol, sslSession, null);
        this.log.requestHeaders(req.headers());
        this.log.requestFirstBytesTransferred();
        this.maxRequestLength = cfg.maxRequestLength();
        this.additionalResponseHeaders = additionalResponseHeaders;
        this.additionalResponseTrailers = additionalResponseTrailers;
    }

    @Override
    @Nullable
    public <V> V attr(AttributeKey<V> key) {
        return this.ownAttr(key);
    }

    @Override
    public Iterator<Map.Entry<AttributeKey<?>, Object>> attrs() {
        return this.ownAttrs();
    }

    @Override
    @Nonnull
    public <A extends SocketAddress> A remoteAddress() {
        SocketAddress addr = MoreObjects.firstNonNull(this.ch.remoteAddress(), UNKNOWN_ADDR);
        return (A)addr;
    }

    @Override
    @Nonnull
    public <A extends SocketAddress> A localAddress() {
        SocketAddress addr = MoreObjects.firstNonNull(this.ch.localAddress(), UNKNOWN_ADDR);
        return (A)addr;
    }

    @Override
    public InetAddress clientAddress() {
        return this.clientAddress;
    }

    @Override
    protected Channel channel() {
        return this.ch;
    }

    @Override
    public ServiceConfig config() {
        return this.cfg;
    }

    @Override
    public RoutingContext routingContext() {
        return this.routingContext;
    }

    @Override
    public Map<String, String> pathParams() {
        return this.routingResult.pathParams();
    }

    @Override
    public QueryParams queryParams() {
        return this.routingContext().params();
    }

    @Override
    public ContextAwareScheduledExecutorService blockingTaskExecutor() {
        if (this.blockingTaskExecutor != null) {
            return this.blockingTaskExecutor;
        }
        ScheduledExecutorService executor = this.config().blockingTaskExecutor();
        this.blockingTaskExecutor = ContextAwareScheduledExecutorService.of((RequestContext)this, executor);
        return this.blockingTaskExecutor;
    }

    @Override
    public String mappedPath() {
        return this.routingResult.path();
    }

    @Override
    public String decodedMappedPath() {
        return this.routingResult.decodedPath();
    }

    @Override
    @Nullable
    public MediaType negotiatedResponseMediaType() {
        return this.routingResult.negotiatedResponseMediaType();
    }

    @Override
    public ContextAwareEventLoop eventLoop() {
        if (this.contextAwareEventLoop != null) {
            return this.contextAwareEventLoop;
        }
        this.contextAwareEventLoop = ContextAwareEventLoop.of((RequestContext)this, this.ch.eventLoop());
        return this.contextAwareEventLoop;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.ch.alloc();
    }

    @Override
    @Nullable
    public SSLSession sslSession() {
        return this.sslSession;
    }

    @Override
    public long requestTimeoutMillis() {
        return TimeUnit.NANOSECONDS.toMillis(this.requestCancellationScheduler.timeoutNanos());
    }

    @Override
    public void clearRequestTimeout() {
        this.requestCancellationScheduler.clearTimeout();
    }

    @Override
    public void setRequestTimeoutMillis(TimeoutMode mode, long requestTimeoutMillis) {
        this.requestCancellationScheduler.setTimeoutNanos(Objects.requireNonNull(mode, "mode"), TimeUnit.MILLISECONDS.toNanos(requestTimeoutMillis));
    }

    @Override
    public void setRequestTimeout(TimeoutMode mode, Duration requestTimeout) {
        this.requestCancellationScheduler.setTimeoutNanos(Objects.requireNonNull(mode, "mode"), Objects.requireNonNull(requestTimeout, "requestTimeout").toNanos());
    }

    CancellationScheduler requestCancellationScheduler() {
        return this.requestCancellationScheduler;
    }

    @Override
    public void cancel(Throwable cause) {
        Objects.requireNonNull(cause, "cause");
        this.requestCancellationScheduler.finishNow(cause);
    }

    @Override
    @Nullable
    public Throwable cancellationCause() {
        return this.requestCancellationScheduler.cause();
    }

    @Override
    public CompletableFuture<Throwable> whenRequestCancelling() {
        return this.requestCancellationScheduler.whenCancelling();
    }

    @Override
    public CompletableFuture<Throwable> whenRequestCancelled() {
        return this.requestCancellationScheduler.whenCancelled();
    }

    @Override
    @Deprecated
    public CompletableFuture<Void> whenRequestTimingOut() {
        return this.requestCancellationScheduler.whenTimingOut();
    }

    @Override
    @Deprecated
    public CompletableFuture<Void> whenRequestTimedOut() {
        return this.requestCancellationScheduler.whenTimedOut();
    }

    @Override
    public long maxRequestLength() {
        return this.maxRequestLength;
    }

    @Override
    public void setMaxRequestLength(long maxRequestLength) {
        Preconditions.checkArgument(maxRequestLength >= 0L, "maxRequestLength: %s (expected: >= 0)", maxRequestLength);
        this.maxRequestLength = maxRequestLength;
    }

    @Override
    public HttpHeaders additionalResponseHeaders() {
        return this.additionalResponseHeaders;
    }

    @Override
    public void setAdditionalResponseHeader(CharSequence name, Object value) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(value, "value");
        this.mutateAdditionalResponseHeaders(additionalResponseHeadersUpdater, builder -> builder.setObject(name, value));
    }

    @Override
    public void addAdditionalResponseHeader(CharSequence name, Object value) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(value, "value");
        this.mutateAdditionalResponseHeaders(additionalResponseHeadersUpdater, builder -> builder.addObject(name, value));
    }

    @Override
    public void mutateAdditionalResponseHeaders(Consumer<HttpHeadersBuilder> mutator) {
        Objects.requireNonNull(mutator, "mutator");
        this.mutateAdditionalResponseHeaders(additionalResponseHeadersUpdater, mutator);
    }

    private void mutateAdditionalResponseHeaders(AtomicReferenceFieldUpdater<DefaultServiceRequestContext, HttpHeaders> atomicUpdater, Consumer<HttpHeadersBuilder> mutator) {
        HttpHeadersBuilder builder;
        HttpHeaders newValue;
        HttpHeaders oldValue;
        do {
            oldValue = atomicUpdater.get(this);
            builder = oldValue.toBuilder();
            mutator.accept(builder);
        } while (!atomicUpdater.compareAndSet(this, oldValue, newValue = builder.build()));
    }

    @Override
    public HttpHeaders additionalResponseTrailers() {
        return this.additionalResponseTrailers;
    }

    @Override
    public void setAdditionalResponseTrailer(CharSequence name, Object value) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(value, "value");
        this.mutateAdditionalResponseHeaders(additionalResponseTrailersUpdater, builder -> builder.setObject(name, value));
    }

    @Override
    public void addAdditionalResponseTrailer(CharSequence name, Object value) {
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(value, "value");
        this.mutateAdditionalResponseHeaders(additionalResponseTrailersUpdater, builder -> builder.addObject(name, value));
    }

    @Override
    public void mutateAdditionalResponseTrailers(Consumer<HttpHeadersBuilder> mutator) {
        Objects.requireNonNull(mutator, "mutator");
        this.mutateAdditionalResponseHeaders(additionalResponseTrailersUpdater, mutator);
    }

    @Override
    public ProxiedAddresses proxiedAddresses() {
        return this.proxiedAddresses;
    }

    @Override
    public CompletableFuture<Void> initiateConnectionShutdown(long drainDurationMicros) {
        return this.initiateConnectionShutdown(InitiateConnectionShutdown.of(drainDurationMicros));
    }

    @Override
    public CompletableFuture<Void> initiateConnectionShutdown() {
        return this.initiateConnectionShutdown(InitiateConnectionShutdown.of());
    }

    private CompletableFuture<Void> initiateConnectionShutdown(InitiateConnectionShutdown event) {
        if (!this.ch.isActive()) {
            return UnmodifiableFuture.completedFuture(null);
        }
        CompletableFuture<Void> completableFuture = new CompletableFuture<Void>();
        this.ch.closeFuture().addListener(f -> {
            if (f.cause() == null) {
                completableFuture.complete(null);
            } else {
                completableFuture.completeExceptionally(f.cause());
            }
        });
        this.ch.pipeline().fireUserEventTriggered((Object)event);
        return completableFuture;
    }

    @Override
    public RequestLogAccess log() {
        return this.log;
    }

    @Override
    public RequestLogBuilder logBuilder() {
        return this.log;
    }

    public String toString() {
        if (this.strVal != null) {
            return this.strVal;
        }
        return this.toStringSlow();
    }

    private String toStringSlow() {
        String sreqId = this.id().shortText();
        String chanId = this.ch.id().asShortText();
        InetSocketAddress raddr = (InetSocketAddress)this.remoteAddress();
        InetSocketAddress laddr = (InetSocketAddress)this.localAddress();
        InetAddress caddr = this.clientAddress();
        String proto = this.sessionProtocol().uriText();
        String authority = this.config().virtualHost().defaultHostname();
        String path = this.path();
        String method = this.method().name();
        try (TemporaryThreadLocals tempThreadLocals = TemporaryThreadLocals.acquire();){
            StringBuilder buf = tempThreadLocals.stringBuilder();
            buf.append("[sreqId=").append(sreqId).append(", chanId=").append(chanId);
            if (!Objects.equals(caddr, raddr.getAddress())) {
                buf.append(", caddr=");
                TextFormatter.appendInetAddress(buf, caddr);
            }
            buf.append(", raddr=");
            TextFormatter.appendSocketAddress(buf, raddr);
            buf.append(", laddr=");
            TextFormatter.appendSocketAddress(buf, laddr);
            buf.append("][").append(proto).append("://").append(authority).append(path).append('#').append(method).append(']');
            String string = this.strVal = buf.toString();
            return string;
        }
    }
}

