/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.SuccessFunction;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.BlockingTaskExecutor;
import com.linecorp.armeria.internal.server.annotation.AnnotatedService;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.Route;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.ServiceConfigBuilder;
import com.linecorp.armeria.server.ServiceConfigSetters;
import com.linecorp.armeria.server.ServiceNaming;
import com.linecorp.armeria.server.logging.AccessLogWriter;
import java.nio.file.Path;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;

final class DefaultServiceConfigSetters
implements ServiceConfigSetters {
    @Nullable
    private String defaultServiceName;
    @Nullable
    private ServiceNaming defaultServiceNaming;
    @Nullable
    private String defaultLogName;
    @Nullable
    private Long requestTimeoutMillis;
    @Nullable
    private Long maxRequestLength;
    @Nullable
    private Boolean verboseResponses;
    @Nullable
    private Function<? super HttpService, ? extends HttpService> decorator;
    @Nullable
    private AccessLogWriter accessLogWriter;
    @Nullable
    private ScheduledExecutorService blockingTaskExecutor;
    private boolean shutdownBlockingTaskExecutorOnStop;
    private boolean shutdownAccessLogWriterOnStop;
    @Nullable
    private SuccessFunction successFunction;
    @Nullable
    private Path multipartUploadsLocation;

    DefaultServiceConfigSetters() {
    }

    @Override
    public ServiceConfigSetters requestTimeout(Duration requestTimeout) {
        return this.requestTimeoutMillis(Objects.requireNonNull(requestTimeout, "requestTimeout").toMillis());
    }

    @Override
    public ServiceConfigSetters requestTimeoutMillis(long requestTimeoutMillis) {
        this.requestTimeoutMillis = ServiceConfig.validateRequestTimeoutMillis(requestTimeoutMillis);
        return this;
    }

    @Override
    public ServiceConfigSetters maxRequestLength(long maxRequestLength) {
        this.maxRequestLength = ServiceConfig.validateMaxRequestLength(maxRequestLength);
        return this;
    }

    @Override
    public ServiceConfigSetters verboseResponses(boolean verboseResponses) {
        this.verboseResponses = verboseResponses;
        return this;
    }

    @Override
    public ServiceConfigSetters accessLogFormat(String accessLogFormat) {
        return this.accessLogWriter(AccessLogWriter.custom(Objects.requireNonNull(accessLogFormat, "accessLogFormat")), true);
    }

    @Override
    public ServiceConfigSetters accessLogWriter(AccessLogWriter accessLogWriter, boolean shutdownOnStop) {
        this.accessLogWriter = Objects.requireNonNull(accessLogWriter, "accessLogWriter");
        this.shutdownAccessLogWriterOnStop = shutdownOnStop;
        return this;
    }

    @Override
    public ServiceConfigSetters decorator(Function<? super HttpService, ? extends HttpService> decorator) {
        Objects.requireNonNull(decorator, "decorator");
        this.decorator = this.decorator != null ? this.decorator.andThen(decorator) : decorator;
        return this;
    }

    Function<? super HttpService, ? extends HttpService> decorator() {
        if (this.decorator == null) {
            return Function.identity();
        }
        return this.decorator;
    }

    @Override
    @SafeVarargs
    public final ServiceConfigSetters decorators(Function<? super HttpService, ? extends HttpService> ... decorators) {
        return this.decorators(ImmutableList.copyOf(Objects.requireNonNull(decorators, "decorators")));
    }

    @Override
    public ServiceConfigSetters decorators(Iterable<? extends Function<? super HttpService, ? extends HttpService>> decorators) {
        Objects.requireNonNull(decorators, "decorators");
        ServiceConfigSetters ret = this;
        for (Function<? super HttpService, ? extends HttpService> function : decorators) {
            Objects.requireNonNull(function, "decorators contains null.");
            ret = this.decorator(function);
        }
        return ret;
    }

    @Override
    public ServiceConfigSetters defaultServiceName(String defaultServiceName) {
        Objects.requireNonNull(defaultServiceName, "defaultServiceName");
        this.defaultServiceName = defaultServiceName;
        this.defaultServiceNaming = ServiceNaming.of(defaultServiceName);
        return this;
    }

    @Override
    public ServiceConfigSetters defaultServiceNaming(ServiceNaming defaultServiceNaming) {
        this.defaultServiceName = null;
        this.defaultServiceNaming = Objects.requireNonNull(defaultServiceNaming, "defaultServiceNaming");
        return this;
    }

    @Override
    public ServiceConfigSetters defaultLogName(String defaultLogName) {
        this.defaultLogName = Objects.requireNonNull(defaultLogName, "defaultLogName");
        return this;
    }

    @Override
    public ServiceConfigSetters blockingTaskExecutor(ScheduledExecutorService blockingTaskExecutor, boolean shutdownOnStop) {
        this.blockingTaskExecutor = Objects.requireNonNull(blockingTaskExecutor, "blockingTaskExecutor");
        this.shutdownBlockingTaskExecutorOnStop = shutdownOnStop;
        return this;
    }

    @Override
    public ServiceConfigSetters blockingTaskExecutor(int numThreads) {
        Preconditions.checkArgument(numThreads >= 0, "numThreads: %s (expected: >= 0)", numThreads);
        BlockingTaskExecutor executor = BlockingTaskExecutor.builder().numThreads(numThreads).build();
        return this.blockingTaskExecutor(executor, true);
    }

    @Override
    public ServiceConfigSetters successFunction(SuccessFunction successFunction) {
        this.successFunction = Objects.requireNonNull(successFunction, "successFunction");
        return this;
    }

    @Override
    public ServiceConfigSetters multipartUploadsLocation(Path multipartUploadsLocation) {
        this.multipartUploadsLocation = Objects.requireNonNull(multipartUploadsLocation, "multipartUploadsLocation");
        return this;
    }

    ServiceConfigBuilder toServiceConfigBuilder(Route route, HttpService service) {
        ServiceConfigBuilder serviceConfigBuilder = new ServiceConfigBuilder(route, service);
        AnnotatedService annotatedService = this.defaultServiceNaming == null || this.defaultLogName == null ? service.as(AnnotatedService.class) : null;
        if (this.defaultServiceName != null) {
            serviceConfigBuilder.defaultServiceName(this.defaultServiceName);
        } else if (this.defaultServiceNaming != null) {
            serviceConfigBuilder.defaultServiceNaming(this.defaultServiceNaming);
        } else if (annotatedService != null && annotatedService.serviceNameSetByAnnotation()) {
            serviceConfigBuilder.defaultServiceName(annotatedService.serviceName());
        }
        if (this.defaultLogName != null) {
            serviceConfigBuilder.defaultLogName(this.defaultLogName);
        } else if (annotatedService != null) {
            serviceConfigBuilder.defaultLogName(annotatedService.methodName());
        }
        if (this.requestTimeoutMillis != null) {
            serviceConfigBuilder.requestTimeoutMillis(this.requestTimeoutMillis);
        }
        if (this.maxRequestLength != null) {
            serviceConfigBuilder.maxRequestLength(this.maxRequestLength);
        }
        if (this.verboseResponses != null) {
            serviceConfigBuilder.verboseResponses(this.verboseResponses);
        }
        if (this.accessLogWriter != null) {
            serviceConfigBuilder.accessLogWriter(this.accessLogWriter, this.shutdownAccessLogWriterOnStop);
        }
        if (this.blockingTaskExecutor != null) {
            serviceConfigBuilder.blockingTaskExecutor(this.blockingTaskExecutor, this.shutdownBlockingTaskExecutorOnStop);
        }
        if (this.successFunction != null) {
            serviceConfigBuilder.successFunction(this.successFunction);
        }
        if (this.multipartUploadsLocation != null) {
            serviceConfigBuilder.multipartUploadsLocation(this.multipartUploadsLocation);
        }
        return serviceConfigBuilder;
    }
}

