/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.server;

import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.InboundTrafficController;
import com.linecorp.armeria.server.AggregatingDecodedHttpRequest;
import com.linecorp.armeria.server.EmptyContentDecodedHttpRequest;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.Routed;
import com.linecorp.armeria.server.RoutingContext;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.StreamingDecodedHttpRequest;
import io.netty.channel.EventLoop;

interface DecodedHttpRequest
extends HttpRequest {
    public static DecodedHttpRequest of(boolean endOfStream, EventLoop eventLoop, int id, int streamId, RequestHeaders headers, boolean keepAlive, InboundTrafficController inboundTrafficController, RoutingContext routingCtx, @Nullable Routed<ServiceConfig> routed) {
        if (endOfStream || routed == null) {
            return new EmptyContentDecodedHttpRequest(eventLoop, id, streamId, headers, keepAlive, routingCtx, routed);
        }
        ServiceConfig config = routed.value();
        HttpService service = config.service();
        if (service.exchangeType(headers, routed.route()).isRequestStreaming()) {
            return new StreamingDecodedHttpRequest(eventLoop, id, streamId, headers, keepAlive, inboundTrafficController, config.maxRequestLength(), routingCtx, routed);
        }
        return new AggregatingDecodedHttpRequest(eventLoop, id, streamId, headers, keepAlive, config.maxRequestLength(), routingCtx, routed);
    }

    public int id();

    public int streamId();

    public boolean isKeepAlive();

    public void init(ServiceRequestContext var1);

    public RoutingContext routingContext();

    @Nullable
    public Routed<ServiceConfig> route();

    public void close();

    public void close(Throwable var1);

    public void setResponse(HttpResponse var1);

    public void abortResponse(Throwable var1, boolean var2);

    public boolean isAggregated();
}

