/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.jctools.queues;

import com.linecorp.armeria.internal.shaded.jctools.util.UnsafeAccess;
import com.linecorp.armeria.internal.shaded.jctools.util.UnsafeRefArrayAccess;

class MpUnboundedXaddChunk<R, E> {
    static final int NOT_USED = -1;
    private static final long PREV_OFFSET = UnsafeAccess.fieldOffset(MpUnboundedXaddChunk.class, "prev");
    private static final long NEXT_OFFSET = UnsafeAccess.fieldOffset(MpUnboundedXaddChunk.class, "next");
    private static final long INDEX_OFFSET = UnsafeAccess.fieldOffset(MpUnboundedXaddChunk.class, "index");
    private final boolean pooled;
    private final E[] buffer;
    private volatile R prev;
    private volatile long index;
    private volatile R next;

    MpUnboundedXaddChunk(long index, R prev, int size, boolean pooled) {
        this.buffer = UnsafeRefArrayAccess.allocateRefArray(size);
        this.soPrev(prev);
        this.spIndex(index);
        this.pooled = pooled;
    }

    final boolean isPooled() {
        return this.pooled;
    }

    final long lvIndex() {
        return this.index;
    }

    final void soIndex(long index) {
        UnsafeAccess.UNSAFE.putOrderedLong(this, INDEX_OFFSET, index);
    }

    final void spIndex(long index) {
        UnsafeAccess.UNSAFE.putLong(this, INDEX_OFFSET, index);
    }

    final R lvNext() {
        return this.next;
    }

    final void soNext(R value) {
        UnsafeAccess.UNSAFE.putOrderedObject(this, NEXT_OFFSET, value);
    }

    final R lvPrev() {
        return this.prev;
    }

    final void soPrev(R value) {
        UnsafeAccess.UNSAFE.putObject(this, PREV_OFFSET, value);
    }

    final void soElement(int index, E e) {
        UnsafeRefArrayAccess.soRefElement(this.buffer, UnsafeRefArrayAccess.calcRefElementOffset(index), e);
    }

    final E lvElement(int index) {
        return UnsafeRefArrayAccess.lvRefElement(this.buffer, UnsafeRefArrayAccess.calcRefElementOffset(index));
    }

    final E spinForElement(int index, boolean isNull) {
        E e;
        E[] buffer = this.buffer;
        long offset = UnsafeRefArrayAccess.calcRefElementOffset(index);
        while (isNull != ((e = UnsafeRefArrayAccess.lvRefElement(buffer, offset)) == null)) {
        }
        return e;
    }
}

