/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.guava.io;

import com.linecorp.armeria.internal.shaded.guava.base.Joiner;
import com.linecorp.armeria.internal.shaded.guava.base.Optional;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.base.Splitter;
import com.linecorp.armeria.internal.shaded.guava.collect.Lists;
import com.linecorp.armeria.internal.shaded.guava.graph.SuccessorsFunction;
import com.linecorp.armeria.internal.shaded.guava.io.ByteSource;
import com.linecorp.armeria.internal.shaded.guava.io.ByteStreams;
import com.linecorp.armeria.internal.shaded.guava.io.CharSource;
import com.linecorp.armeria.internal.shaded.guava.io.Closer;
import com.linecorp.armeria.internal.shaded.guava.io.LineProcessor;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class Files {
    private static final SuccessorsFunction<File> FILE_TREE = new SuccessorsFunction<File>(){};

    public static ByteSource asByteSource(File file) {
        return new FileByteSource(file);
    }

    public static CharSource asCharSource(File file, Charset charset) {
        return Files.asByteSource(file).asCharSource(charset);
    }

    public static List<String> readLines(File file, Charset charset) throws IOException {
        return Files.asCharSource(file, charset).readLines(new LineProcessor<List<String>>(){
            final List<String> result = Lists.newArrayList();

            @Override
            public boolean processLine(String line) {
                this.result.add(line);
                return true;
            }

            @Override
            public List<String> getResult() {
                return this.result;
            }
        });
    }

    public static String simplifyPath(String pathname) {
        Preconditions.checkNotNull(pathname);
        if (pathname.length() == 0) {
            return ".";
        }
        Iterable<String> components = Splitter.on('/').omitEmptyStrings().split(pathname);
        ArrayList<String> path = new ArrayList<String>();
        Iterator<String> iterator = components.iterator();
        block8: while (iterator.hasNext()) {
            String component;
            switch (component = iterator.next()) {
                case ".": {
                    continue block8;
                }
                case "..": {
                    if (path.size() > 0 && !((String)path.get(path.size() - 1)).equals("..")) {
                        path.remove(path.size() - 1);
                        continue block8;
                    }
                    path.add("..");
                    continue block8;
                }
            }
            path.add(component);
        }
        String result = Joiner.on('/').join(path);
        if (pathname.charAt(0) == '/') {
            String string = String.valueOf(result);
            String string2 = result = string.length() != 0 ? "/".concat(string) : new String("/");
        }
        while (result.startsWith("/../")) {
            result = result.substring(3);
        }
        if (result.equals("/..")) {
            result = "/";
        } else if ("".equals(result)) {
            result = ".";
        }
        return result;
    }

    private static final class FileByteSource
    extends ByteSource {
        private final File file;

        private FileByteSource(File file) {
            this.file = Preconditions.checkNotNull(file);
        }

        @Override
        public FileInputStream openStream() throws IOException {
            return new FileInputStream(this.file);
        }

        @Override
        public Optional<Long> sizeIfKnown() {
            if (this.file.isFile()) {
                return Optional.of(this.file.length());
            }
            return Optional.absent();
        }

        @Override
        public byte[] read() throws IOException {
            try (Closer closer = Closer.create();){
                FileInputStream in = closer.register(this.openStream());
                byte[] byArray = ByteStreams.toByteArray(in, in.getChannel().size());
                return byArray;
            }
        }

        public String toString() {
            String string = String.valueOf(this.file);
            return new StringBuilder(20 + String.valueOf(string).length()).append("Files.asByteSource(").append(string).append(")").toString();
        }
    }
}

