/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.guava.collect;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.linecorp.armeria.internal.shaded.guava.base.Function;
import com.linecorp.armeria.internal.shaded.guava.collect.ByFunctionOrdering;
import com.linecorp.armeria.internal.shaded.guava.collect.ComparatorOrdering;
import com.linecorp.armeria.internal.shaded.guava.collect.ExplicitOrdering;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.Lists;
import com.linecorp.armeria.internal.shaded.guava.collect.Maps;
import com.linecorp.armeria.internal.shaded.guava.collect.NaturalOrdering;
import com.linecorp.armeria.internal.shaded.guava.collect.ReverseOrdering;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public abstract class Ordering<T>
implements Comparator<T> {
    public static <C extends Comparable> Ordering<C> natural() {
        return NaturalOrdering.INSTANCE;
    }

    public static <T> Ordering<T> from(Comparator<T> comparator) {
        return comparator instanceof Ordering ? (Ordering<T>)comparator : new ComparatorOrdering<T>(comparator);
    }

    public static <T> Ordering<T> explicit(List<T> valuesInOrder) {
        return new ExplicitOrdering<T>(valuesInOrder);
    }

    public static <T> Ordering<T> explicit(T leastValue, T ... remainingValuesInOrder) {
        return Ordering.explicit(Lists.asList(leastValue, remainingValuesInOrder));
    }

    protected Ordering() {
    }

    public <S extends T> Ordering<S> reverse() {
        return new ReverseOrdering(this);
    }

    public <F> Ordering<F> onResultOf(Function<F, ? extends T> function) {
        return new ByFunctionOrdering<F, T>(function, this);
    }

    <T2 extends T> Ordering<Map.Entry<T2, ?>> onKeys() {
        return this.onResultOf(Maps.keyFunction());
    }

    @Override
    @CanIgnoreReturnValue
    public abstract int compare(T var1, T var2);

    public <E extends T> ImmutableList<E> immutableSortedCopy(Iterable<E> elements) {
        return ImmutableList.sortedCopyOf(this, elements);
    }

    static class IncomparableValueException
    extends ClassCastException {
        final Object value;

        IncomparableValueException(Object value) {
            String string = String.valueOf(value);
            super(new StringBuilder(22 + String.valueOf(string).length()).append("Cannot compare value: ").append(string).toString());
            this.value = value;
        }
    }
}

