/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.guava.collect;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;

final class CollectPreconditions {
    static void checkEntryNotNull(Object key, Object value) {
        if (key == null) {
            String string = String.valueOf(value);
            throw new NullPointerException(new StringBuilder(24 + String.valueOf(string).length()).append("null key in entry: null=").append(string).toString());
        }
        if (value == null) {
            String string = String.valueOf(key);
            throw new NullPointerException(new StringBuilder(26 + String.valueOf(string).length()).append("null value in entry: ").append(string).append("=null").toString());
        }
    }

    @CanIgnoreReturnValue
    static int checkNonnegative(int value, String name) {
        if (value < 0) {
            throw new IllegalArgumentException(new StringBuilder(40 + String.valueOf(name).length()).append(name).append(" cannot be negative but was: ").append(value).toString());
        }
        return value;
    }

    static void checkRemove(boolean canRemove) {
        Preconditions.checkState(canRemove, "no calls to next() since the last call to remove()");
    }
}

