/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.guava.base;

import com.linecorp.armeria.internal.shaded.guava.base.Ascii;
import com.linecorp.armeria.internal.shaded.guava.base.CharMatcher;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import java.util.Objects;

public abstract class CaseFormat
extends Enum<CaseFormat> {
    public static final /* enum */ CaseFormat LOWER_HYPHEN = new CaseFormat(CharMatcher.is('-'), "-"){

        @Override
        String normalizeWord(String word) {
            return Ascii.toLowerCase(word);
        }

        @Override
        String convert(CaseFormat format, String s) {
            if (format == LOWER_UNDERSCORE) {
                return s.replace('-', '_');
            }
            if (format == UPPER_UNDERSCORE) {
                return Ascii.toUpperCase(s.replace('-', '_'));
            }
            return super.convert(format, s);
        }
    };
    public static final /* enum */ CaseFormat LOWER_UNDERSCORE = new CaseFormat(CharMatcher.is('_'), "_"){

        @Override
        String normalizeWord(String word) {
            return Ascii.toLowerCase(word);
        }

        @Override
        String convert(CaseFormat format, String s) {
            if (format == LOWER_HYPHEN) {
                return s.replace('_', '-');
            }
            if (format == UPPER_UNDERSCORE) {
                return Ascii.toUpperCase(s);
            }
            return super.convert(format, s);
        }
    };
    public static final /* enum */ CaseFormat LOWER_CAMEL = new CaseFormat(CharMatcher.inRange('A', 'Z'), ""){

        @Override
        String normalizeWord(String word) {
            return CaseFormat.firstCharOnlyToUpper(word);
        }

        @Override
        String normalizeFirstWord(String word) {
            return Ascii.toLowerCase(word);
        }
    };
    public static final /* enum */ CaseFormat UPPER_CAMEL = new CaseFormat(CharMatcher.inRange('A', 'Z'), ""){

        @Override
        String normalizeWord(String word) {
            return CaseFormat.firstCharOnlyToUpper(word);
        }
    };
    public static final /* enum */ CaseFormat UPPER_UNDERSCORE = new CaseFormat(CharMatcher.is('_'), "_"){

        @Override
        String normalizeWord(String word) {
            return Ascii.toUpperCase(word);
        }

        @Override
        String convert(CaseFormat format, String s) {
            if (format == LOWER_HYPHEN) {
                return Ascii.toLowerCase(s.replace('_', '-'));
            }
            if (format == LOWER_UNDERSCORE) {
                return Ascii.toLowerCase(s);
            }
            return super.convert(format, s);
        }
    };
    private final CharMatcher wordBoundary;
    private final String wordSeparator;
    private static final /* synthetic */ CaseFormat[] $VALUES;

    private CaseFormat(CharMatcher wordBoundary, String wordSeparator) {
        this.wordBoundary = wordBoundary;
        this.wordSeparator = wordSeparator;
    }

    public final String to(CaseFormat format, String str) {
        Preconditions.checkNotNull(format);
        Preconditions.checkNotNull(str);
        return format == this ? str : this.convert(format, str);
    }

    String convert(CaseFormat format, String s) {
        StringBuilder out = null;
        int i = 0;
        int j = -1;
        while (true) {
            ++j;
            if ((j = this.wordBoundary.indexIn(s, j)) == -1) break;
            if (i == 0) {
                out = new StringBuilder(s.length() + 4 * format.wordSeparator.length());
                out.append(format.normalizeFirstWord(s.substring(i, j)));
            } else {
                ((StringBuilder)Objects.requireNonNull(out)).append(format.normalizeWord(s.substring(i, j)));
            }
            out.append(format.wordSeparator);
            i = j + this.wordSeparator.length();
        }
        return i == 0 ? format.normalizeFirstWord(s) : ((StringBuilder)Objects.requireNonNull(out)).append(format.normalizeWord(s.substring(i))).toString();
    }

    abstract String normalizeWord(String var1);

    String normalizeFirstWord(String word) {
        return this.normalizeWord(word);
    }

    private static String firstCharOnlyToUpper(String word) {
        String string;
        if (word.isEmpty()) {
            string = word;
        } else {
            char c = Ascii.toUpperCase(word.charAt(0));
            String string2 = Ascii.toLowerCase(word.substring(1));
            string = new StringBuilder(1 + String.valueOf(string2).length()).append(c).append(string2).toString();
        }
        return string;
    }

    private static /* synthetic */ CaseFormat[] $values() {
        return new CaseFormat[]{LOWER_HYPHEN, LOWER_UNDERSCORE, LOWER_CAMEL, UPPER_CAMEL, UPPER_UNDERSCORE};
    }

    static {
        $VALUES = CaseFormat.$values();
    }
}

