/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.server.annotation;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.common.RequestContextUtil;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.server.ServiceRequestContext;
import java.lang.annotation.Annotation;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;

final class KotlinUtil {
    private static final boolean IS_KOTLIN_REFLECTION_PRESENT;
    @Nullable
    private static final Class<? extends Annotation> METADATA_CLASS;
    @Nullable
    private static final Class<?> CONTINUATION_CLASS;
    @Nullable
    private static final MethodHandle CALL_KOTLIN_SUSPENDING_METHOD;
    @Nullable
    private static final Method IS_K_FUNCTION;
    @Nullable
    private static final Method IS_SUSPENDING_FUNCTION;
    @Nullable
    private static final Method IS_RETURN_TYPE_UNIT;
    @Nullable
    private static final Method IS_RETURN_TYPE_NOTHING;
    @Nullable
    private static final Method K_FUNCTION_RETURN_TYPE;
    @Nullable
    private static final Method K_FUNCTION_GENERIC_RETURN_TYPE;

    @Nullable
    static MethodHandle getCallKotlinSuspendingMethod() {
        return CALL_KOTLIN_SUSPENDING_METHOD;
    }

    static boolean isKotlinMethod(Method method) {
        return METADATA_CLASS != null && method.getDeclaringClass().getAnnotation(METADATA_CLASS) != null;
    }

    static boolean maybeSuspendingFunction(Method method) {
        return Arrays.stream(method.getParameters()).anyMatch(param -> KotlinUtil.isContinuation(param.getType()));
    }

    static boolean isKFunction(Method method) {
        try {
            return IS_KOTLIN_REFLECTION_PRESENT && IS_K_FUNCTION != null && KotlinUtil.isKotlinMethod(method) && (Boolean)IS_K_FUNCTION.invoke(null, method) != false;
        }
        catch (Exception e) {
            return false;
        }
    }

    static boolean isSuspendingFunction(Method method) {
        try {
            return IS_KOTLIN_REFLECTION_PRESENT && IS_SUSPENDING_FUNCTION != null && KotlinUtil.isKotlinMethod(method) && (Boolean)IS_SUSPENDING_FUNCTION.invoke(null, method) != false;
        }
        catch (Exception e) {
            return false;
        }
    }

    static boolean isContinuation(Class<?> type) {
        return CONTINUATION_CLASS != null && CONTINUATION_CLASS.isAssignableFrom(type);
    }

    static boolean isSuspendingAndReturnTypeUnit(Method method) {
        try {
            return KotlinUtil.isSuspendingFunction(method) && IS_RETURN_TYPE_UNIT != null && (Boolean)IS_RETURN_TYPE_UNIT.invoke(null, method) != false;
        }
        catch (Exception e) {
            return false;
        }
    }

    static boolean isReturnTypeNothing(Method method) {
        try {
            return IS_RETURN_TYPE_NOTHING != null && (Boolean)IS_RETURN_TYPE_NOTHING.invoke(null, method) != false;
        }
        catch (Exception e) {
            return false;
        }
    }

    static Class<?> kFunctionReturnType(Method method) {
        assert (K_FUNCTION_RETURN_TYPE != null);
        try {
            return (Class)K_FUNCTION_RETURN_TYPE.invoke(null, method);
        }
        catch (Exception e) {
            return (Class)Exceptions.throwUnsafely(e);
        }
    }

    static Type kFunctionGenericReturnType(Method method) {
        assert (K_FUNCTION_GENERIC_RETURN_TYPE != null);
        try {
            return (Type)K_FUNCTION_GENERIC_RETURN_TYPE.invoke(null, method);
        }
        catch (Exception e) {
            return (Type)Exceptions.throwUnsafely(e);
        }
    }

    private static Class<?> getClass(String name) throws ClassNotFoundException {
        return Class.forName(name, true, KotlinUtil.class.getClassLoader());
    }

    private KotlinUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        MethodHandle callKotlinSuspendingMethod = null;
        String internalCommonPackageName = RequestContextUtil.class.getPackage().getName();
        try {
            Class<?> coroutineUtilClass = KotlinUtil.getClass(internalCommonPackageName + ".kotlin.ArmeriaCoroutineUtil");
            callKotlinSuspendingMethod = MethodHandles.lookup().findStatic(coroutineUtilClass, "callKotlinSuspendingMethod", MethodType.methodType(CompletableFuture.class, ImmutableList.of(Method.class, Object.class, Object[].class, ExecutorService.class, ServiceRequestContext.class)));
        }
        catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException coroutineUtilClass) {
        }
        finally {
            CALL_KOTLIN_SUSPENDING_METHOD = callKotlinSuspendingMethod;
        }
        Method isKFunction = null;
        Method isSuspendingFunction = null;
        Method isReturnTypeUnit = null;
        Method isReturnTypeNothing = null;
        Method kFunctionReturnType = null;
        Method kFunctionGenericReturnType = null;
        try {
            Class<?> kotlinUtilClass = KotlinUtil.getClass(internalCommonPackageName + ".kotlin.ArmeriaKotlinUtil");
            isKFunction = kotlinUtilClass.getMethod("isKFunction", Method.class);
            isSuspendingFunction = kotlinUtilClass.getMethod("isSuspendingFunction", Method.class);
            isReturnTypeUnit = kotlinUtilClass.getMethod("isReturnTypeUnit", Method.class);
            isReturnTypeNothing = kotlinUtilClass.getMethod("isReturnTypeNothing", Method.class);
            kFunctionReturnType = kotlinUtilClass.getMethod("kFunctionReturnType", Method.class);
            kFunctionGenericReturnType = kotlinUtilClass.getMethod("kFunctionGenericReturnType", Method.class);
        }
        catch (ClassNotFoundException | NoSuchMethodException kotlinUtilClass) {
        }
        finally {
            IS_K_FUNCTION = isKFunction;
            IS_SUSPENDING_FUNCTION = isSuspendingFunction;
            IS_RETURN_TYPE_UNIT = isReturnTypeUnit;
            IS_RETURN_TYPE_NOTHING = isReturnTypeNothing;
            K_FUNCTION_RETURN_TYPE = kFunctionReturnType;
            K_FUNCTION_GENERIC_RETURN_TYPE = kFunctionGenericReturnType;
        }
        boolean isKotlinReflectionPresent = false;
        try {
            KotlinUtil.getClass("kotlin.reflect.full.KClasses");
            isKotlinReflectionPresent = true;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        finally {
            IS_KOTLIN_REFLECTION_PRESENT = isKotlinReflectionPresent;
        }
        Class<?> metadataClass = null;
        try {
            metadataClass = KotlinUtil.getClass("kotlin.Metadata");
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        finally {
            METADATA_CLASS = metadataClass;
        }
        Class<?> continuationClass = null;
        try {
            continuationClass = KotlinUtil.getClass("kotlin.coroutines.Continuation");
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        finally {
            CONTINUATION_CLASS = continuationClass;
        }
    }
}

