/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.server.annotation;

import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.multipart.Multipart;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableListMultimap;
import com.linecorp.armeria.internal.shaded.guava.collect.ListMultimap;
import com.linecorp.armeria.internal.shaded.guava.collect.Maps;
import com.linecorp.armeria.server.ServiceRequestContext;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;

final class FileAggregatedMultipart {
    private final ListMultimap<String, String> params;
    private final ListMultimap<String, Path> files;

    private FileAggregatedMultipart(ListMultimap<String, String> params, ListMultimap<String, Path> files) {
        this.params = params;
        this.files = files;
    }

    ListMultimap<String, String> params() {
        return this.params;
    }

    ListMultimap<String, Path> files() {
        return this.files;
    }

    static CompletableFuture<FileAggregatedMultipart> aggregateMultipart(ServiceRequestContext ctx, HttpRequest req) {
        Path multipartUploadsLocation = ctx.config().multipartUploadsLocation();
        return Multipart.from(req).collect(bodyPart -> {
            if (bodyPart.filename() != null) {
                ScheduledExecutorService blockingExecutorService = ctx.blockingTaskExecutor().withoutContext();
                return FileAggregatedMultipart.resolveTmpFile(multipartUploadsLocation.resolve("incomplete"), blockingExecutorService).thenComposeAsync(path -> ((CompletableFuture)bodyPart.writeTo((Path)path, new OpenOption[0]).thenCompose(ignore -> FileAggregatedMultipart.moveFile(path, multipartUploadsLocation.resolve("complete"), blockingExecutorService))).thenApply(completePath -> Maps.immutableEntry(bodyPart.name(), completePath)), (Executor)ctx.eventLoop());
            }
            return bodyPart.aggregate().thenApply(aggregatedBodyPart -> Maps.immutableEntry(bodyPart.name(), aggregatedBodyPart.contentUtf8()));
        }).thenApply(result -> {
            ImmutableListMultimap.Builder params = ImmutableListMultimap.builder();
            ImmutableListMultimap.Builder files = ImmutableListMultimap.builder();
            for (Map.Entry entry : result) {
                Object value = entry.getValue();
                if (value instanceof Path) {
                    files.put((String)entry.getKey(), (Path)value);
                    continue;
                }
                params.put((String)entry.getKey(), (String)value);
            }
            return new FileAggregatedMultipart((ListMultimap<String, String>)((Object)params.build()), (ListMultimap<String, Path>)((Object)files.build()));
        });
    }

    private static CompletableFuture<Path> moveFile(Path file, Path targetDirectory, ExecutorService blockingExecutorService) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Files.createDirectories(targetDirectory, new FileAttribute[0]);
                return Files.move(file, Files.createTempFile(targetDirectory, null, ".multipart", new FileAttribute[0]), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }, blockingExecutorService);
    }

    private static CompletableFuture<Path> resolveTmpFile(Path directory, ExecutorService blockingExecutorService) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                Files.createDirectories(directory, new FileAttribute[0]);
                return Files.createTempFile(directory, null, ".multipart", new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }, blockingExecutorService);
    }
}

