/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.server.annotation;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.server.annotation.AnnotatedObjectFactory;
import com.linecorp.armeria.internal.server.annotation.AnnotationUtil;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import com.linecorp.armeria.internal.shaded.guava.collect.Iterables;
import com.linecorp.armeria.internal.shaded.reflections.ReflectionUtils;
import com.linecorp.armeria.server.DecoratingHttpServiceFunction;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.annotation.Decorator;
import com.linecorp.armeria.server.annotation.DecoratorFactory;
import com.linecorp.armeria.server.annotation.DecoratorFactoryFunction;
import com.linecorp.armeria.server.annotation.Decorators;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Function;

public final class DecoratorAnnotationUtil {
    public static List<DecoratorAndOrder> collectDecorators(Class<?> clazz, Method method) {
        ArrayList<DecoratorAndOrder> decorators = new ArrayList<DecoratorAndOrder>();
        DecoratorAnnotationUtil.collectDecorators(decorators, AnnotationUtil.getAllAnnotations(clazz));
        DecoratorAnnotationUtil.collectDecorators(decorators, AnnotationUtil.getAllAnnotations(method));
        decorators.sort(Comparator.comparing(DecoratorAndOrder::order));
        return decorators;
    }

    private static void collectDecorators(List<DecoratorAndOrder> list, List<Annotation> annotations) {
        if (annotations.isEmpty()) {
            return;
        }
        for (Annotation annotation : annotations) {
            if (annotation instanceof Decorator) {
                Decorator d = (Decorator)annotation;
                list.add(new DecoratorAndOrder(d, DecoratorAnnotationUtil.newDecorator(d), d.order()));
                continue;
            }
            if (annotation instanceof Decorators) {
                Decorator[] decorators;
                for (Decorator d : decorators = ((Decorators)annotation).value()) {
                    list.add(new DecoratorAndOrder(d, DecoratorAnnotationUtil.newDecorator(d), d.order()));
                }
                continue;
            }
            DecoratorAndOrder udd = DecoratorAnnotationUtil.userDefinedDecorator(annotation);
            if (udd != null) {
                list.add(udd);
                continue;
            }
            try {
                Annotation decorator;
                Annotation[] decorators;
                Method method = Iterables.getFirst(ReflectionUtils.getMethods(annotation.annotationType(), ReflectionUtils.withName("value")), null);
                assert (method != null) : "No 'value' method is found from " + annotation;
                Annotation[] annotationArray = decorators = (Annotation[])method.invoke((Object)annotation, new Object[0]);
                int n = annotationArray.length;
                for (int i = 0; i < n && (udd = DecoratorAnnotationUtil.userDefinedDecorator(decorator = annotationArray[i])) != null; ++i) {
                    list.add(udd);
                }
            }
            catch (Throwable throwable) {
            }
        }
    }

    public static HttpService applyDecorators(List<DecoratorAndOrder> decorators, HttpService delegate) {
        Function<HttpService, HttpService> decorator = Function.identity();
        for (int i = decorators.size() - 1; i >= 0; --i) {
            DecoratorAndOrder d = decorators.get(i);
            decorator = decorator.andThen(d.decorator());
        }
        return (HttpService)decorator.apply(delegate);
    }

    @Nullable
    private static DecoratorAndOrder userDefinedDecorator(Annotation annotation) {
        DecoratorFactory d = AnnotationUtil.findFirstDeclared(annotation.annotationType(), DecoratorFactory.class);
        if (d == null) {
            return null;
        }
        DecoratorFactoryFunction factory = AnnotatedObjectFactory.getInstance(d, DecoratorFactoryFunction.class);
        int order = 0;
        try {
            Object value;
            Method method = Iterables.getFirst(ReflectionUtils.getMethods(annotation.annotationType(), ReflectionUtils.withName("order")), null);
            if (method != null && (value = method.invoke((Object)annotation, new Object[0])) instanceof Integer) {
                order = (Integer)value;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return new DecoratorAndOrder(annotation, factory.newDecorator(annotation), order);
    }

    private static Function<? super HttpService, ? extends HttpService> newDecorator(Decorator decorator) {
        return service -> service.decorate(AnnotatedObjectFactory.getInstance(decorator, DecoratingHttpServiceFunction.class));
    }

    private DecoratorAnnotationUtil() {
    }

    public static final class DecoratorAndOrder {
        private final Annotation annotation;
        private final Function<? super HttpService, ? extends HttpService> decorator;
        private final int order;

        private DecoratorAndOrder(Annotation annotation, Function<? super HttpService, ? extends HttpService> decorator, int order) {
            this.annotation = annotation;
            this.decorator = decorator;
            this.order = order;
        }

        public Annotation annotation() {
            return this.annotation;
        }

        public Function<? super HttpService, ? extends HttpService> decorator() {
            return this.decorator;
        }

        public int order() {
            return this.order;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this).add("annotation", this.annotation()).add("decorator", this.decorator()).add("order", this.order()).toString();
        }
    }
}

