/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.server.annotation;

import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpHeadersBuilder;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.ArmeriaHttpUtil;
import com.linecorp.armeria.internal.server.RouteUtil;
import com.linecorp.armeria.internal.server.annotation.AnnotatedObjectFactory;
import com.linecorp.armeria.internal.server.annotation.AnnotatedService;
import com.linecorp.armeria.internal.server.annotation.AnnotatedServiceElement;
import com.linecorp.armeria.internal.server.annotation.AnnotatedValueResolver;
import com.linecorp.armeria.internal.server.annotation.AnnotationUtil;
import com.linecorp.armeria.internal.server.annotation.DecoratorAnnotationUtil;
import com.linecorp.armeria.internal.server.annotation.DefaultValues;
import com.linecorp.armeria.internal.server.annotation.KotlinUtil;
import com.linecorp.armeria.internal.server.annotation.ProcessedDocumentationHelper;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.cache.Cache;
import com.linecorp.armeria.internal.shaded.guava.cache.CacheBuilder;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableCollection;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.internal.shaded.guava.collect.Iterables;
import com.linecorp.armeria.internal.shaded.guava.collect.Sets;
import com.linecorp.armeria.internal.shaded.guava.collect.Streams;
import com.linecorp.armeria.internal.shaded.reflections.ReflectionUtils;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.Route;
import com.linecorp.armeria.server.annotation.AdditionalHeader;
import com.linecorp.armeria.server.annotation.AdditionalTrailer;
import com.linecorp.armeria.server.annotation.Blocking;
import com.linecorp.armeria.server.annotation.Consumes;
import com.linecorp.armeria.server.annotation.Delete;
import com.linecorp.armeria.server.annotation.Description;
import com.linecorp.armeria.server.annotation.ExceptionHandler;
import com.linecorp.armeria.server.annotation.ExceptionHandlerFunction;
import com.linecorp.armeria.server.annotation.Get;
import com.linecorp.armeria.server.annotation.Head;
import com.linecorp.armeria.server.annotation.MatchesHeader;
import com.linecorp.armeria.server.annotation.MatchesParam;
import com.linecorp.armeria.server.annotation.Options;
import com.linecorp.armeria.server.annotation.Order;
import com.linecorp.armeria.server.annotation.Patch;
import com.linecorp.armeria.server.annotation.Path;
import com.linecorp.armeria.server.annotation.PathPrefix;
import com.linecorp.armeria.server.annotation.Post;
import com.linecorp.armeria.server.annotation.Produces;
import com.linecorp.armeria.server.annotation.Put;
import com.linecorp.armeria.server.annotation.RequestConverter;
import com.linecorp.armeria.server.annotation.RequestConverterFunction;
import com.linecorp.armeria.server.annotation.RequestObject;
import com.linecorp.armeria.server.annotation.ResponseConverter;
import com.linecorp.armeria.server.annotation.ResponseConverterFunction;
import com.linecorp.armeria.server.annotation.StatusCode;
import com.linecorp.armeria.server.annotation.Trace;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AnnotatedServiceFactory {
    private static final Logger logger = LoggerFactory.getLogger(AnnotatedServiceFactory.class);
    private static final Cache<String, Properties> DOCUMENTATION_PROPERTIES_CACHE = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(30L, TimeUnit.SECONDS).build();
    private static final Map<Class<?>, HttpMethod> HTTP_METHOD_MAP = ImmutableMap.builder().put(Options.class, HttpMethod.OPTIONS).put(Get.class, HttpMethod.GET).put(Head.class, HttpMethod.HEAD).put(Post.class, HttpMethod.POST).put(Put.class, HttpMethod.PUT).put(Patch.class, HttpMethod.PATCH).put(Delete.class, HttpMethod.DELETE).put(Trace.class, HttpMethod.TRACE).build();

    public static List<AnnotatedServiceElement> find(String pathPrefix, Object object, boolean useBlockingTaskExecutor, @Nullable String queryDelimiter, List<RequestConverterFunction> requestConverterFunctions, List<ResponseConverterFunction> responseConverterFunctions, List<ExceptionHandlerFunction> exceptionHandlerFunctions) {
        List<Method> methods = AnnotatedServiceFactory.requestMappingMethods(object);
        return methods.stream().flatMap(method -> AnnotatedServiceFactory.create(pathPrefix, object, method, useBlockingTaskExecutor, queryDelimiter, requestConverterFunctions, responseConverterFunctions, exceptionHandlerFunctions).stream()).collect(ImmutableList.toImmutableList());
    }

    private static HttpStatus defaultResponseStatus(Method method) {
        StatusCode statusCodeAnnotation = AnnotationUtil.findFirst(method, StatusCode.class);
        if (statusCodeAnnotation == null) {
            Class<?> returnType = method.getReturnType();
            return returnType == Void.class || returnType == Void.TYPE || KotlinUtil.isSuspendingAndReturnTypeUnit(method) ? HttpStatus.NO_CONTENT : HttpStatus.OK;
        }
        int statusCode = statusCodeAnnotation.value();
        Preconditions.checkArgument(statusCode >= 0, "invalid HTTP status code: %s (expected: >= 0)", statusCode);
        return HttpStatus.valueOf(statusCode);
    }

    private static <T extends Annotation> void setAdditionalHeader(HttpHeadersBuilder headers, AnnotatedElement element, String clsAlias, String elementAlias, String level, Class<T> annotation, Function<T, String> nameGetter, Function<T, String[]> valueGetter) {
        Objects.requireNonNull(headers, "headers");
        Objects.requireNonNull(element, "element");
        Objects.requireNonNull(level, "level");
        HashSet addedHeaderSets = new HashSet();
        AnnotationUtil.findAll(element, annotation).forEach(header -> {
            String name = (String)nameGetter.apply(header);
            String[] value = (String[])valueGetter.apply(header);
            if (addedHeaderSets.contains(name)) {
                logger.warn("The additional {} named '{}' at '{}' is set at the same {} level already;ignoring.", new Object[]{clsAlias, name, elementAlias, level});
                return;
            }
            headers.set((CharSequence)HttpHeaderNames.of(name), value);
            addedHeaderSets.add(name);
        });
    }

    static List<AnnotatedServiceElement> create(String pathPrefix, Object object, Method method, boolean useBlockingTaskExecutor, @Nullable String queryDelimiter, List<RequestConverterFunction> baseRequestConverters, List<ResponseConverterFunction> baseResponseConverters, List<ExceptionHandlerFunction> baseExceptionHandlers) {
        if (KotlinUtil.getCallKotlinSuspendingMethod() == null && KotlinUtil.maybeSuspendingFunction(method)) {
            throw new IllegalArgumentException("Kotlin suspending functions are supported only when you added 'armeria-kotlin' as a dependency.\nSee https://armeria.dev/docs/server-annotated-service#kotlin-coroutines-support for more information.");
        }
        Set<Annotation> methodAnnotations = AnnotatedServiceFactory.httpMethodAnnotations(method);
        if (methodAnnotations.isEmpty()) {
            throw new IllegalArgumentException("HTTP Method specification is missing: " + method.getName());
        }
        Class<?> clazz = object.getClass();
        Map<HttpMethod, List<String>> httpMethodPatternsMap = AnnotatedServiceFactory.getHttpMethodPatternsMap(method, methodAnnotations);
        String computedPathPrefix = AnnotatedServiceFactory.computePathPrefix(clazz, pathPrefix);
        Set<MediaType> consumableMediaTypes = AnnotatedServiceFactory.consumableMediaTypes(method, clazz);
        Set<MediaType> producibleMediaTypes = AnnotatedServiceFactory.producibleMediaTypes(method, clazz);
        List routes = httpMethodPatternsMap.entrySet().stream().flatMap(pattern -> {
            HttpMethod httpMethod = (HttpMethod)((Object)((Object)pattern.getKey()));
            List pathMappings = (List)pattern.getValue();
            return pathMappings.stream().map(pathMapping -> Route.builder().path(computedPathPrefix, (String)pathMapping).methods(httpMethod).consumes(consumableMediaTypes).produces(producibleMediaTypes).matchesParams((Iterable<String>)AnnotatedServiceFactory.predicates(method, clazz, MatchesParam.class, MatchesParam::value)).matchesHeaders((Iterable<String>)AnnotatedServiceFactory.predicates(method, clazz, MatchesHeader.class, MatchesHeader::value)).build());
        }).collect(ImmutableList.toImmutableList());
        ImmutableCollection req = ((ImmutableList.Builder)AnnotatedServiceFactory.getAnnotatedInstances(method, clazz, RequestConverter.class, RequestConverterFunction.class).addAll(baseRequestConverters)).build();
        ImmutableCollection res = ((ImmutableList.Builder)AnnotatedServiceFactory.getAnnotatedInstances(method, clazz, ResponseConverter.class, ResponseConverterFunction.class).addAll(baseResponseConverters)).build();
        ImmutableCollection eh = ((ImmutableList.Builder)AnnotatedServiceFactory.getAnnotatedInstances(method, clazz, ExceptionHandler.class, ExceptionHandlerFunction.class).addAll(baseExceptionHandlers)).build();
        HttpStatus defaultStatus = AnnotatedServiceFactory.defaultResponseStatus(method);
        HttpHeadersBuilder defaultHeaders = HttpHeaders.builder();
        HttpHeadersBuilder defaultTrailers = HttpHeaders.builder();
        String classAlias = clazz.getName();
        String methodAlias = String.format("%s.%s()", classAlias, method.getName());
        AnnotatedServiceFactory.setAdditionalHeader(defaultHeaders, clazz, "header", classAlias, "class", AdditionalHeader.class, AdditionalHeader::name, AdditionalHeader::value);
        AnnotatedServiceFactory.setAdditionalHeader(defaultHeaders, method, "header", methodAlias, "method", AdditionalHeader.class, AdditionalHeader::name, AdditionalHeader::value);
        AnnotatedServiceFactory.setAdditionalHeader(defaultTrailers, clazz, "trailer", classAlias, "class", AdditionalTrailer.class, AdditionalTrailer::name, AdditionalTrailer::value);
        AnnotatedServiceFactory.setAdditionalHeader(defaultTrailers, method, "trailer", methodAlias, "method", AdditionalTrailer.class, AdditionalTrailer::name, AdditionalTrailer::value);
        if (defaultStatus.isContentAlwaysEmpty() && !defaultTrailers.isEmpty()) {
            logger.warn("A response with HTTP status code '{}' cannot have a content. Trailers defined at '{}' might be ignored if HTTP/1.1 is used.", (Object)defaultStatus.code(), (Object)methodAlias);
        }
        HttpHeaders responseHeaders = defaultHeaders.build();
        HttpHeaders responseTrailers = defaultTrailers.build();
        boolean needToUseBlockingTaskExecutor = useBlockingTaskExecutor || AnnotationUtil.findFirst(method, Blocking.class) != null || AnnotationUtil.findFirst(object.getClass(), Blocking.class) != null;
        return routes.stream().map(arg_0 -> AnnotatedServiceFactory.lambda$create$4((List)((Object)req), method, clazz, needToUseBlockingTaskExecutor, queryDelimiter, object, (List)((Object)eh), (List)((Object)res), defaultStatus, responseHeaders, responseTrailers, arg_0)).collect(ImmutableList.toImmutableList());
    }

    private static List<AnnotatedValueResolver> getAnnotatedValueResolvers(List<RequestConverterFunction> req, Route route, Method method, Class<?> clazz, boolean useBlockingExecutor, @Nullable String queryDelimiter) {
        List<Object> resolvers;
        Set<String> expectedParamNames = route.paramNames();
        try {
            resolvers = AnnotatedValueResolver.ofServiceMethod(method, expectedParamNames, AnnotatedValueResolver.toRequestObjectResolvers(req, method), useBlockingExecutor, queryDelimiter);
        }
        catch (AnnotatedValueResolver.NoParameterException ignored) {
            resolvers = ImmutableList.of();
        }
        Set requiredParamNames = resolvers.stream().filter(AnnotatedValueResolver::isPathVariable).map(AnnotatedValueResolver::httpElementName).collect(ImmutableSet.toImmutableSet());
        if (!expectedParamNames.containsAll(requiredParamNames)) {
            Sets.SetView missing = Sets.difference(requiredParamNames, expectedParamNames);
            throw new IllegalArgumentException("cannot find path variables: " + missing);
        }
        if (resolvers.stream().noneMatch(r -> r.annotationType() == RequestObject.class) && !requiredParamNames.containsAll(expectedParamNames)) {
            Sets.SetView<String> missing = Sets.difference(expectedParamNames, requiredParamNames);
            logger.warn("Some path variables of the method '" + method.getName() + "' of the class '" + clazz.getName() + "' do not have their corresponding parameters annotated with @Param. They would not be automatically injected: " + missing);
        }
        return resolvers;
    }

    private static List<Method> requestMappingMethods(Object object) {
        return ReflectionUtils.getAllMethods(object.getClass(), ReflectionUtils.withModifier(1)).stream().filter(m -> AnnotationUtil.getAnnotations((AnnotatedElement)m, AnnotationUtil.FindOption.LOOKUP_SUPER_CLASSES).stream().map(Annotation::annotationType).anyMatch(a -> a == Path.class || HTTP_METHOD_MAP.containsKey(a))).sorted(Comparator.comparingInt(AnnotatedServiceFactory::order)).collect(ImmutableList.toImmutableList());
    }

    private static int order(Method method) {
        Order order = AnnotationUtil.findFirst(method, Order.class);
        return order != null ? order.value() : 0;
    }

    private static Set<Annotation> httpMethodAnnotations(Method method) {
        return AnnotationUtil.getAnnotations((AnnotatedElement)method, AnnotationUtil.FindOption.LOOKUP_SUPER_CLASSES).stream().filter(annotation -> HTTP_METHOD_MAP.containsKey(annotation.annotationType())).collect(Collectors.toSet());
    }

    private static Set<MediaType> consumableMediaTypes(Method method, Class<?> clazz) {
        List<Consumes> consumes = AnnotationUtil.findAll(method, Consumes.class);
        if (consumes.isEmpty()) {
            consumes = AnnotationUtil.findAll(clazz, Consumes.class);
        }
        List types = consumes.stream().map(Consumes::value).map(MediaType::parse).collect(ImmutableList.toImmutableList());
        return AnnotatedServiceFactory.listToSet(types, Consumes.class);
    }

    private static Set<MediaType> producibleMediaTypes(Method method, Class<?> clazz) {
        List<Produces> produces = AnnotationUtil.findAll(method, Produces.class);
        if (produces.isEmpty()) {
            produces = AnnotationUtil.findAll(clazz, Produces.class);
        }
        List types = produces.stream().map(Produces::value).map(MediaType::parse).peek(type -> {
            if (type.hasWildcard()) {
                throw new IllegalArgumentException("Producible media types must not have a wildcard: " + type);
            }
        }).collect(ImmutableList.toImmutableList());
        return AnnotatedServiceFactory.listToSet(types, Produces.class);
    }

    private static <T extends Annotation> List<String> predicates(Method method, Class<?> clazz, Class<T> annotationType, Function<T, String> toStringPredicate) {
        List<T> classLevel = AnnotationUtil.findAll(clazz, annotationType);
        List<T> methodLevel = AnnotationUtil.findAll(method, annotationType);
        return Streams.concat(classLevel.stream(), methodLevel.stream()).map(toStringPredicate).collect(ImmutableList.toImmutableList());
    }

    private static Set<MediaType> listToSet(List<MediaType> types, Class<?> annotationClass) {
        LinkedHashSet<MediaType> set = new LinkedHashSet<MediaType>();
        for (MediaType type : types) {
            if (set.add(type)) continue;
            throw new IllegalArgumentException("Duplicated media type for @" + annotationClass.getSimpleName() + ": " + type);
        }
        return ImmutableSet.copyOf(set);
    }

    private static Map<HttpMethod, List<String>> getHttpMethodPatternsMap(Method method, Set<Annotation> methodAnnotations) {
        List pathPatterns = AnnotationUtil.findAll(method, Path.class).stream().map(Path::value).collect(ImmutableList.toImmutableList());
        boolean usePathPatterns = !pathPatterns.isEmpty();
        Map<HttpMethod, List<String>> httpMethodAnnotatedPatternMap = AnnotatedServiceFactory.getHttpMethodAnnotatedPatternMap(methodAnnotations);
        if (httpMethodAnnotatedPatternMap.isEmpty()) {
            throw new IllegalArgumentException(method.getDeclaringClass().getName() + '#' + method.getName() + " must have an HTTP method annotation.");
        }
        return httpMethodAnnotatedPatternMap.entrySet().stream().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, entry -> {
            List httpMethodPaths = (List)entry.getValue();
            if (usePathPatterns && !httpMethodPaths.isEmpty()) {
                throw new IllegalArgumentException(method.getDeclaringClass().getName() + '#' + method.getName() + " cannot specify both an HTTP mapping and a Path mapping.");
            }
            if (usePathPatterns) {
                httpMethodPaths.addAll(pathPatterns);
            } else if (httpMethodPaths.isEmpty()) {
                httpMethodPaths.add("");
            }
            return ImmutableList.copyOf(httpMethodPaths);
        }));
    }

    private static Map<HttpMethod, List<String>> getHttpMethodAnnotatedPatternMap(Set<Annotation> methodAnnotations) {
        EnumMap<HttpMethod, List<String>> httpMethodPatternMap = new EnumMap<HttpMethod, List<String>>(HttpMethod.class);
        methodAnnotations.stream().filter(annotation -> HTTP_METHOD_MAP.containsKey(annotation.annotationType())).forEach(annotation -> {
            HttpMethod httpMethod = HTTP_METHOD_MAP.get(annotation.annotationType());
            String value = (String)AnnotatedServiceFactory.invokeValueMethod(annotation);
            List patterns = httpMethodPatternMap.computeIfAbsent(httpMethod, ignored -> new ArrayList());
            if (DefaultValues.isSpecified(value)) {
                patterns.add(value);
            }
        });
        return httpMethodPatternMap;
    }

    private static Function<? super HttpService, ? extends HttpService> decorator(Method method, Class<?> clazz) {
        List<DecoratorAnnotationUtil.DecoratorAndOrder> decorators = DecoratorAnnotationUtil.collectDecorators(clazz, method);
        Function decorator = Function.identity();
        for (int i = decorators.size() - 1; i >= 0; --i) {
            DecoratorAnnotationUtil.DecoratorAndOrder d = decorators.get(i);
            decorator = decorator.andThen(d.decorator());
        }
        return decorator;
    }

    private static <T extends Annotation, R> ImmutableList.Builder<R> getAnnotatedInstances(AnnotatedElement method, AnnotatedElement clazz, Class<T> annotationType, Class<R> resultType) {
        ImmutableList.Builder builder = new ImmutableList.Builder();
        Stream.concat(AnnotationUtil.findAll(method, annotationType).stream(), AnnotationUtil.findAll(clazz, annotationType).stream()).forEach(annotation -> builder.add(AnnotatedObjectFactory.getInstance(annotation, resultType)));
        return builder;
    }

    private static Object invokeValueMethod(Annotation a) {
        try {
            Method method = Iterables.getFirst(ReflectionUtils.getMethods(a.annotationType(), ReflectionUtils.withName("value")), null);
            assert (method != null) : "No 'value' method is found from " + a;
            return method.invoke((Object)a, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("An annotation @" + a.annotationType().getSimpleName() + " must have a 'value' method", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    static String findDescription(AnnotatedElement annotatedElement) {
        Objects.requireNonNull(annotatedElement, "annotatedElement");
        Description description = AnnotationUtil.findFirst(annotatedElement, Description.class);
        if (description != null) {
            String value = description.value();
            if (!DefaultValues.isSpecified(value)) return null;
            Preconditions.checkArgument(!value.isEmpty(), "value is empty.");
            return value;
        }
        if (!(annotatedElement instanceof Parameter)) return null;
        Parameter parameter = (Parameter)annotatedElement;
        Executable executable = parameter.getDeclaringExecutable();
        Class<?> clazz = executable.getDeclaringClass();
        String fileName = ProcessedDocumentationHelper.getFileName(clazz.getCanonicalName());
        String propertyName = executable.getName() + '.' + parameter.getName();
        Properties cachedProperties = DOCUMENTATION_PROPERTIES_CACHE.getIfPresent(fileName);
        if (cachedProperties != null) {
            return cachedProperties.getProperty(propertyName);
        }
        try (InputStream stream = AnnotatedServiceFactory.class.getClassLoader().getResourceAsStream(fileName);){
            if (stream == null) {
                String string2 = null;
                return string2;
            }
            Properties properties = new Properties();
            properties.load(stream);
            DOCUMENTATION_PROPERTIES_CACHE.put(fileName, properties);
            String string = properties.getProperty(propertyName);
            return string;
        }
        catch (IOException exception) {
            logger.warn("Failed to load an API description file: {}", (Object)fileName, (Object)exception);
        }
        return null;
    }

    private static String computePathPrefix(Class<?> clazz, String pathPrefix) {
        RouteUtil.ensureAbsolutePath(pathPrefix, "pathPrefix");
        PathPrefix pathPrefixAnnotation = AnnotationUtil.findFirst(clazz, PathPrefix.class);
        if (pathPrefixAnnotation == null) {
            return pathPrefix;
        }
        String pathPrefixFromAnnotation = pathPrefixAnnotation.value();
        RouteUtil.ensureAbsolutePath(pathPrefixFromAnnotation, "pathPrefixFromAnnotation");
        return ArmeriaHttpUtil.concatPaths(pathPrefix, pathPrefixFromAnnotation);
    }

    private AnnotatedServiceFactory() {
    }

    private static /* synthetic */ AnnotatedServiceElement lambda$create$4(List req, Method method, Class clazz, boolean needToUseBlockingTaskExecutor, String queryDelimiter, Object object, List eh, List res, HttpStatus defaultStatus, HttpHeaders responseHeaders, HttpHeaders responseTrailers, Route route) {
        List<AnnotatedValueResolver> resolvers = AnnotatedServiceFactory.getAnnotatedValueResolvers(req, route, method, clazz, needToUseBlockingTaskExecutor, queryDelimiter);
        return new AnnotatedServiceElement(route, new AnnotatedService(object, method, resolvers, eh, res, route, defaultStatus, responseHeaders, responseTrailers, needToUseBlockingTaskExecutor), AnnotatedServiceFactory.decorator(method, clazz));
    }
}

