/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.server.annotation;

import com.linecorp.armeria.common.AggregatedHttpResponse;
import com.linecorp.armeria.common.ExchangeType;
import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.ResponseHeadersBuilder;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.common.util.SafeCloseable;
import com.linecorp.armeria.common.util.UnmodifiableFuture;
import com.linecorp.armeria.internal.common.util.ObjectCollectingUtil;
import com.linecorp.armeria.internal.server.annotation.AnnotatedValueResolver;
import com.linecorp.armeria.internal.server.annotation.AnnotationUtil;
import com.linecorp.armeria.internal.server.annotation.CompositeResponseConverterFunction;
import com.linecorp.armeria.internal.server.annotation.FileAggregatedMultipart;
import com.linecorp.armeria.internal.server.annotation.KotlinUtil;
import com.linecorp.armeria.internal.server.annotation.ScalaUtil;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableCollection;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.server.HttpService;
import com.linecorp.armeria.server.Route;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceRequestContext;
import com.linecorp.armeria.server.SimpleDecoratingHttpService;
import com.linecorp.armeria.server.annotation.ByteArrayResponseConverterFunction;
import com.linecorp.armeria.server.annotation.ExceptionHandlerFunction;
import com.linecorp.armeria.server.annotation.ExceptionVerbosity;
import com.linecorp.armeria.server.annotation.FallthroughException;
import com.linecorp.armeria.server.annotation.HttpFileResponseConverterFunction;
import com.linecorp.armeria.server.annotation.HttpResult;
import com.linecorp.armeria.server.annotation.JacksonResponseConverterFunction;
import com.linecorp.armeria.server.annotation.ResponseConverterFunction;
import com.linecorp.armeria.server.annotation.ResponseConverterFunctionProvider;
import com.linecorp.armeria.server.annotation.ServiceName;
import com.linecorp.armeria.server.annotation.StringResponseConverterFunction;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Function;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.Future;

public final class AnnotatedService
implements HttpService {
    private static final Logger logger = LoggerFactory.getLogger(AnnotatedService.class);
    private static final String CGLIB_CLASS_SEPARATOR = "$$";
    private static final List<ResponseConverterFunction> defaultResponseConverters = ImmutableList.of(new JacksonResponseConverterFunction(), new StringResponseConverterFunction(), new ByteArrayResponseConverterFunction(), new HttpFileResponseConverterFunction());
    private static final MethodHandles.Lookup lookup = MethodHandles.lookup();
    private static final CompletableFuture<AnnotatedValueResolver.AggregatedResult> NO_AGGREGATION_FUTURE = UnmodifiableFuture.completedFuture(AnnotatedValueResolver.AggregatedResult.EMPTY);
    static final List<ResponseConverterFunctionProvider> responseConverterFunctionProviders = ImmutableList.copyOf(ServiceLoader.load(ResponseConverterFunctionProvider.class, AnnotatedService.class.getClassLoader()));
    private final Object object;
    private final Method method;
    private final MethodHandle methodHandle;
    @Nullable
    private final MethodHandle callKotlinSuspendingMethod;
    private final boolean isKotlinSuspendingMethod;
    private final List<AnnotatedValueResolver> resolvers;
    private final AnnotatedValueResolver.AggregationStrategy aggregationStrategy;
    @Nullable
    private final ExceptionHandlerFunction exceptionHandler;
    private final ResponseConverterFunction responseConverter;
    private final Route route;
    private final HttpStatus defaultStatus;
    private final HttpHeaders defaultHttpHeaders;
    private final HttpHeaders defaultHttpTrailers;
    private final ResponseType responseType;
    private final boolean useBlockingTaskExecutor;
    private final String serviceName;
    private final boolean serviceNameSetByAnnotation;

    AnnotatedService(Object object, Method method, List<AnnotatedValueResolver> resolvers, List<ExceptionHandlerFunction> exceptionHandlers, List<ResponseConverterFunction> responseConverters, Route route, HttpStatus defaultStatus, HttpHeaders defaultHttpHeaders, HttpHeaders defaultHttpTrailers, boolean useBlockingTaskExecutor) {
        this.object = Objects.requireNonNull(object, "object");
        this.method = Objects.requireNonNull(method, "method");
        Preconditions.checkArgument(!method.isVarArgs(), "%s#%s declared to take a variable number of arguments", (Object)method.getDeclaringClass().getSimpleName(), (Object)method.getName());
        this.isKotlinSuspendingMethod = KotlinUtil.isSuspendingFunction(method);
        this.resolvers = Objects.requireNonNull(resolvers, "resolvers");
        Objects.requireNonNull(exceptionHandlers, "exceptionHandlers");
        this.exceptionHandler = exceptionHandlers.isEmpty() ? null : new CompositeExceptionHandlerFunction(object.getClass().getSimpleName(), method.getName(), exceptionHandlers);
        this.responseConverter = AnnotatedService.responseConverter(method, Objects.requireNonNull(responseConverters, "responseConverters"));
        this.aggregationStrategy = AnnotatedValueResolver.AggregationStrategy.from(resolvers);
        this.route = Objects.requireNonNull(route, "route");
        this.defaultStatus = Objects.requireNonNull(defaultStatus, "defaultStatus");
        this.defaultHttpHeaders = Objects.requireNonNull(defaultHttpHeaders, "defaultHttpHeaders");
        this.defaultHttpTrailers = Objects.requireNonNull(defaultHttpTrailers, "defaultHttpTrailers");
        this.useBlockingTaskExecutor = useBlockingTaskExecutor;
        Class<?> returnType = method.getReturnType();
        this.responseType = HttpResponse.class.isAssignableFrom(returnType) ? ResponseType.HTTP_RESPONSE : (CompletionStage.class.isAssignableFrom(returnType) ? ResponseType.COMPLETION_STAGE : (this.isKotlinSuspendingMethod ? ResponseType.KOTLIN_COROUTINES : (ScalaUtil.isScalaFuture(returnType) ? ResponseType.SCALA_FUTURE : ResponseType.OTHER_OBJECTS)));
        this.callKotlinSuspendingMethod = KotlinUtil.getCallKotlinSuspendingMethod();
        ServiceName serviceName = AnnotationUtil.findFirst(method, ServiceName.class);
        if (serviceName == null) {
            serviceName = AnnotationUtil.findFirst(object.getClass(), ServiceName.class);
        }
        if (serviceName != null) {
            this.serviceName = serviceName.value();
            this.serviceNameSetByAnnotation = true;
        } else {
            this.serviceName = AnnotatedService.getUserClass(object.getClass()).getName();
            this.serviceNameSetByAnnotation = false;
        }
        this.method.setAccessible(true);
        this.methodHandle = AnnotatedService.asMethodHandle(method, object);
    }

    private static ResponseConverterFunction responseConverter(Method method, List<ResponseConverterFunction> responseConverters) {
        Type actualType = AnnotatedService.getActualReturnType(method);
        ImmutableCollection backingConverters = ((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll(responseConverters)).addAll(defaultResponseConverters)).build();
        CompositeResponseConverterFunction responseConverter = new CompositeResponseConverterFunction((ImmutableList<ResponseConverterFunction>)((ImmutableList.Builder)((ImmutableList.Builder)ImmutableList.builder().addAll((Iterable)backingConverters)).add(new AggregatedResponseConverterFunction(new CompositeResponseConverterFunction((ImmutableList<ResponseConverterFunction>)backingConverters)))).build());
        for (ResponseConverterFunctionProvider provider : responseConverterFunctionProviders) {
            ResponseConverterFunction func = provider.createResponseConverterFunction(actualType, responseConverter);
            if (func == null) continue;
            return func;
        }
        return responseConverter;
    }

    private static Type getActualReturnType(Method method) {
        Type genericReturnType;
        Class<?> returnType;
        if (KotlinUtil.isKFunction(method)) {
            returnType = KotlinUtil.kFunctionReturnType(method);
            genericReturnType = KotlinUtil.isReturnTypeNothing(method) ? KotlinUtil.kFunctionReturnType(method) : KotlinUtil.kFunctionGenericReturnType(method);
        } else {
            returnType = method.getReturnType();
            genericReturnType = method.getGenericReturnType();
        }
        if (HttpResult.class.isAssignableFrom(returnType)) {
            ParameterizedType type = (ParameterizedType)genericReturnType;
            AnnotatedService.warnIfHttpResponseArgumentExists(type, type);
            return type.getActualTypeArguments()[0];
        }
        return genericReturnType;
    }

    private static void warnIfHttpResponseArgumentExists(Type returnType, ParameterizedType type) {
        for (Type arg : type.getActualTypeArguments()) {
            Class clazz;
            if (arg instanceof ParameterizedType) {
                AnnotatedService.warnIfHttpResponseArgumentExists(returnType, (ParameterizedType)arg);
                continue;
            }
            if (!(arg instanceof Class) || !HttpResponse.class.isAssignableFrom(clazz = (Class)arg) && !AggregatedHttpResponse.class.isAssignableFrom(clazz)) continue;
            logger.warn("{} in the return type '{}' may take precedence over {}.", new Object[]{clazz.getSimpleName(), returnType, HttpResult.class.getSimpleName()});
        }
    }

    public String serviceName() {
        return this.serviceName;
    }

    public boolean serviceNameSetByAnnotation() {
        return this.serviceNameSetByAnnotation;
    }

    public String methodName() {
        return this.method.getName();
    }

    Object object() {
        return this.object;
    }

    Method method() {
        return this.method;
    }

    List<AnnotatedValueResolver> annotatedValueResolvers() {
        return this.resolvers;
    }

    Route route() {
        return this.route;
    }

    @Override
    public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) throws Exception {
        HttpResponse response = HttpResponse.from(this.serve0(ctx, req));
        if (this.exceptionHandler == null && Flags.annotatedServiceExceptionVerbosity() == ExceptionVerbosity.ALL && logger.isWarnEnabled()) {
            return response.peekError(cause -> logger.warn("{} Exception raised by method '{}' in '{}':", new Object[]{ctx, this.methodName(), this.object.getClass().getSimpleName(), Exceptions.peel(cause)}));
        }
        return response;
    }

    HttpService withExceptionHandler(HttpService service) {
        if (this.exceptionHandler == null) {
            return service;
        }
        return new ExceptionHandlingHttpService(service, this.exceptionHandler);
    }

    private CompletionStage<HttpResponse> serve0(ServiceRequestContext ctx, HttpRequest req) {
        CompletionStage<AnnotatedValueResolver.AggregatedResult> f;
        switch (AnnotatedValueResolver.aggregationType(this.aggregationStrategy, req.headers())) {
            case MULTIPART: {
                f = FileAggregatedMultipart.aggregateMultipart(ctx, req).thenApply(AnnotatedValueResolver.AggregatedResult::new);
                break;
            }
            case ALL: {
                f = req.aggregate().thenApply(AnnotatedValueResolver.AggregatedResult::new);
                break;
            }
            case NONE: {
                f = NO_AGGREGATION_FUTURE;
                break;
            }
            default: {
                throw new Error();
            }
        }
        ctx.mutateAdditionalResponseHeaders(mutator -> mutator.add(this.defaultHttpHeaders));
        ctx.mutateAdditionalResponseTrailers(mutator -> mutator.add(this.defaultHttpTrailers));
        switch (this.responseType) {
            case HTTP_RESPONSE: {
                if (this.useBlockingTaskExecutor) {
                    return ((CompletableFuture)f).thenApplyAsync(aReq -> (HttpResponse)this.invoke(ctx, req, (AnnotatedValueResolver.AggregatedResult)aReq), (Executor)ctx.blockingTaskExecutor());
                }
                return ((CompletableFuture)f).thenApply(aReq -> (HttpResponse)this.invoke(ctx, req, (AnnotatedValueResolver.AggregatedResult)aReq));
            }
            case COMPLETION_STAGE: 
            case KOTLIN_COROUTINES: 
            case SCALA_FUTURE: {
                CompletionStage composedFuture = this.useBlockingTaskExecutor ? ((CompletableFuture)f).thenComposeAsync(aReq -> AnnotatedService.toCompletionStage(this.invoke(ctx, req, (AnnotatedValueResolver.AggregatedResult)aReq), ctx.blockingTaskExecutor()), (Executor)ctx.blockingTaskExecutor()) : ((CompletableFuture)f).thenCompose(aReq -> AnnotatedService.toCompletionStage(this.invoke(ctx, req, (AnnotatedValueResolver.AggregatedResult)aReq), ctx.eventLoop()));
                return ((CompletableFuture)composedFuture).thenApply(result -> this.convertResponse(ctx, null, result, HttpHeaders.of()));
            }
        }
        Function<AnnotatedValueResolver.AggregatedResult, HttpResponse> defaultApplyFunction = aReq -> this.convertResponse(ctx, null, this.invoke(ctx, req, (AnnotatedValueResolver.AggregatedResult)aReq), HttpHeaders.of());
        if (this.useBlockingTaskExecutor) {
            return ((CompletableFuture)f).thenApplyAsync(defaultApplyFunction, (Executor)ctx.blockingTaskExecutor());
        }
        return ((CompletableFuture)f).thenApply(defaultApplyFunction);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    private Object invoke(ServiceRequestContext ctx, HttpRequest req, AnnotatedValueResolver.AggregatedResult aggregatedResult) {
        try (SafeCloseable ignored = ctx.push();){
            AnnotatedValueResolver.ResolverContext resolverContext = new AnnotatedValueResolver.ResolverContext(ctx, req, aggregatedResult);
            Object[] arguments = AnnotatedValueResolver.toArguments(this.resolvers, resolverContext);
            if (this.isKotlinSuspendingMethod) {
                assert (this.callKotlinSuspendingMethod != null);
                ScheduledExecutorService executor = this.useBlockingTaskExecutor ? ctx.blockingTaskExecutor().withoutContext() : ctx.eventLoop().withoutContext();
                Object object = this.callKotlinSuspendingMethod.invoke(this.method, this.object, arguments, executor, ctx);
                return object;
            }
            Object object = this.methodHandle.invoke(arguments);
            return object;
        }
        catch (Throwable cause) {
            return HttpResponse.ofFailure(cause);
        }
    }

    private HttpResponse convertResponse(ServiceRequestContext ctx, @Nullable HttpHeaders headers, @Nullable Object result, HttpHeaders trailers) {
        HttpHeaders newTrailers;
        ResponseHeaders newHeaders;
        if (result instanceof HttpResult) {
            HttpResult httpResult = (HttpResult)result;
            newHeaders = this.setHttpStatus(AnnotatedService.addNegotiatedResponseMediaType(ctx, httpResult.headers()));
            result = httpResult.content();
            newTrailers = httpResult.trailers();
        } else {
            newHeaders = this.setHttpStatus((ResponseHeadersBuilder)(headers == null ? AnnotatedService.addNegotiatedResponseMediaType(ctx, HttpHeaders.of()) : ResponseHeaders.builder().add((Iterable)headers)));
            newTrailers = trailers;
        }
        if (result instanceof HttpResponse) {
            return (HttpResponse)result;
        }
        if (result instanceof AggregatedHttpResponse) {
            return ((AggregatedHttpResponse)result).toHttpResponse();
        }
        if (result instanceof CompletionStage) {
            CompletionStage future = (CompletionStage)result;
            return HttpResponse.from(future.thenApply(object -> this.convertResponse(ctx, newHeaders, object, newTrailers)));
        }
        SafeCloseable ignored = ctx.push();
        try {
            HttpResponse httpResponse = this.responseConverter.convertResponse(ctx, newHeaders, result, newTrailers);
            if (ignored != null) {
                ignored.close();
            }
            return httpResponse;
        }
        catch (Throwable throwable) {
            try {
                if (ignored != null) {
                    try {
                        ignored.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (Exception cause) {
                return HttpResponse.ofFailure(cause);
            }
        }
    }

    private static ResponseHeadersBuilder addNegotiatedResponseMediaType(ServiceRequestContext ctx, HttpHeaders headers) {
        MediaType negotiatedResponseMediaType = ctx.negotiatedResponseMediaType();
        if (negotiatedResponseMediaType == null || headers.contentType() != null) {
            return ResponseHeaders.builder().add((Iterable)headers);
        }
        return ResponseHeaders.builder().add((Iterable)headers).contentType(negotiatedResponseMediaType);
    }

    private ResponseHeaders setHttpStatus(ResponseHeadersBuilder headers) {
        if (headers.contains((CharSequence)HttpHeaderNames.STATUS)) {
            return headers.build();
        }
        return headers.status(this.defaultStatus).build();
    }

    private static CompletionStage<?> toCompletionStage(@Nullable Object obj, ExecutorService executor) {
        if (obj instanceof CompletionStage) {
            return (CompletionStage)obj;
        }
        if (obj != null && ScalaUtil.isScalaFuture(obj.getClass())) {
            return ScalaUtil.FutureConverter.toCompletableFuture((Future)obj, executor);
        }
        return UnmodifiableFuture.completedFuture(obj);
    }

    @Override
    public ExchangeType exchangeType(RequestHeaders headers, Route route) {
        if (AnnotatedValueResolver.aggregationType(this.aggregationStrategy, headers) == AnnotatedValueResolver.AggregationType.ALL) {
            return ExchangeType.RESPONSE_STREAMING;
        }
        return ExchangeType.BIDI_STREAMING;
    }

    private static Class<?> getUserClass(Class<?> clazz) {
        Class<?> superclass;
        if (clazz.getName().contains(CGLIB_CLASS_SEPARATOR) && (superclass = clazz.getSuperclass()) != null && superclass != Object.class) {
            return superclass;
        }
        return clazz;
    }

    private static MethodHandle asMethodHandle(Method method, @Nullable Object object) {
        MethodHandle methodHandle;
        try {
            methodHandle = lookup.unreflect(method);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        if (!Modifier.isStatic(method.getModifiers())) {
            methodHandle = methodHandle.bindTo(Objects.requireNonNull(object, "object"));
        }
        int parameterCount = method.getParameterCount();
        return methodHandle.asSpreader(Object[].class, parameterCount);
    }

    static {
        if (!responseConverterFunctionProviders.isEmpty()) {
            logger.debug("Available {}s: {}", (Object)ResponseConverterFunctionProvider.class.getSimpleName(), responseConverterFunctionProviders);
        }
    }

    private static final class CompositeExceptionHandlerFunction
    implements ExceptionHandlerFunction {
        private final String className;
        private final String methodName;
        private final List<ExceptionHandlerFunction> functions;

        CompositeExceptionHandlerFunction(String className, String methodName, List<ExceptionHandlerFunction> functions) {
            this.className = className;
            this.methodName = methodName;
            this.functions = ImmutableList.copyOf(functions);
        }

        @Override
        public HttpResponse handleException(ServiceRequestContext ctx, HttpRequest req, Throwable cause) {
            Throwable peeledCause = Exceptions.peel(cause);
            if (Flags.annotatedServiceExceptionVerbosity() == ExceptionVerbosity.ALL && logger.isWarnEnabled()) {
                logger.warn("{} Exception raised by method '{}' in '{}':", new Object[]{ctx, this.methodName, this.className, peeledCause});
            }
            for (ExceptionHandlerFunction func : this.functions) {
                try {
                    HttpResponse response = func.handleException(ctx, req, peeledCause);
                    if (response != null) {
                        return response;
                    }
                    break;
                }
                catch (FallthroughException response) {
                }
                catch (Exception e) {
                    logger.warn("{} Unexpected exception from an exception handler {}:", new Object[]{ctx, func.getClass().getName(), e});
                }
            }
            return HttpResponse.ofFailure(peeledCause);
        }
    }

    private static enum ResponseType {
        HTTP_RESPONSE,
        COMPLETION_STAGE,
        KOTLIN_COROUTINES,
        SCALA_FUTURE,
        OTHER_OBJECTS;

    }

    private static final class AggregatedResponseConverterFunction
    implements ResponseConverterFunction {
        private final ResponseConverterFunction responseConverter;

        AggregatedResponseConverterFunction(ResponseConverterFunction responseConverter) {
            this.responseConverter = responseConverter;
        }

        @Override
        public HttpResponse convertResponse(ServiceRequestContext ctx, ResponseHeaders headers, @Nullable Object result, HttpHeaders trailers) throws Exception {
            CompletableFuture<Object> f;
            if (result instanceof Publisher) {
                f = ObjectCollectingUtil.collectFrom((Publisher)result, ctx);
            } else if (result instanceof Stream) {
                f = ObjectCollectingUtil.collectFrom((Stream)result, ctx.blockingTaskExecutor());
            } else {
                return (HttpResponse)ResponseConverterFunction.fallthrough();
            }
            assert (f != null);
            return HttpResponse.from(f.thenApply(aggregated -> {
                try {
                    return this.responseConverter.convertResponse(ctx, headers, aggregated, trailers);
                }
                catch (Exception ex) {
                    return (HttpResponse)Exceptions.throwUnsafely(ex);
                }
            }));
        }
    }

    private static final class ExceptionHandlingHttpService
    extends SimpleDecoratingHttpService {
        private final ExceptionHandlerFunction exceptionHandler;

        ExceptionHandlingHttpService(HttpService service, ExceptionHandlerFunction exceptionHandler) {
            super(service);
            this.exceptionHandler = exceptionHandler;
        }

        @Override
        public HttpResponse serve(ServiceRequestContext ctx, HttpRequest req) {
            try {
                HttpResponse response = (HttpResponse)((Service)this.unwrap()).serve(ctx, req);
                return response.recover(cause -> {
                    try (SafeCloseable ignored = ctx.push();){
                        HttpResponse httpResponse = this.exceptionHandler.handleException(ctx, req, (Throwable)cause);
                        return httpResponse;
                    }
                });
            }
            catch (Exception ex) {
                return this.exceptionHandler.handleException(ctx, req, ex);
            }
        }
    }
}

