/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.server.annotation;

import com.linecorp.armeria.internal.shaded.guava.collect.Iterables;
import com.linecorp.armeria.internal.shaded.reflections.ReflectionUtils;
import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;

final class AnnotatedObjectFactory {
    private static final ClassValue<Object> instanceCache = new ClassValue<Object>(){

        @Override
        protected Object computeValue(Class<?> type) {
            try {
                return AnnotatedObjectFactory.getInstance0(type);
            }
            catch (Exception e) {
                throw new IllegalStateException("A class must have an accessible default constructor: " + type.getName(), e);
            }
        }
    };

    static <T> T getInstance(Annotation annotation, Class<T> expectedType) {
        try {
            Class clazz = (Class)AnnotatedObjectFactory.invokeValueMethod(annotation);
            return expectedType.cast(instanceCache.get(clazz));
        }
        catch (ClassCastException e) {
            throw new IllegalArgumentException("A class specified in @" + annotation.annotationType().getSimpleName() + " annotation cannot be cast to " + expectedType, e);
        }
    }

    static <T> T getInstance(Class<T> clazz) {
        Object casted = instanceCache.get(clazz);
        return (T)casted;
    }

    static Object invokeValueMethod(Annotation a) {
        try {
            Method method = Iterables.getFirst(ReflectionUtils.getMethods(a.annotationType(), ReflectionUtils.withName("value")), null);
            assert (method != null) : "No 'value' method is found from " + a;
            return method.invoke((Object)a, new Object[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException("An annotation @" + a.annotationType().getSimpleName() + " must have a 'value' method", e);
        }
    }

    private static <T> T getInstance0(Class<? extends T> clazz) throws Exception {
        Constructor constructor = Iterables.getFirst(ReflectionUtils.getConstructors(clazz, ReflectionUtils.withParametersCount(0)), null);
        assert (constructor != null) : "No default constructor is found from " + clazz.getName();
        constructor.setAccessible(true);
        return constructor.newInstance(new Object[0]);
    }

    private AnnotatedObjectFactory() {
    }
}

