/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.server.annotation;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.JacksonUtil;
import com.linecorp.armeria.internal.server.annotation.AnnotatedBeanFactory;
import com.linecorp.armeria.internal.server.annotation.AnnotatedBeanFactoryRegistry;
import com.linecorp.armeria.internal.server.annotation.AnnotatedService;
import com.linecorp.armeria.internal.server.annotation.AnnotatedServiceFactory;
import com.linecorp.armeria.internal.server.annotation.AnnotatedValueResolver;
import com.linecorp.armeria.internal.server.annotation.KotlinUtil;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableCollection;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.server.Route;
import com.linecorp.armeria.server.RoutePathType;
import com.linecorp.armeria.server.Service;
import com.linecorp.armeria.server.ServiceConfig;
import com.linecorp.armeria.server.annotation.Header;
import com.linecorp.armeria.server.annotation.Param;
import com.linecorp.armeria.server.annotation.RequestObject;
import com.linecorp.armeria.server.docs.DocServiceFilter;
import com.linecorp.armeria.server.docs.DocServicePlugin;
import com.linecorp.armeria.server.docs.EndpointInfo;
import com.linecorp.armeria.server.docs.EndpointInfoBuilder;
import com.linecorp.armeria.server.docs.EnumInfo;
import com.linecorp.armeria.server.docs.FieldInfo;
import com.linecorp.armeria.server.docs.FieldInfoBuilder;
import com.linecorp.armeria.server.docs.FieldLocation;
import com.linecorp.armeria.server.docs.FieldRequirement;
import com.linecorp.armeria.server.docs.MethodInfo;
import com.linecorp.armeria.server.docs.NamedTypeInfo;
import com.linecorp.armeria.server.docs.ServiceInfo;
import com.linecorp.armeria.server.docs.ServiceSpecification;
import com.linecorp.armeria.server.docs.StructInfo;
import com.linecorp.armeria.server.docs.TypeSignature;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class AnnotatedDocServicePlugin
implements DocServicePlugin {
    static final TypeSignature VOID = TypeSignature.ofBase("void");
    static final TypeSignature BOOLEAN = TypeSignature.ofBase("boolean");
    static final TypeSignature BYTE = TypeSignature.ofBase("byte");
    static final TypeSignature SHORT = TypeSignature.ofBase("short");
    static final TypeSignature INT = TypeSignature.ofBase("int");
    static final TypeSignature LONG = TypeSignature.ofBase("long");
    static final TypeSignature FLOAT = TypeSignature.ofBase("float");
    static final TypeSignature DOUBLE = TypeSignature.ofBase("double");
    static final TypeSignature STRING = TypeSignature.ofBase("string");
    static final TypeSignature BINARY = TypeSignature.ofBase("binary");
    static final TypeSignature BEAN = TypeSignature.ofBase("bean");
    private static final ObjectWriter objectWriter = JacksonUtil.newDefaultObjectMapper().writerWithDefaultPrettyPrinter();

    @Override
    public String name() {
        return "annotated";
    }

    @Override
    public Set<Class<? extends Service<?, ?>>> supportedServiceTypes() {
        return ImmutableSet.of(AnnotatedService.class);
    }

    @Override
    public ServiceSpecification generateSpecification(Set<ServiceConfig> serviceConfigs, DocServiceFilter filter) {
        Objects.requireNonNull(serviceConfigs, "serviceConfigs");
        Objects.requireNonNull(filter, "filter");
        HashMap methodInfos = new HashMap();
        HashMap serviceDescription = new HashMap();
        serviceConfigs.forEach(sc -> {
            AnnotatedService service = sc.service().as(AnnotatedService.class);
            if (service != null) {
                String className = service.object().getClass().getName();
                String methodName = service.method().getName();
                if (!filter.test(this.name(), className, methodName)) {
                    return;
                }
                AnnotatedDocServicePlugin.addMethodInfo(methodInfos, sc.virtualHost().hostnamePattern(), service);
                AnnotatedDocServicePlugin.addServiceDescription(serviceDescription, service);
            }
        });
        return AnnotatedDocServicePlugin.generate(serviceDescription, methodInfos);
    }

    private static void addServiceDescription(Map<Class<?>, String> serviceDescription, AnnotatedService service) {
        Class<?> clazz = service.object().getClass();
        serviceDescription.computeIfAbsent(clazz, AnnotatedServiceFactory::findDescription);
    }

    private static void addMethodInfo(Map<Class<?>, Set<MethodInfo>> methodInfos, String hostnamePattern, AnnotatedService service) {
        Route route = service.route();
        EndpointInfo endpoint = AnnotatedDocServicePlugin.endpointInfo(route, hostnamePattern);
        Method method = service.method();
        String name = method.getName();
        TypeSignature returnTypeSignature = AnnotatedDocServicePlugin.getReturnTypeSignature(method);
        List<FieldInfo> fieldInfos = AnnotatedDocServicePlugin.fieldInfos(service.annotatedValueResolvers());
        Class<?> clazz = service.object().getClass();
        route.methods().forEach(httpMethod -> {
            MethodInfo methodInfo = new MethodInfo(name, returnTypeSignature, (Iterable<FieldInfo>)fieldInfos, (Iterable<TypeSignature>)ImmutableList.of(), (Iterable<EndpointInfo>)ImmutableList.of(endpoint), (HttpMethod)((Object)httpMethod), AnnotatedServiceFactory.findDescription(method));
            methodInfos.computeIfAbsent(clazz, unused -> new HashSet()).add(methodInfo);
        });
    }

    private static TypeSignature getReturnTypeSignature(Method method) {
        if (KotlinUtil.isKFunction(method)) {
            if (KotlinUtil.isReturnTypeNothing(method)) {
                return AnnotatedDocServicePlugin.toTypeSignature(KotlinUtil.kFunctionReturnType(method));
            }
            return AnnotatedDocServicePlugin.toTypeSignature(KotlinUtil.kFunctionGenericReturnType(method));
        }
        return AnnotatedDocServicePlugin.toTypeSignature(method.getGenericReturnType());
    }

    static EndpointInfo endpointInfo(Route route, String hostnamePattern) {
        EndpointInfoBuilder builder = AnnotatedDocServicePlugin.endpointInfoBuilder(route, hostnamePattern);
        builder.availableMimeTypes(AnnotatedDocServicePlugin.availableMimeTypes(route));
        return builder.build();
    }

    public static EndpointInfoBuilder endpointInfoBuilder(Route route, String hostnamePattern) {
        EndpointInfoBuilder builder;
        RoutePathType pathType = route.pathType();
        List<String> paths = route.paths();
        switch (pathType) {
            case EXACT: {
                builder = EndpointInfo.builder(hostnamePattern, "exact:" + paths.get(0));
                break;
            }
            case PREFIX: {
                builder = EndpointInfo.builder(hostnamePattern, "prefix:" + paths.get(0));
                break;
            }
            case PARAMETERIZED: {
                builder = EndpointInfo.builder(hostnamePattern, route.patternString());
                break;
            }
            case REGEX: {
                builder = EndpointInfo.builder(hostnamePattern, "regex:" + paths.get(0));
                break;
            }
            case REGEX_WITH_PREFIX: {
                builder = EndpointInfo.builder(hostnamePattern, "regex:" + paths.get(0));
                builder.regexPathPrefix("prefix:" + paths.get(1));
                break;
            }
            default: {
                throw new Error();
            }
        }
        return builder;
    }

    private static Set<MediaType> availableMimeTypes(Route route) {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        Set<MediaType> consumeTypes = route.consumes();
        builder.addAll(consumeTypes);
        if (!consumeTypes.contains(MediaType.JSON_UTF_8)) {
            builder.add(MediaType.JSON_UTF_8);
        }
        return builder.build();
    }

    private static List<FieldInfo> fieldInfos(List<AnnotatedValueResolver> resolvers) {
        ImmutableList.Builder fieldInfosBuilder = ImmutableList.builder();
        for (AnnotatedValueResolver resolver : resolvers) {
            FieldInfo fieldInfo = AnnotatedDocServicePlugin.fieldInfo(resolver);
            if (fieldInfo == null) continue;
            fieldInfosBuilder.add(fieldInfo);
        }
        return fieldInfosBuilder.build();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private static FieldInfo fieldInfo(AnnotatedValueResolver resolver) {
        TypeSignature signature;
        Class<? extends Annotation> annotationType = resolver.annotationType();
        if (annotationType == RequestObject.class) {
            AnnotatedBeanFactoryRegistry.BeanFactoryId beanFactoryId = resolver.beanFactoryId();
            AnnotatedBeanFactory<?> factory = AnnotatedBeanFactoryRegistry.find(beanFactoryId);
            if (factory == null) return null;
            ImmutableList.Builder builder = ImmutableList.builder();
            factory.constructor().getValue().forEach(builder::add);
            factory.methods().values().forEach(resolvers -> resolvers.forEach(builder::add));
            factory.fields().values().forEach(builder::add);
            ImmutableCollection resolvers2 = builder.build();
            if (resolvers2.isEmpty()) return null;
            return FieldInfo.builder(beanFactoryId.type().getSimpleName(), BEAN, AnnotatedDocServicePlugin.fieldInfos((List<AnnotatedValueResolver>)((Object)resolvers2))).build();
        }
        if (annotationType != Param.class && annotationType != Header.class) {
            return null;
        }
        if (resolver.hasContainer()) {
            Class<?> containerType = resolver.containerType();
            assert (containerType != null);
            TypeSignature parameterTypeSignature = AnnotatedDocServicePlugin.toTypeSignature(resolver.elementType());
            if (List.class.isAssignableFrom(containerType)) {
                signature = TypeSignature.ofList(parameterTypeSignature);
            } else {
                if (!Set.class.isAssignableFrom(containerType)) return null;
                signature = TypeSignature.ofSet(parameterTypeSignature);
            }
        } else {
            signature = AnnotatedDocServicePlugin.toTypeSignature(resolver.elementType());
        }
        String name = resolver.httpElementName();
        assert (name != null);
        FieldInfoBuilder builder = FieldInfo.builder(name, signature).location(AnnotatedDocServicePlugin.location(resolver)).requirement(resolver.shouldExist() ? FieldRequirement.REQUIRED : FieldRequirement.OPTIONAL);
        if (resolver.description() == null) return builder.build();
        builder.docString(resolver.description());
        return builder.build();
    }

    static TypeSignature toTypeSignature(Type type) {
        Objects.requireNonNull(type, "type");
        if (type == Void.class || type == Void.TYPE) {
            return VOID;
        }
        if (type == Boolean.class || type == Boolean.TYPE) {
            return BOOLEAN;
        }
        if (type == Byte.class || type == Byte.TYPE) {
            return BYTE;
        }
        if (type == Short.class || type == Short.TYPE) {
            return SHORT;
        }
        if (type == Integer.class || type == Integer.TYPE) {
            return INT;
        }
        if (type == Long.class || type == Long.TYPE) {
            return LONG;
        }
        if (type == Float.class || type == Float.TYPE) {
            return FLOAT;
        }
        if (type == Double.class || type == Double.TYPE) {
            return DOUBLE;
        }
        if (type == String.class) {
            return STRING;
        }
        if (type == byte[].class || type == Byte[].class) {
            return BINARY;
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            Class rawType = (Class)parameterizedType.getRawType();
            if (List.class.isAssignableFrom(rawType)) {
                return TypeSignature.ofList(AnnotatedDocServicePlugin.toTypeSignature(parameterizedType.getActualTypeArguments()[0]));
            }
            if (Set.class.isAssignableFrom(rawType)) {
                return TypeSignature.ofSet(AnnotatedDocServicePlugin.toTypeSignature(parameterizedType.getActualTypeArguments()[0]));
            }
            if (Map.class.isAssignableFrom(rawType)) {
                TypeSignature key = AnnotatedDocServicePlugin.toTypeSignature(parameterizedType.getActualTypeArguments()[0]);
                TypeSignature value = AnnotatedDocServicePlugin.toTypeSignature(parameterizedType.getActualTypeArguments()[1]);
                return TypeSignature.ofMap(key, value);
            }
            List actualTypes = Stream.of(parameterizedType.getActualTypeArguments()).map(AnnotatedDocServicePlugin::toTypeSignature).collect(ImmutableList.toImmutableList());
            return TypeSignature.ofContainer(rawType.getSimpleName(), actualTypes);
        }
        if (type instanceof WildcardType) {
            return TypeSignature.ofUnresolved("");
        }
        if (type instanceof TypeVariable) {
            return TypeSignature.ofBase(type.getTypeName());
        }
        if (type instanceof GenericArrayType) {
            return TypeSignature.ofList(AnnotatedDocServicePlugin.toTypeSignature(((GenericArrayType)type).getGenericComponentType()));
        }
        if (!(type instanceof Class)) {
            return TypeSignature.ofBase(type.getTypeName());
        }
        Class clazz = (Class)type;
        if (clazz.isArray()) {
            return TypeSignature.ofList(AnnotatedDocServicePlugin.toTypeSignature(clazz.getComponentType()));
        }
        return TypeSignature.ofBase(clazz.getSimpleName());
    }

    private static FieldLocation location(AnnotatedValueResolver resolver) {
        if (resolver.isPathVariable()) {
            return FieldLocation.PATH;
        }
        if (resolver.annotationType() == Param.class) {
            return FieldLocation.QUERY;
        }
        if (resolver.annotationType() == Header.class) {
            return FieldLocation.HEADER;
        }
        return FieldLocation.UNSPECIFIED;
    }

    static ServiceSpecification generate(Map<Class<?>, String> serviceDescription, Map<Class<?>, Set<MethodInfo>> methodInfos) {
        Set serviceInfos = methodInfos.entrySet().stream().map(entry -> {
            Class service = (Class)entry.getKey();
            return new ServiceInfo(service.getName(), (Iterable)entry.getValue(), (String)serviceDescription.get(service));
        }).collect(ImmutableSet.toImmutableSet());
        return ServiceSpecification.generate(serviceInfos, AnnotatedDocServicePlugin::newNamedTypeInfo);
    }

    private static NamedTypeInfo newNamedTypeInfo(TypeSignature typeSignature) {
        Class type = (Class)typeSignature.namedTypeDescriptor();
        if (type == null) {
            throw new IllegalArgumentException("cannot create a named type from: " + typeSignature);
        }
        if (type.isEnum()) {
            Class enumType = type;
            return new EnumInfo(enumType);
        }
        return AnnotatedDocServicePlugin.newStructInfo(type);
    }

    private static StructInfo newStructInfo(Class<?> structClass) {
        String name = structClass.getName();
        Field[] declaredFields = structClass.getDeclaredFields();
        List<FieldInfo> fields = Stream.of(declaredFields).map(f -> FieldInfo.of(f.getName(), AnnotatedDocServicePlugin.toTypeSignature(f.getGenericType()))).collect(Collectors.toList());
        return new StructInfo(name, fields);
    }

    @Override
    public Set<Class<?>> supportedExampleRequestTypes() {
        return ImmutableSet.of(TreeNode.class);
    }

    @Override
    @Nullable
    public String serializeExampleRequest(String serviceName, String methodName, Object exampleRequest) {
        try {
            return objectWriter.writeValueAsString(exampleRequest);
        }
        catch (JsonProcessingException jsonProcessingException) {
            return null;
        }
    }

    public String toString() {
        return AnnotatedDocServicePlugin.class.getSimpleName();
    }
}

