/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.server.annotation;

import com.linecorp.armeria.internal.server.annotation.AnnotatedBeanFactoryRegistry;
import com.linecorp.armeria.internal.server.annotation.AnnotatedValueResolver;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

final class AnnotatedBeanFactory<T> {
    private final AnnotatedBeanFactoryRegistry.BeanFactoryId beanFactoryId;
    private final Map.Entry<Constructor<T>, List<AnnotatedValueResolver>> constructor;
    private final Map<Field, AnnotatedValueResolver> fields;
    private final Map<Method, List<AnnotatedValueResolver>> methods;

    AnnotatedBeanFactory(AnnotatedBeanFactoryRegistry.BeanFactoryId beanFactoryId, Map.Entry<Constructor<T>, List<AnnotatedValueResolver>> constructor, Map<Method, List<AnnotatedValueResolver>> methods, Map<Field, AnnotatedValueResolver> fields) {
        this.beanFactoryId = Objects.requireNonNull(beanFactoryId, "beanFactoryId");
        this.constructor = AnnotatedBeanFactory.immutableEntry(Objects.requireNonNull(constructor, "constructor"));
        this.fields = ImmutableMap.copyOf(Objects.requireNonNull(fields, "fields"));
        this.methods = ImmutableMap.copyOf(Objects.requireNonNull(methods, "methods"));
    }

    private static <K, V> Map.Entry<K, V> immutableEntry(Map.Entry<K, V> entry) {
        if (entry instanceof AbstractMap.SimpleImmutableEntry) {
            return entry;
        }
        return new AbstractMap.SimpleImmutableEntry<K, V>(entry);
    }

    T create(AnnotatedValueResolver.ResolverContext resolverContext) {
        try {
            Object[] constructorArgs = AnnotatedValueResolver.toArguments(this.constructor.getValue(), resolverContext);
            T instance = this.constructor.getKey().newInstance(constructorArgs);
            for (Map.Entry<Method, List<AnnotatedValueResolver>> entry : this.methods.entrySet()) {
                Object[] methodArgs = AnnotatedValueResolver.toArguments(entry.getValue(), resolverContext);
                entry.getKey().invoke(instance, methodArgs);
            }
            for (Map.Entry<AccessibleObject, Object> entry : this.fields.entrySet()) {
                Object fieldArg = ((AnnotatedValueResolver)entry.getValue()).resolve(resolverContext);
                ((Field)entry.getKey()).set(instance, fieldArg);
            }
            return instance;
        }
        catch (Throwable cause) {
            throw new IllegalArgumentException("cannot instantiate a new object: " + this.beanFactoryId, cause);
        }
    }

    Map.Entry<Constructor<T>, List<AnnotatedValueResolver>> constructor() {
        return this.constructor;
    }

    Map<Method, List<AnnotatedValueResolver>> methods() {
        return this.methods;
    }

    Map<Field, AnnotatedValueResolver> fields() {
        return this.fields;
    }
}

