/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.util;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.stream.StreamMessage;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.server.ServiceRequestContext;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.stream.Stream;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class ObjectCollectingUtil {
    @Nullable
    private static final Class<?> MONO_CLASS;

    public static <T> CompletableFuture<List<T>> collectFrom(Stream<T> stream, Executor executor) {
        Objects.requireNonNull(stream, "stream");
        Objects.requireNonNull(executor, "executor");
        CompletableFuture future = new CompletableFuture();
        executor.execute(() -> {
            try {
                future.complete(stream.collect(ImmutableList.toImmutableList()));
            }
            catch (Exception e) {
                future.completeExceptionally(e);
            }
        });
        return future;
    }

    public static CompletableFuture<Object> collectFrom(Publisher<?> publisher, ServiceRequestContext ctx) {
        Objects.requireNonNull(publisher, "publisher");
        if (publisher instanceof StreamMessage) {
            StreamMessage stream = (StreamMessage)publisher;
            ctx.whenRequestCancelling().thenAccept(cause -> stream.abort((Throwable)cause));
            return stream.collect();
        }
        CompletableFuture<Object> future = new CompletableFuture<Object>();
        if (MONO_CLASS != null && MONO_CLASS.isAssignableFrom(publisher.getClass())) {
            publisher.subscribe(new CollectingSingleObjectSubscriber(future, ctx));
        } else {
            publisher.subscribe(new CollectingMultipleObjectsSubscriber(future, ctx));
        }
        return future;
    }

    private ObjectCollectingUtil() {
    }

    static {
        Class<?> mono = null;
        try {
            mono = Class.forName("reactor.core.publisher.Mono", true, ObjectCollectingUtil.class.getClassLoader());
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        finally {
            MONO_CLASS = mono;
        }
    }

    private static class CollectingSingleObjectSubscriber<T>
    extends AbstractCollectingSubscriber<T> {
        @Nullable
        private T result;

        CollectingSingleObjectSubscriber(CompletableFuture<Object> future, ServiceRequestContext ctx) {
            super(future, ctx);
        }

        public void onNext(T o) {
            if (this.result == null) {
                this.result = o;
            } else {
                this.onError(new IllegalStateException("Only one element can be published: " + o));
            }
        }

        public void onComplete() {
            ((AbstractCollectingSubscriber)this).future.complete(this.result);
        }
    }

    private static class CollectingMultipleObjectsSubscriber<T>
    extends AbstractCollectingSubscriber<T> {
        @Nullable
        private ImmutableList.Builder<T> collector;

        CollectingMultipleObjectsSubscriber(CompletableFuture<Object> future, ServiceRequestContext ctx) {
            super(future, ctx);
        }

        public void onNext(T o) {
            if (this.collector == null) {
                this.collector = new ImmutableList.Builder();
            }
            this.collector.add((Object)o);
        }

        public void onComplete() {
            ((AbstractCollectingSubscriber)this).future.complete(this.collector != null ? this.collector.build() : ImmutableList.of());
        }
    }

    private static abstract class AbstractCollectingSubscriber<T>
    implements Subscriber<T> {
        private final CompletableFuture<Object> future;
        private final ServiceRequestContext ctx;
        private boolean onErrorCalled;

        AbstractCollectingSubscriber(CompletableFuture<Object> future, ServiceRequestContext ctx) {
            this.future = future;
            this.ctx = ctx;
        }

        public void onSubscribe(Subscription s) {
            this.ctx.whenRequestCancelling().thenAccept(cause -> {
                if (!this.onErrorCalled) {
                    s.cancel();
                }
            });
            s.request(Integer.MAX_VALUE);
        }

        public void onError(Throwable cause) {
            this.onErrorCalled = true;
            this.future.completeExceptionally(cause);
        }
    }
}

