/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.stream;

import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.stream.AbortedStreamException;
import com.linecorp.armeria.common.stream.CancelledSubscriptionException;
import com.linecorp.armeria.common.stream.NoopSubscriber;
import com.linecorp.armeria.common.stream.StreamMessage;
import com.linecorp.armeria.common.stream.SubscriptionOption;
import com.linecorp.armeria.common.util.CompositeException;
import com.linecorp.armeria.common.util.EventLoopCheckingFuture;
import com.linecorp.armeria.internal.common.stream.InternalStreamMessageUtil;
import com.linecorp.armeria.internal.common.stream.NoopSubscription;
import com.linecorp.armeria.internal.common.stream.SubscriptionArbiter;
import io.netty.util.concurrent.EventExecutor;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class RecoverableStreamMessage<T>
implements StreamMessage<T> {
    private static final AtomicIntegerFieldUpdater<RecoverableStreamMessage> subscribedUpdater = AtomicIntegerFieldUpdater.newUpdater(RecoverableStreamMessage.class, "subscribed");
    private final CompletableFuture<Void> completionFuture = new EventLoopCheckingFuture<Void>();
    private final StreamMessage<T> upstream;
    private final Function<Throwable, StreamMessage<T>> errorFunction;
    private final boolean allowResuming;
    @Nullable
    private volatile StreamMessage<T> fallbackStream;
    @Nullable
    private volatile EventExecutor executor;
    private volatile int subscribed;

    public RecoverableStreamMessage(StreamMessage<T> upstream, Function<? super Throwable, ? extends StreamMessage<T>> errorFunction, boolean allowResuming) {
        this.upstream = upstream;
        this.errorFunction = errorFunction;
        this.allowResuming = allowResuming;
    }

    @Override
    public boolean isOpen() {
        StreamMessage<T> fallbackStream = this.fallbackStream;
        if (fallbackStream != null) {
            return fallbackStream.isOpen();
        }
        return this.upstream.isOpen();
    }

    @Override
    public boolean isEmpty() {
        if (this.upstream.isEmpty()) {
            StreamMessage<T> fallbackStream = this.fallbackStream;
            if (fallbackStream == null) {
                return true;
            }
            return fallbackStream.isEmpty();
        }
        return false;
    }

    @Override
    public long demand() {
        StreamMessage<T> fallbackStream = this.fallbackStream;
        if (fallbackStream != null) {
            return fallbackStream.demand();
        }
        return this.upstream.demand();
    }

    @Override
    public CompletableFuture<Void> whenComplete() {
        return this.completionFuture;
    }

    @Override
    public void subscribe(Subscriber<? super T> subscriber, EventExecutor executor, SubscriptionOption ... options) {
        Objects.requireNonNull(subscriber, "subscriber");
        Objects.requireNonNull(executor, "executor");
        Objects.requireNonNull(options, "options");
        if (!subscribedUpdater.compareAndSet(this, 0, 1)) {
            if (executor.inEventLoop()) {
                this.abortLateSubscriber(subscriber);
            } else {
                executor.execute(() -> this.abortLateSubscriber(subscriber));
            }
            return;
        }
        this.executor = executor;
        this.upstream.subscribe(new RecoverableSubscriber(subscriber, executor, options), executor, options);
    }

    private void abortLateSubscriber(Subscriber<? super T> subscriber) {
        subscriber.onSubscribe((Subscription)NoopSubscription.get());
        subscriber.onError((Throwable)new IllegalStateException("subscribed by other subscriber already"));
    }

    @Override
    public void abort() {
        this.abort(AbortedStreamException.get());
    }

    @Override
    public void abort(Throwable cause) {
        Objects.requireNonNull(cause, "cause");
        EventExecutor executor = this.executor;
        if (executor == null || executor.inEventLoop()) {
            this.abort0(cause);
        } else {
            executor.execute(() -> this.abort0(cause));
        }
    }

    private void abort0(Throwable cause) {
        StreamMessage<T> fallbackStream = this.fallbackStream;
        if (fallbackStream != null) {
            fallbackStream.abort(cause);
        } else {
            this.upstream.abort(cause);
        }
    }

    private final class RecoverableSubscriber
    extends SubscriptionArbiter
    implements Subscriber<T> {
        private Subscriber<T> downstream;
        private final EventExecutor executor;
        private final SubscriptionOption[] options;
        private boolean errorHandled;
        private boolean wroteAny;
        private boolean complete;

        private RecoverableSubscriber(Subscriber<? super T> downstream, EventExecutor executor, SubscriptionOption[] options) {
            super(executor);
            this.downstream = downstream;
            this.executor = executor;
            this.options = options;
        }

        public void onSubscribe(Subscription s) {
            this.setUpstreamSubscription(s);
            if (!this.errorHandled) {
                this.downstream.onSubscribe((Subscription)this);
            }
        }

        public void onNext(T obj) {
            if (!this.isTransient(obj)) {
                this.wroteAny = true;
            }
            this.produced(1L);
            this.downstream.onNext(obj);
        }

        private boolean isTransient(T obj) {
            return obj instanceof ResponseHeaders && ((ResponseHeaders)obj).status().isInformational();
        }

        public void onError(Throwable cause) {
            boolean canApplyFallback;
            if (this.complete) {
                return;
            }
            if (cause instanceof AbortedStreamException || cause instanceof CancelledSubscriptionException) {
                this.onError0(cause);
                return;
            }
            if (this.errorHandled) {
                this.onError0(cause);
                return;
            }
            boolean bl = canApplyFallback = RecoverableStreamMessage.this.allowResuming || !this.wroteAny;
            if (!canApplyFallback) {
                this.onError0(cause);
                return;
            }
            this.errorHandled = true;
            try {
                StreamMessage fallback = (StreamMessage)RecoverableStreamMessage.this.errorFunction.apply(cause);
                Objects.requireNonNull(fallback, "errorFunction.apply() returned null");
                RecoverableStreamMessage.this.fallbackStream = fallback;
                fallback.subscribe(this, this.executor, this.options);
            }
            catch (Throwable t) {
                this.onError0(new CompositeException(t, cause));
            }
        }

        private void onError0(Throwable cause) {
            this.complete = true;
            this.downstream.onError(cause);
            RecoverableStreamMessage.this.completionFuture.completeExceptionally(cause);
        }

        public void onComplete() {
            if (this.complete) {
                return;
            }
            this.complete = true;
            this.downstream.onComplete();
            RecoverableStreamMessage.this.completionFuture.complete(null);
        }

        @Override
        public void cancel() {
            if (this.executor.inEventLoop()) {
                this.cancel0();
            } else {
                this.executor.execute(this::cancel0);
            }
        }

        private void cancel0() {
            if (this.complete) {
                return;
            }
            this.complete = true;
            this.doCancel();
            CancelledSubscriptionException cause = CancelledSubscriptionException.get();
            if (InternalStreamMessageUtil.containsNotifyCancellation(this.options)) {
                this.downstream.onError((Throwable)cause);
            }
            this.downstream = NoopSubscriber.get();
            RecoverableStreamMessage.this.completionFuture.completeExceptionally(cause);
        }
    }
}

