/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.stream;

import com.linecorp.armeria.common.annotation.Nullable;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.nio.channels.InterruptedByTimeoutException;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;

public final class ByteBufsInputStream
extends InputStream {
    private final BlockingQueue<ByteBuf> buffers = new LinkedBlockingQueue<ByteBuf>();
    private final AtomicBoolean eos = new AtomicBoolean(false);
    @Nullable
    private volatile ByteBuf nextBuffer;
    @Nullable
    private final Duration timeout;
    @Nullable
    private Throwable interruption;

    public ByteBufsInputStream(Duration timeout) {
        this.timeout = Objects.requireNonNull(timeout, "timeout");
    }

    public ByteBufsInputStream() {
        this.timeout = null;
    }

    @Nullable
    private ByteBuf peekBuffer() {
        ByteBuf buffer = this.nextBuffer;
        return buffer == null ? (ByteBuf)this.buffers.peek() : buffer;
    }

    @Nullable
    private ByteBuf buffer() throws InterruptedException, IOException {
        ByteBuf buffer = this.nextBuffer;
        if (buffer == null) {
            buffer = this.takeNext();
        }
        this.nextBuffer = buffer;
        return this.nextBuffer;
    }

    @Nullable
    private ByteBuf next() throws InterruptedException, IOException {
        ByteBuf buffer;
        this.nextBuffer = buffer = this.takeNext();
        return this.nextBuffer;
    }

    @Nullable
    private ByteBuf takeNext() throws InterruptedException, IOException {
        ByteBuf buffer = null;
        while (buffer == null) {
            if (this.interruption != null) {
                InterruptedIOException ioe = new InterruptedIOException();
                ioe.initCause(this.interruption);
                throw ioe;
            }
            if (this.eos.get()) {
                return (ByteBuf)this.buffers.poll();
            }
            if (this.timeout != null) {
                buffer = this.buffers.poll(this.timeout.toMillis(), TimeUnit.MILLISECONDS);
                if (buffer != null) continue;
                throw new InterruptedByTimeoutException();
            }
            buffer = this.buffers.take();
        }
        return buffer;
    }

    private void drain() {
        ByteBuf buffer;
        while ((buffer = (ByteBuf)this.buffers.poll()) != null) {
        }
    }

    public boolean isEos() {
        return this.eos.get();
    }

    public void setEos() {
        this.eos.set(true);
        this.buffers.add(Unpooled.EMPTY_BUFFER);
    }

    public void add(ByteBuf buffer) {
        Objects.requireNonNull(buffer, "buffer");
        if (this.eos.get()) {
            throw new IllegalStateException("Already closed");
        }
        if (!this.buffers.add(buffer)) {
            throw new IllegalStateException("Unable to add new buffer");
        }
    }

    public void interrupt(Throwable interruption) {
        this.interruption = Objects.requireNonNull(interruption, "interruption");
        this.buffers.add(Unpooled.EMPTY_BUFFER);
    }

    @Override
    public void close() {
        this.setEos();
        this.drain();
    }

    @Override
    public int available() {
        ByteBuf buffer = this.peekBuffer();
        if (buffer == null) {
            return 0;
        }
        return buffer.readableBytes();
    }

    @Override
    public int read() throws IOException {
        return this.read(buffer -> ByteBufsInputStream.readFromBuffer(buffer));
    }

    @Override
    public int read(byte[] bytes, int off, int len) throws IOException {
        return this.read(buffer -> ByteBufsInputStream.readFromBuffer(buffer, bytes, off, len));
    }

    private int read(Function<ByteBuf, Integer> reader) throws IOException {
        try {
            ByteBuf buffer = this.buffer();
            if (buffer == null) {
                return -1;
            }
            while (buffer != null) {
                int b = reader.apply(buffer);
                if (b == -1) {
                    buffer = this.next();
                    continue;
                }
                return b;
            }
            return -1;
        }
        catch (InterruptedException e) {
            InterruptedIOException ioe = new InterruptedIOException();
            ioe.initCause(e);
            throw ioe;
        }
    }

    private static int readFromBuffer(ByteBuf buffer) {
        return buffer.isReadable() ? buffer.readByte() & 0xFF : -1;
    }

    private static int readFromBuffer(ByteBuf buffer, byte[] bytes, int off, int len) {
        if (!buffer.isReadable()) {
            return -1;
        }
        len = Math.min(len, buffer.readableBytes());
        buffer.readBytes(bytes, off, len);
        return len;
    }
}

