/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.encoding;

import com.linecorp.armeria.client.encoding.StreamDecoder;
import com.linecorp.armeria.common.FilteredHttpResponse;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.annotation.Nullable;
import org.reactivestreams.Subscriber;

abstract class AbstractHttpDecodedResponse
extends FilteredHttpResponse {
    private boolean decoderClosed;

    AbstractHttpDecodedResponse(HttpResponse delegate) {
        super(delegate, true);
    }

    @Nullable
    abstract StreamDecoder decoder();

    @Override
    protected void beforeComplete(Subscriber<? super HttpObject> subscriber) {
        HttpData lastData = this.closeResponseDecoder();
        if (lastData == null) {
            return;
        }
        if (!lastData.isEmpty()) {
            subscriber.onNext((Object)lastData);
        } else {
            lastData.close();
        }
    }

    @Override
    protected Throwable beforeError(Subscriber<? super HttpObject> subscriber, Throwable cause) {
        HttpData lastData = this.closeResponseDecoder();
        if (lastData != null) {
            lastData.close();
        }
        return cause;
    }

    @Override
    protected void onCancellation(Subscriber<? super HttpObject> subscriber) {
        HttpData lastData = this.closeResponseDecoder();
        if (lastData != null) {
            lastData.close();
        }
    }

    @Nullable
    private HttpData closeResponseDecoder() {
        if (this.decoderClosed) {
            return null;
        }
        this.decoderClosed = true;
        if (this.decoder() == null) {
            return null;
        }
        return this.decoder().finish();
    }
}

