/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common;

import com.linecorp.armeria.common.Flags;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.metric.MeterIdPrefix;
import com.linecorp.armeria.internal.common.metric.CaffeineMetricSupport;
import com.linecorp.armeria.internal.shaded.caffeine.cache.Cache;
import com.linecorp.armeria.internal.shaded.caffeine.cache.Caffeine;
import com.linecorp.armeria.internal.shaded.fastutil.bytes.ByteArrays;
import io.micrometer.core.instrument.MeterRegistry;
import io.netty.util.internal.StringUtil;
import java.util.BitSet;
import java.util.Objects;
import java.util.Set;

public final class PathAndQuery {
    private static final PathAndQuery ROOT_PATH_QUERY;
    private static final BitSet ALLOWED_PATH_CHARS;
    private static final BitSet ALLOWED_QUERY_CHARS;
    private static final BitSet RESERVED_CHARS;
    private static final char[][] TO_PERCENT_ENCODED_CHARS;
    private static final Bytes EMPTY_QUERY;
    private static final Bytes ROOT_PATH;
    @Nullable
    private static final Cache<String, PathAndQuery> CACHE;
    private final String path;
    @Nullable
    private final String query;
    private boolean cached;

    private static Cache<String, PathAndQuery> buildCache(String spec) {
        return Caffeine.from(spec).build();
    }

    public static void registerMetrics(MeterRegistry registry, MeterIdPrefix idPrefix) {
        if (CACHE != null) {
            CaffeineMetricSupport.setup(registry, idPrefix, CACHE);
        }
    }

    public static void clearCachedPaths() {
        Objects.requireNonNull(CACHE, "CACHE");
        CACHE.asMap().clear();
    }

    public static Set<String> cachedPaths() {
        Objects.requireNonNull(CACHE, "CACHE");
        return CACHE.asMap().keySet();
    }

    @Nullable
    public static PathAndQuery parse(@Nullable String rawPath) {
        return PathAndQuery.parse(rawPath, Flags.allowDoubleDotsInQueryString());
    }

    @Nullable
    static PathAndQuery parse(@Nullable String rawPath, boolean allowDoubleDotsInQueryString) {
        PathAndQuery parsed;
        if (CACHE != null && rawPath != null && (parsed = CACHE.getIfPresent(rawPath)) != null) {
            return parsed;
        }
        return PathAndQuery.splitPathAndQuery(rawPath, allowDoubleDotsInQueryString);
    }

    public void storeInCache(@Nullable String rawPath) {
        if (CACHE != null && !this.cached && rawPath != null) {
            this.cached = true;
            CACHE.put(rawPath, this);
        }
    }

    private PathAndQuery(String path, @Nullable String query) {
        this.path = path;
        this.query = query;
    }

    public String path() {
        return this.path;
    }

    @Nullable
    public String query() {
        return this.query;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PathAndQuery)) {
            return false;
        }
        PathAndQuery that = (PathAndQuery)o;
        return Objects.equals(this.path, that.path) && Objects.equals(this.query, that.query);
    }

    public int hashCode() {
        return Objects.hash(this.path, this.query);
    }

    public String toString() {
        if (this.query == null) {
            return this.path;
        }
        return this.path + '?' + this.query;
    }

    @Nullable
    private static PathAndQuery splitPathAndQuery(@Nullable String pathAndQuery, boolean allowDoubleDotsInQueryString) {
        Bytes query;
        Bytes path;
        if (pathAndQuery == null) {
            return ROOT_PATH_QUERY;
        }
        int queryPos = pathAndQuery.indexOf(63);
        if (queryPos >= 0) {
            path = PathAndQuery.decodePercentsAndEncodeToUtf8(pathAndQuery, 0, queryPos, true);
            if (path == null) {
                return null;
            }
            query = PathAndQuery.decodePercentsAndEncodeToUtf8(pathAndQuery, queryPos + 1, pathAndQuery.length(), false);
            if (query == null) {
                return null;
            }
        } else {
            path = PathAndQuery.decodePercentsAndEncodeToUtf8(pathAndQuery, 0, pathAndQuery.length(), true);
            if (path == null) {
                return null;
            }
            query = null;
        }
        if (path.data[0] != 47 || path.isEncoded(0)) {
            return null;
        }
        if (PathAndQuery.pathContainsDoubleDots(path)) {
            return null;
        }
        if (!allowDoubleDotsInQueryString && PathAndQuery.queryContainsDoubleDots(query)) {
            return null;
        }
        return new PathAndQuery(PathAndQuery.encodePathToPercents(path), PathAndQuery.encodeQueryToPercents(query));
    }

    @Nullable
    static String decodePercentEncodedQuery(String query) {
        Bytes bytes = PathAndQuery.decodePercentsAndEncodeToUtf8(query, 0, query.length(), false);
        return PathAndQuery.encodeQueryToPercents(bytes);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private static Bytes decodePercentsAndEncodeToUtf8(String value, int start, int end, boolean isPath) {
        int length = end - start;
        if (length == 0) {
            return isPath ? ROOT_PATH : EMPTY_QUERY;
        }
        Bytes buf = new Bytes(Math.max(length * 3 / 2, 4));
        boolean wasSlash = false;
        CodePointIterator i = new CodePointIterator(value, start, end);
        while (i.hasNextCodePoint()) {
            int pos = i.position();
            int cp = i.nextCodePoint();
            if (cp == 37) {
                int hexEnd = pos + 3;
                if (hexEnd > end) {
                    return null;
                }
                int digit1 = StringUtil.decodeHexNibble((char)value.charAt(pos + 1));
                int digit2 = StringUtil.decodeHexNibble((char)value.charAt(pos + 2));
                if (digit1 < 0 || digit2 < 0) {
                    return null;
                }
                int decoded = digit1 << 4 | digit2;
                if (isPath) {
                    if (decoded == 47) {
                        buf.ensure(1);
                        buf.addEncoded((byte)47);
                        wasSlash = false;
                    } else {
                        if (!PathAndQuery.appendOneByte(buf, decoded, wasSlash, isPath)) return null;
                        wasSlash = false;
                    }
                } else if (RESERVED_CHARS.get(decoded)) {
                    buf.ensure(1);
                    buf.addEncoded((byte)decoded);
                    wasSlash = false;
                } else {
                    if (!PathAndQuery.appendOneByte(buf, decoded, wasSlash, isPath)) return null;
                    wasSlash = decoded == 47;
                }
                i.position(hexEnd);
                continue;
            }
            if (cp == 43 && !isPath) {
                buf.ensure(1);
                buf.addEncoded((byte)32);
                wasSlash = false;
                continue;
            }
            if (cp <= 127) {
                if (!PathAndQuery.appendOneByte(buf, cp, wasSlash, isPath)) {
                    return null;
                }
                wasSlash = cp == 47;
                continue;
            }
            if (cp <= 2047) {
                buf.ensure(2);
                buf.addEncoded((byte)(cp >>> 6 | 0xC0));
                buf.addEncoded((byte)(cp & 0x3F | 0x80));
            } else if (cp <= 65535) {
                buf.ensure(3);
                buf.addEncoded((byte)(cp >>> 12 | 0xE0));
                buf.addEncoded((byte)(cp >>> 6 & 0x3F | 0x80));
                buf.addEncoded((byte)(cp & 0x3F | 0x80));
            } else if (cp <= 0x1FFFFF) {
                buf.ensure(4);
                buf.addEncoded((byte)(cp >>> 18 | 0xF0));
                buf.addEncoded((byte)(cp >>> 12 & 0x3F | 0x80));
                buf.addEncoded((byte)(cp >>> 6 & 0x3F | 0x80));
                buf.addEncoded((byte)(cp & 0x3F | 0x80));
            } else if (cp <= 0x3FFFFFF) {
                buf.ensure(5);
                buf.addEncoded((byte)(cp >>> 24 | 0xF8));
                buf.addEncoded((byte)(cp >>> 18 & 0x3F | 0x80));
                buf.addEncoded((byte)(cp >>> 12 & 0x3F | 0x80));
                buf.addEncoded((byte)(cp >>> 6 & 0x3F | 0x80));
                buf.addEncoded((byte)(cp & 0x3F | 0x80));
            } else {
                buf.ensure(6);
                buf.addEncoded((byte)(cp >>> 30 | 0xFC));
                buf.addEncoded((byte)(cp >>> 24 & 0x3F | 0x80));
                buf.addEncoded((byte)(cp >>> 18 & 0x3F | 0x80));
                buf.addEncoded((byte)(cp >>> 12 & 0x3F | 0x80));
                buf.addEncoded((byte)(cp >>> 6 & 0x3F | 0x80));
                buf.addEncoded((byte)(cp & 0x3F | 0x80));
            }
            wasSlash = false;
        }
        return buf;
    }

    private static boolean appendOneByte(Bytes buf, int cp, boolean wasSlash, boolean isPath) {
        if (cp == 127) {
            return false;
        }
        if (cp >>> 5 == 0) {
            if (isPath) {
                return false;
            }
            if (cp != 10 && cp != 13 && cp != 9) {
                return false;
            }
        }
        if (cp == 47 && isPath) {
            if (!wasSlash) {
                buf.ensure(1);
                buf.add((byte)47);
            }
        } else {
            BitSet allowedChars = isPath ? ALLOWED_PATH_CHARS : ALLOWED_QUERY_CHARS;
            buf.ensure(1);
            if (allowedChars.get(cp)) {
                buf.add((byte)cp);
            } else {
                buf.addEncoded((byte)cp);
            }
        }
        return true;
    }

    private static boolean pathContainsDoubleDots(Bytes path) {
        int length = path.length;
        byte b0 = 0;
        byte b1 = 0;
        byte b2 = 47;
        for (int i = 1; i < length; ++i) {
            byte b3 = path.data[i];
            if (b1 == 46 && b2 == 46 && PathAndQuery.isSlash(b0) && PathAndQuery.isSlash(b3)) {
                return true;
            }
            b0 = b1;
            b1 = b2;
            b2 = b3;
        }
        return b1 == 46 && b2 == 46 && PathAndQuery.isSlash(b0);
    }

    private static boolean queryContainsDoubleDots(@Nullable Bytes query) {
        if (query == null) {
            return false;
        }
        int length = query.length;
        boolean lookingForEquals = true;
        byte b0 = 0;
        byte b1 = 0;
        byte b2 = 47;
        for (int i = 0; i < length; ++i) {
            byte b3 = query.data[i];
            switch (b3) {
                case 61: {
                    if (!lookingForEquals) break;
                    lookingForEquals = false;
                    b3 = 47;
                    break;
                }
                case 38: 
                case 59: {
                    b3 = 47;
                    lookingForEquals = true;
                }
            }
            if (b1 == 46 && b2 == 46 && PathAndQuery.isSlash(b0) && PathAndQuery.isSlash(b3)) {
                return true;
            }
            b0 = b1;
            b1 = b2;
            b2 = b3;
        }
        return b1 == 46 && b2 == 46 && PathAndQuery.isSlash(b0);
    }

    private static boolean isSlash(byte b) {
        switch (b) {
            case 47: 
            case 92: {
                return true;
            }
        }
        return false;
    }

    private static String encodePathToPercents(Bytes value) {
        if (!value.hasEncodedBytes()) {
            return new String(value.data, 0, 0, value.length);
        }
        return PathAndQuery.slowEncodePathToPercents(value);
    }

    @Nullable
    private static String encodeQueryToPercents(@Nullable Bytes value) {
        if (value == null) {
            return null;
        }
        if (!value.hasEncodedBytes()) {
            return new String(value.data, 0, 0, value.length);
        }
        return PathAndQuery.slowEncodeQueryToPercents(value);
    }

    private static String slowEncodePathToPercents(Bytes value) {
        int length = value.length;
        StringBuilder buf = new StringBuilder(length + value.numEncodedBytes() * 2);
        for (int i = 0; i < length; ++i) {
            int b = value.data[i] & 0xFF;
            if (value.isEncoded(i)) {
                buf.append(TO_PERCENT_ENCODED_CHARS[b]);
                continue;
            }
            buf.append((char)b);
        }
        return buf.toString();
    }

    private static String slowEncodeQueryToPercents(Bytes value) {
        int length = value.length;
        StringBuilder buf = new StringBuilder(length + value.numEncodedBytes() * 2);
        for (int i = 0; i < length; ++i) {
            int b = value.data[i] & 0xFF;
            if (value.isEncoded(i)) {
                if (b == 32) {
                    buf.append('+');
                    continue;
                }
                buf.append(TO_PERCENT_ENCODED_CHARS[b]);
                continue;
            }
            buf.append((char)b);
        }
        return buf.toString();
    }

    static {
        int i;
        ROOT_PATH_QUERY = new PathAndQuery("/", null);
        ALLOWED_PATH_CHARS = new BitSet();
        ALLOWED_QUERY_CHARS = new BitSet();
        RESERVED_CHARS = new BitSet();
        TO_PERCENT_ENCODED_CHARS = new char[256][];
        String allowedPathChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-._~:/?#[]@!$&'()*+,;=";
        for (int i2 = 0; i2 < "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-._~:/?#[]@!$&'()*+,;=".length(); ++i2) {
            ALLOWED_PATH_CHARS.set("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-._~:/?#[]@!$&'()*+,;=".charAt(i2));
        }
        String allowedQueryChars = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-._~:/?#[]@!$&'()*,;=";
        for (int i3 = 0; i3 < "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-._~:/?#[]@!$&'()*,;=".length(); ++i3) {
            ALLOWED_QUERY_CHARS.set("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-._~:/?#[]@!$&'()*,;=".charAt(i3));
        }
        String reservedChars = ":/?#[]@!$&'()*+,;=";
        for (i = 0; i < ":/?#[]@!$&'()*+,;=".length(); ++i) {
            RESERVED_CHARS.set(":/?#[]@!$&'()*+,;=".charAt(i));
        }
        for (i = 0; i < TO_PERCENT_ENCODED_CHARS.length; ++i) {
            PathAndQuery.TO_PERCENT_ENCODED_CHARS[i] = String.format("%%%02X", i).toCharArray();
        }
        EMPTY_QUERY = new Bytes(0);
        ROOT_PATH = new Bytes(new byte[]{47});
        CACHE = Flags.parsedPathCacheSpec() != null ? PathAndQuery.buildCache(Flags.parsedPathCacheSpec()) : null;
    }

    private static final class Bytes {
        byte[] data;
        int length;
        @Nullable
        private BitSet encoded;
        private int numEncodedBytes;

        Bytes(int initialCapacity) {
            this.data = new byte[initialCapacity];
        }

        Bytes(byte[] data) {
            this.data = data;
            this.length = data.length;
        }

        void add(byte b) {
            this.data[this.length++] = b;
        }

        void addEncoded(byte b) {
            if (this.encoded == null) {
                this.encoded = new BitSet();
            }
            this.encoded.set(this.length);
            this.data[this.length++] = b;
            ++this.numEncodedBytes;
        }

        boolean isEncoded(int index) {
            return this.encoded != null && this.encoded.get(index);
        }

        boolean hasEncodedBytes() {
            return this.encoded != null;
        }

        int numEncodedBytes() {
            return this.numEncodedBytes;
        }

        void ensure(int numBytes) {
            int newCapacity = this.length + numBytes;
            if (newCapacity <= this.data.length) {
                return;
            }
            newCapacity = (int)Math.max(Math.min((long)this.data.length + (long)(this.data.length >> 1), 0x7FFFFFF7L), (long)newCapacity);
            this.data = ByteArrays.forceCapacity(this.data, newCapacity, this.length);
        }
    }

    private static final class CodePointIterator {
        private final CharSequence str;
        private final int end;
        private int pos;

        CodePointIterator(CharSequence str, int start, int end) {
            this.str = str;
            this.end = end;
            this.pos = start;
        }

        int position() {
            return this.pos;
        }

        void position(int pos) {
            this.pos = pos;
        }

        boolean hasNextCodePoint() {
            return this.pos < this.end;
        }

        int nextCodePoint() {
            char c2;
            char c1;
            assert (this.pos < this.end);
            if (Character.isHighSurrogate(c1 = this.str.charAt(this.pos++)) && this.pos < this.end && Character.isLowSurrogate(c2 = this.str.charAt(this.pos))) {
                ++this.pos;
                return Character.toCodePoint(c1, c2);
            }
            return c1;
        }
    }
}

