/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common;

import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpHeadersBuilder;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.RequestHeadersBuilder;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.ResponseHeadersBuilder;
import com.linecorp.armeria.internal.common.ArmeriaHttpUtil;
import io.netty.util.AsciiString;

public final class HttpHeadersUtil {
    public static ResponseHeaders mergeResponseHeaders(ResponseHeaders headers, HttpHeaders additionalHeaders) {
        if (additionalHeaders.isEmpty()) {
            return headers;
        }
        ResponseHeadersBuilder builder = headers.toBuilder();
        for (AsciiString name : additionalHeaders.names()) {
            if (HttpHeadersUtil.isPseudoHeader(name)) continue;
            builder.remove((CharSequence)name);
            additionalHeaders.forEachValue((CharSequence)name, value -> builder.add((CharSequence)name, (String)value));
        }
        return builder.build();
    }

    public static RequestHeaders mergeRequestHeaders(RequestHeaders headers, HttpHeaders additionalHeaders) {
        if (additionalHeaders.isEmpty()) {
            return headers;
        }
        RequestHeadersBuilder builder = headers.toBuilder();
        for (AsciiString name : additionalHeaders.names()) {
            if (ArmeriaHttpUtil.ADDITIONAL_REQUEST_HEADER_DISALLOWED_LIST.contains(name)) continue;
            builder.remove((CharSequence)name);
            additionalHeaders.forEachValue((CharSequence)name, value -> builder.add((CharSequence)name, (String)value));
        }
        return builder.build();
    }

    public static HttpHeaders mergeTrailers(HttpHeaders headers, HttpHeaders additionalTrailers) {
        if (additionalTrailers.isEmpty()) {
            return headers;
        }
        if (headers.isEmpty()) {
            return additionalTrailers;
        }
        HttpHeadersBuilder builder = headers.toBuilder();
        for (AsciiString name : additionalTrailers.names()) {
            if (HttpHeadersUtil.isPseudoHeader(name) || ArmeriaHttpUtil.isTrailerDisallowed(name)) continue;
            builder.remove((CharSequence)name);
            additionalTrailers.forEachValue((CharSequence)name, value -> builder.add((CharSequence)name, (String)value));
        }
        return builder.build();
    }

    private static boolean isPseudoHeader(AsciiString name) {
        return !name.isEmpty() && name.charAt(0) == ':';
    }

    private HttpHeadersUtil() {
    }
}

