/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.client.dns;

import com.linecorp.armeria.client.DnsCache;
import com.linecorp.armeria.client.DnsTimeoutException;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.common.util.SafeCloseable;
import com.linecorp.armeria.internal.client.dns.CachingDnsResolver;
import com.linecorp.armeria.internal.client.dns.DelegatingDnsResolver;
import com.linecorp.armeria.internal.client.dns.DnsQuestionContext;
import com.linecorp.armeria.internal.client.dns.DnsResolver;
import com.linecorp.armeria.internal.client.dns.HostsFileDnsResolver;
import com.linecorp.armeria.internal.client.dns.SearchDomainDnsResolver;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.Ordering;
import io.netty.handler.codec.dns.DnsQuestion;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.handler.codec.dns.DnsRecordType;
import io.netty.resolver.HostsFileEntriesResolver;
import io.netty.resolver.ResolvedAddressTypes;
import io.netty.resolver.dns.DnsNameResolver;
import io.netty.util.concurrent.EventExecutor;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;

public final class DefaultDnsResolver
implements SafeCloseable {
    private static final CompletableFuture<?>[] EMPTY_FUTURES = new CompletableFuture[0];
    private final DnsResolver delegate;
    private final DnsCache dnsCache;
    private final EventExecutor executor;
    private final Comparator<DnsRecordType> preferredOrder;
    private final long queryTimeoutMillis;

    public static DefaultDnsResolver of(DnsNameResolver delegate, DnsCache dnsCache, EventExecutor eventLoop, List<String> searchDomains, int ndots, long queryTimeoutMillis, HostsFileEntriesResolver hostsFileEntriesResolver) {
        Objects.requireNonNull(delegate, "delegate");
        Objects.requireNonNull(dnsCache, "dnsCache");
        Objects.requireNonNull(eventLoop, "eventLoop");
        Objects.requireNonNull(searchDomains, "searchDomains");
        Objects.requireNonNull(hostsFileEntriesResolver, "hostsFileEntriesResolver");
        DnsResolver resolver = new DelegatingDnsResolver(delegate, eventLoop);
        resolver = new CachingDnsResolver(resolver, dnsCache);
        if (!searchDomains.isEmpty()) {
            resolver = new SearchDomainDnsResolver(resolver, searchDomains, ndots);
        }
        ResolvedAddressTypes resolvedAddressTypes = delegate.resolvedAddressTypes();
        resolver = new HostsFileDnsResolver(resolver, hostsFileEntriesResolver, resolvedAddressTypes);
        return new DefaultDnsResolver(resolver, dnsCache, eventLoop, resolvedAddressTypes, queryTimeoutMillis);
    }

    public DefaultDnsResolver(DnsResolver delegate, DnsCache dnsCache, EventExecutor executor, ResolvedAddressTypes resolvedAddressTypes, long queryTimeoutMillis) {
        this.delegate = delegate;
        this.dnsCache = dnsCache;
        this.executor = executor;
        this.preferredOrder = resolvedAddressTypes == ResolvedAddressTypes.IPV6_PREFERRED ? Ordering.explicit(DnsRecordType.AAAA, DnsRecordType.A) : Ordering.explicit(DnsRecordType.A, DnsRecordType.AAAA);
        this.queryTimeoutMillis = queryTimeoutMillis;
    }

    public CompletableFuture<List<DnsRecord>> resolve(List<? extends DnsQuestion> questions, String logPrefix) {
        assert (!questions.isEmpty());
        DnsQuestionContext ctx = new DnsQuestionContext(this.executor, this.queryTimeoutMillis);
        if (questions.size() == 1) {
            return this.resolveOne(ctx, questions.get(0));
        }
        return this.resolveAll(ctx, questions, logPrefix);
    }

    private CompletableFuture<List<DnsRecord>> resolveOne(DnsQuestionContext ctx, DnsQuestion question) {
        CompletableFuture<List<DnsRecord>> future = this.delegate.resolve(ctx, question);
        ctx.whenCancelled().handle((unused0, unused1) -> {
            if (!future.isDone()) {
                future.completeExceptionally(new DnsTimeoutException(question + " is timed out after " + ctx.queryTimeoutMillis() + " milliseconds."));
            }
            return null;
        });
        future.handle((unused0, unused1) -> {
            ctx.cancel();
            return null;
        });
        return future;
    }

    CompletableFuture<List<DnsRecord>> resolveAll(DnsQuestionContext ctx, List<? extends DnsQuestion> questions, String logPrefix) {
        List results = questions.stream().map(question -> this.delegate.resolve(ctx, (DnsQuestion)question)).collect(ImmutableList.toImmutableList());
        CompletionStage future = CompletableFuture.allOf(results.toArray(EMPTY_FUTURES)).handle((unused0, unused1) -> {
            UnknownHostException cause;
            ArrayList<DnsRecord> records = new ArrayList<DnsRecord>();
            ArrayList<Throwable> causes = null;
            for (CompletableFuture result : results) {
                try {
                    records.addAll((Collection)result.get());
                }
                catch (Throwable ex) {
                    if (!records.isEmpty()) continue;
                    if (causes == null) {
                        causes = new ArrayList<Throwable>();
                    }
                    causes.add(Exceptions.peel(ex));
                }
            }
            if (!records.isEmpty()) {
                if (records.size() > 1) {
                    records.sort(Comparator.comparing(DnsRecord::type, this.preferredOrder));
                }
                return Collections.unmodifiableList(records);
            }
            if (causes == null) {
                cause = new UnknownHostException("Failed to resolve: " + questions + " (empty result)");
            } else {
                cause = new UnknownHostException("Failed to resolve: " + questions);
                for (Throwable c : causes) {
                    cause.addSuppressed(c);
                }
            }
            return (List)Exceptions.throwUnsafely(cause);
        });
        ctx.whenCancelled().handle((arg_0, arg_1) -> DefaultDnsResolver.lambda$resolveAll$4((CompletableFuture)future, logPrefix, questions, ctx, arg_0, arg_1));
        return future;
    }

    public DnsCache dnsCache() {
        return this.dnsCache;
    }

    @Override
    public void close() {
        this.delegate.close();
    }

    private static /* synthetic */ Object lambda$resolveAll$4(CompletableFuture future, String logPrefix, List questions, DnsQuestionContext ctx, Void unused0, Throwable unused1) {
        if (!future.isDone()) {
            future.completeExceptionally(new DnsTimeoutException('[' + logPrefix + "] " + questions + " is timed out after " + ctx.queryTimeoutMillis() + " milliseconds."));
        }
        return null;
    }
}

