/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.client;

import com.linecorp.armeria.client.ClientRequestContext;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.logging.RequestLog;
import com.linecorp.armeria.common.logging.RequestLogProperty;
import com.linecorp.armeria.common.util.Exceptions;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;

public final class AbstractRuleBuilderUtil {
    public static BiFunction<? super ClientRequestContext, ? super Throwable, Boolean> buildFilter(BiPredicate<ClientRequestContext, RequestHeaders> requestHeadersFilter, @Nullable BiPredicate<ClientRequestContext, ResponseHeaders> responseHeadersFilter, @Nullable BiPredicate<ClientRequestContext, HttpHeaders> responseTrailersFilter, @Nullable BiPredicate<ClientRequestContext, Throwable> exceptionFilter, boolean hasResponseFilter) {
        return (ctx, cause) -> {
            HttpHeaders responseTrailers;
            ResponseHeaders responseHeaders;
            RequestHeaders requestHeaders;
            RequestLog log = ctx.log().partial();
            if (log.isAvailable(RequestLogProperty.REQUEST_HEADERS) && !requestHeadersFilter.test((ClientRequestContext)ctx, requestHeaders = log.requestHeaders())) {
                return false;
            }
            if (exceptionFilter == null && responseHeadersFilter == null && responseTrailersFilter == null && !hasResponseFilter) {
                return true;
            }
            if (cause != null && exceptionFilter != null && exceptionFilter.test((ClientRequestContext)ctx, Exceptions.peel(cause))) {
                return true;
            }
            if (responseHeadersFilter != null && log.isAvailable(RequestLogProperty.RESPONSE_HEADERS) && responseHeadersFilter.test((ClientRequestContext)ctx, responseHeaders = log.responseHeaders())) {
                return true;
            }
            if (responseTrailersFilter != null && log.isAvailable(RequestLogProperty.RESPONSE_TRAILERS) && responseTrailersFilter.test((ClientRequestContext)ctx, responseTrailers = log.responseTrailers())) {
                return true;
            }
            return false;
        };
    }

    private AbstractRuleBuilderUtil() {
    }
}

