/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.util;

import com.linecorp.armeria.common.annotation.Nullable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public final class TextFormatter {
    private static final DateTimeFormatter dateTimeFormatter = new DateTimeFormatterBuilder().appendPattern("yyyy-MM-dd'T'HH:mm:ss.SSSX").toFormatter(Locale.ENGLISH).withZone(ZoneId.of("GMT"));

    private TextFormatter() {
    }

    public static StringBuilder elapsed(long elapsedNanos) {
        StringBuilder buf = new StringBuilder(16);
        TextFormatter.appendElapsed(buf, elapsedNanos);
        return buf;
    }

    public static StringBuilder elapsed(long startTimeNanos, long endTimeNanos) {
        return TextFormatter.elapsed(endTimeNanos - startTimeNanos);
    }

    public static void appendElapsed(StringBuilder buf, long elapsedNanos) {
        if (elapsedNanos >= 100000000000L) {
            buf.append(elapsedNanos / 1000000000L).append("s(").append(elapsedNanos).append("ns)");
        } else if (elapsedNanos >= 100000000L) {
            buf.append(elapsedNanos / 1000000L).append("ms(").append(elapsedNanos).append("ns)");
        } else if (elapsedNanos >= 100000L) {
            buf.append(elapsedNanos / 1000L).append("\u00b5s(").append(elapsedNanos).append("ns)");
        } else {
            buf.append(elapsedNanos).append("ns");
        }
    }

    public static void appendElapsed(StringBuilder buf, long startTimeNanos, long endTimeNanos) {
        TextFormatter.appendElapsed(buf, endTimeNanos - startTimeNanos);
    }

    public static StringBuilder size(long size) {
        StringBuilder buf = new StringBuilder(16);
        TextFormatter.appendSize(buf, size);
        return buf;
    }

    public static void appendSize(StringBuilder buf, long size) {
        if (size >= 0x6400000L) {
            buf.append(size / 0x100000L).append("MiB(").append(size).append("B)");
        } else if (size >= 102400L) {
            buf.append(size / 1024L).append("KiB(").append(size).append("B)");
        } else {
            buf.append(size).append('B');
        }
    }

    public static StringBuilder elapsedAndSize(long startTimeNanos, long endTimeNanos, long size) {
        StringBuilder buf = new StringBuilder(16);
        TextFormatter.appendElapsedAndSize(buf, startTimeNanos, endTimeNanos, size);
        return buf;
    }

    public static void appendElapsedAndSize(StringBuilder buf, long startTimeNanos, long endTimeNanos, long size) {
        TextFormatter.appendElapsed(buf, startTimeNanos, endTimeNanos);
        buf.append(", ");
        TextFormatter.appendSize(buf, size);
    }

    public static StringBuilder epochMillis(long timeMillis) {
        StringBuilder buf = new StringBuilder(45);
        TextFormatter.appendEpochMillis(buf, timeMillis);
        return buf;
    }

    public static void appendEpochMillis(StringBuilder buf, long timeMillis) {
        buf.append(dateTimeFormatter.format(Instant.ofEpochMilli(timeMillis))).append('(').append(timeMillis).append(')');
    }

    public static StringBuilder epochMicros(long timeMicros) {
        StringBuilder buf = new StringBuilder(45);
        TextFormatter.appendEpochMicros(buf, timeMicros);
        return buf;
    }

    public static void appendEpochMicros(StringBuilder buf, long timeMicros) {
        buf.append(dateTimeFormatter.format(Instant.ofEpochMilli(TimeUnit.MICROSECONDS.toMillis(timeMicros)))).append('(').append(timeMicros).append(')');
    }

    public static StringBuilder socketAddress(@Nullable SocketAddress addr) {
        StringBuilder buf = new StringBuilder(32);
        TextFormatter.appendSocketAddress(buf, addr);
        return buf;
    }

    public static void appendSocketAddress(StringBuilder buf, @Nullable SocketAddress addr) {
        String ip;
        if (!(addr instanceof InetSocketAddress)) {
            buf.append(addr);
            return;
        }
        InetSocketAddress isa = (InetSocketAddress)addr;
        String host = isa.getHostString();
        InetAddress resolvedAddr = isa.getAddress();
        String string = ip = resolvedAddr != null ? resolvedAddr.getHostAddress() : null;
        if (host != null) {
            if (ip != null) {
                if (host.equals(ip)) {
                    buf.append(ip);
                } else {
                    buf.append(host).append('/').append(ip);
                }
            } else {
                buf.append(host);
            }
        } else {
            buf.append(ip);
        }
        buf.append(':').append(isa.getPort());
    }

    public static StringBuilder inetAddress(@Nullable InetAddress addr) {
        StringBuilder buf = new StringBuilder(32);
        TextFormatter.appendInetAddress(buf, addr);
        return buf;
    }

    public static void appendInetAddress(StringBuilder buf, @Nullable InetAddress addr) {
        if (addr == null) {
            buf.append("null");
            return;
        }
        String str = addr.toString();
        int slashPos = str.indexOf(47);
        if (slashPos < 0) {
            buf.append(str);
            return;
        }
        if (slashPos == 0) {
            buf.append(str, 1, str.length());
            return;
        }
        if (slashPos * 2 + 1 != str.length()) {
            buf.append(str);
            return;
        }
        for (int i = 0; i < slashPos; ++i) {
            if (str.charAt(i) == str.charAt(i + slashPos + 1)) continue;
            buf.append(str);
            return;
        }
        buf.append(str, 0, slashPos);
    }
}

