/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.util;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.AsyncCloseableSupport;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.common.util.ListenableAsyncCloseable;
import com.linecorp.armeria.common.util.UnmodifiableFuture;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StartStopSupport<T, U, V, L>
implements ListenableAsyncCloseable {
    private static final Logger logger = LoggerFactory.getLogger(StartStopSupport.class);
    private final Executor executor;
    private final List<L> listeners = new CopyOnWriteArrayList<L>();
    private final AsyncCloseableSupport closeable = AsyncCloseableSupport.of(this::closeAsync);
    private volatile State state = State.STOPPED;
    private UnmodifiableFuture<?> future = UnmodifiableFuture.completedFuture(null);

    protected StartStopSupport(Executor executor) {
        this.executor = Objects.requireNonNull(executor, "executor");
    }

    public final void addListener(L listener) {
        this.listeners.add(Objects.requireNonNull(listener, "listener"));
    }

    public final boolean removeListener(L listener) {
        return this.listeners.remove(Objects.requireNonNull(listener, "listener"));
    }

    public final CompletableFuture<V> start(boolean failIfStarted) {
        return this.start(null, null, failIfStarted);
    }

    public final CompletableFuture<V> start(@Nullable T arg, boolean failIfStarted) {
        return this.start(arg, null, failIfStarted);
    }

    public final CompletableFuture<V> start(@Nullable T arg, @Nullable U rollbackArg, boolean failIfStarted) {
        return this.start0(arg, rollbackArg, failIfStarted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized UnmodifiableFuture<V> start0(@Nullable T arg, @Nullable U rollbackArg, boolean failIfStarted) {
        if (this.closeable.isClosing()) {
            return UnmodifiableFuture.exceptionallyCompletedFuture(new IllegalStateException("closed already"));
        }
        switch (this.state) {
            case STARTING: 
            case STARTED: {
                if (failIfStarted) {
                    return UnmodifiableFuture.exceptionallyCompletedFuture(new IllegalStateException("must be stopped to start; currently " + (Object)((Object)this.state)));
                }
                UnmodifiableFuture<?> castFuture = this.future;
                return castFuture;
            }
            case STOPPING: {
                return UnmodifiableFuture.wrap(((CompletableFuture)this.future.exceptionally(unused -> null)).thenComposeAsync(unused -> this.start(arg, failIfStarted), this.executor));
            }
        }
        assert (this.state == State.STOPPED) : "state: " + (Object)((Object)this.state);
        this.state = State.STARTING;
        CompletableFuture startFuture = new CompletableFuture();
        boolean submitted = false;
        try {
            this.executor.execute(() -> {
                try {
                    this.notifyListeners(State.STARTING, arg, null, null);
                    CompletionStage<V> f = this.doStart(arg);
                    Preconditions.checkState(f != null, "doStart() returned null.");
                    f.handle((result, cause) -> {
                        if (cause != null) {
                            startFuture.completeExceptionally((Throwable)cause);
                        } else {
                            startFuture.complete(result);
                        }
                        return null;
                    });
                }
                catch (Exception e) {
                    startFuture.completeExceptionally(e);
                }
            });
            submitted = true;
        }
        catch (Exception e) {
            UnmodifiableFuture unmodifiableFuture = UnmodifiableFuture.exceptionallyCompletedFuture(e);
            return unmodifiableFuture;
        }
        finally {
            if (!submitted) {
                this.state = State.STOPPED;
            }
        }
        UnmodifiableFuture future = UnmodifiableFuture.wrap(((CompletableFuture)startFuture.handleAsync((result, cause) -> {
            if (cause != null) {
                CompletionStage rollbackFuture = this.stop(rollbackArg, true).exceptionally(stopCause -> {
                    this.rollbackFailed(Exceptions.peel(stopCause));
                    return null;
                });
                return ((CompletableFuture)rollbackFuture).thenCompose(unused -> UnmodifiableFuture.exceptionallyCompletedFuture(cause));
            }
            this.enter(State.STARTED, arg, null, result);
            return UnmodifiableFuture.completedFuture(result);
        }, this.executor)).thenCompose(Function.identity()));
        this.future = future;
        return future;
    }

    public final CompletableFuture<Void> stop() {
        return this.stop(null);
    }

    public final CompletableFuture<Void> stop(@Nullable U arg) {
        return this.stop(arg, false);
    }

    private CompletableFuture<Void> stop(@Nullable U arg, boolean rollback) {
        return this.stop0(arg, rollback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized UnmodifiableFuture<Void> stop0(@Nullable U arg, boolean rollback) {
        switch (this.state) {
            case STARTING: {
                if (rollback) break;
                return UnmodifiableFuture.wrap(((CompletableFuture)this.future.exceptionally(unused -> null)).thenComposeAsync(unused -> this.stop(arg), this.executor));
            }
            case STOPPING: 
            case STOPPED: {
                UnmodifiableFuture<Void> castFuture = this.future;
                return castFuture;
            }
        }
        assert (this.state == State.STARTED || rollback) : "state: " + (Object)((Object)this.state) + ", rollback: " + rollback;
        State oldState = this.state;
        this.state = State.STOPPING;
        CompletableFuture stopFuture = new CompletableFuture();
        boolean submitted = false;
        try {
            this.executor.execute(() -> {
                try {
                    this.notifyListeners(State.STOPPING, null, arg, null);
                    CompletionStage<Void> f = this.doStop(arg);
                    Preconditions.checkState(f != null, "doStop() returned null.");
                    f.handle((unused, cause) -> {
                        if (cause != null) {
                            stopFuture.completeExceptionally((Throwable)cause);
                        } else {
                            stopFuture.complete(null);
                        }
                        return null;
                    });
                }
                catch (Exception e) {
                    stopFuture.completeExceptionally(e);
                }
            });
            submitted = true;
        }
        catch (Exception e) {
            UnmodifiableFuture<Void> unmodifiableFuture = UnmodifiableFuture.exceptionallyCompletedFuture(e);
            return unmodifiableFuture;
        }
        finally {
            if (!submitted) {
                this.state = oldState;
            }
        }
        UnmodifiableFuture<Void> future = UnmodifiableFuture.wrap(stopFuture.whenCompleteAsync((unused1, cause) -> this.enter(State.STOPPED, null, arg, null), this.executor));
        this.future = future;
        return future;
    }

    @Override
    public final boolean isClosing() {
        return this.closeable.isClosing();
    }

    @Override
    public final boolean isClosed() {
        return this.closeable.isClosed();
    }

    @Override
    public final CompletableFuture<?> whenClosed() {
        return this.closeable.whenClosed();
    }

    @Override
    public final CompletableFuture<?> closeAsync() {
        return this.closeable.closeAsync();
    }

    private void closeAsync(CompletableFuture<?> future) {
        this.stop(null).handle((result, cause) -> {
            if (cause != null) {
                future.completeExceptionally((Throwable)cause);
            } else {
                future.complete(null);
            }
            return null;
        });
    }

    @Override
    public final void close() {
        try {
            this.closeable.close();
        }
        catch (Throwable e) {
            this.closeFailed(Exceptions.peel(e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void enter(State state, @Nullable T startArg, @Nullable U stopArg, @Nullable V startResult) {
        StartStopSupport startStopSupport = this;
        synchronized (startStopSupport) {
            assert (this.state != state) : "transition to the same state: " + (Object)((Object)state);
            this.state = state;
        }
        this.notifyListeners(state, startArg, stopArg, startResult);
    }

    private void notifyListeners(State state, @Nullable T startArg, @Nullable U stopArg, @Nullable V startResult) {
        for (L l : this.listeners) {
            try {
                switch (state) {
                    case STARTING: {
                        this.notifyStarting(l, startArg);
                        break;
                    }
                    case STARTED: {
                        this.notifyStarted(l, startArg, startResult);
                        break;
                    }
                    case STOPPING: {
                        this.notifyStopping(l, stopArg);
                        break;
                    }
                    case STOPPED: {
                        this.notifyStopped(l, stopArg);
                        break;
                    }
                    default: {
                        throw new Error("unknown state: " + (Object)((Object)state));
                    }
                }
            }
            catch (Exception cause) {
                this.notificationFailed(l, cause);
                if (state != State.STARTING) continue;
                throw new IllegalStateException("Failed to start: " + cause, cause);
            }
        }
    }

    protected abstract CompletionStage<V> doStart(@Nullable T var1) throws Exception;

    protected abstract CompletionStage<Void> doStop(@Nullable U var1) throws Exception;

    protected void notifyStarting(L listener, @Nullable T arg) throws Exception {
    }

    protected void notifyStarted(L listener, @Nullable T arg, @Nullable V result) throws Exception {
    }

    protected void notifyStopping(L listener, @Nullable U arg) throws Exception {
    }

    protected void notifyStopped(L listener, @Nullable U arg) throws Exception {
    }

    protected void rollbackFailed(Throwable cause) {
        StartStopSupport.logStopFailure(cause);
    }

    protected void notificationFailed(L listener, Throwable cause) {
        logger.warn("Failed to notify a listener: {}", listener, (Object)cause);
    }

    protected void closeFailed(Throwable cause) {
        StartStopSupport.logStopFailure(cause);
    }

    private static void logStopFailure(Throwable cause) {
        logger.warn("Failed to stop: {}", (Object)cause.getMessage(), (Object)cause);
    }

    public String toString() {
        return this.state.name();
    }

    static enum State {
        STARTING,
        STARTED,
        STOPPING,
        STOPPED;

    }
}

