/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.util;

import com.linecorp.armeria.common.util.AbstractOptionValue;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.BiMap;
import com.linecorp.armeria.internal.shaded.guava.collect.HashBiMap;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiFunction;
import java.util.function.Function;

public abstract class AbstractOption<T extends AbstractOption<T, U, V>, U extends AbstractOptionValue<U, T, V>, V>
implements Comparable<AbstractOption<?, ?, ?>> {
    private static final AtomicLong uniqueIdGenerator = new AtomicLong();
    private static final ClassValue<Pool> map = new ClassValue<Pool>(){

        @Override
        protected Pool computeValue(Class<?> type) {
            return new Pool(type);
        }
    };
    private final long uniqueId = uniqueIdGenerator.getAndIncrement();
    private final String name;
    private final V defaultValue;
    private final Function<V, V> validator;
    private final BiFunction<U, U, U> mergeFunction;

    protected static <T extends Set<?>> T allOptions(Class<?> type) {
        Objects.requireNonNull(type, "type");
        Pool pool = map.get(type);
        if (pool == null) {
            ImmutableSet cast = ImmutableSet.of();
            return (T)cast;
        }
        Set<AbstractOption<?, ?, ?>> cast = pool.getAll();
        return (T)cast;
    }

    protected static <T extends AbstractOption<?, ?, ?>> T of(Class<?> type, String name) {
        Objects.requireNonNull(type, "type");
        Objects.requireNonNull(name, "name");
        Pool pool = map.get(type);
        if (pool == null) {
            throw new NoSuchElementException('\'' + type.getName() + '#' + name + "' does not exist.");
        }
        AbstractOption<?, ?, ?> cast = pool.get(name);
        return (T)cast;
    }

    protected static <T extends AbstractOption<T, U, V>, U extends AbstractOptionValue<U, T, V>, V> T define(Class<?> type, String name, V defaultValue, Factory<T, U, V> optionFactory, Function<V, V> validator, BiFunction<U, U, U> mergeFunction) {
        Objects.requireNonNull(type, "type");
        Objects.requireNonNull(name, "name");
        Objects.requireNonNull(defaultValue, "defaultValue");
        Objects.requireNonNull(optionFactory, "optionFactory");
        Objects.requireNonNull(validator, "validator");
        Objects.requireNonNull(mergeFunction, "mergeFunction");
        return map.get(type).define(optionFactory, name, defaultValue, validator, mergeFunction);
    }

    protected AbstractOption(String name, V defaultValue, Function<V, V> validator, BiFunction<U, U, U> mergeFunction) {
        this.name = Objects.requireNonNull(name, "name");
        this.defaultValue = Objects.requireNonNull(defaultValue, "defaultValue");
        this.validator = Objects.requireNonNull(validator, "validator");
        this.mergeFunction = Objects.requireNonNull(mergeFunction, "mergeFunction");
    }

    public final String name() {
        return this.name;
    }

    public final V defaultValue() {
        return this.defaultValue;
    }

    final U merge(U oldValue, U newValue) {
        Objects.requireNonNull(oldValue, "oldValue");
        Objects.requireNonNull(newValue, "newValue");
        AbstractOptionValue merged = (AbstractOptionValue)this.mergeFunction.apply(oldValue, newValue);
        Preconditions.checkState(merged != null, "mergeFunction must not return null: %s, %s, %s", this, oldValue, newValue);
        return (U)merged;
    }

    public final U newValue(V value) {
        Objects.requireNonNull(value, "value");
        value = this.validator.apply(value);
        Objects.requireNonNull(value, "validator must not return null.");
        return this.doNewValue(value);
    }

    protected abstract U doNewValue(V var1);

    public final int hashCode() {
        return super.hashCode();
    }

    @Override
    public final int compareTo(AbstractOption<?, ?, ?> o) {
        return Long.compare(this.uniqueId, o.uniqueId);
    }

    public final boolean equals(Object obj) {
        return super.equals(obj);
    }

    public final String toString() {
        return this.name();
    }

    private static final class Pool {
        private final Class<?> type;
        private final BiMap<String, AbstractOption<?, ?, ?>> options;

        Pool(Class<?> type) {
            this.type = type;
            this.options = HashBiMap.create();
        }

        synchronized <T extends AbstractOption<T, U, V>, U extends AbstractOptionValue<U, T, V>, V> T define(Factory<T, U, V> optionFactory, String name, V defaultValue, Function<V, V> validator, BiFunction<U, U, U> mergeFunction) {
            AbstractOption oldOption = (AbstractOption)this.options.get(name);
            if (oldOption != null) {
                throw new IllegalStateException('\'' + this.type.getName() + '#' + name + "' exists already.");
            }
            T newOption = optionFactory.get(name, defaultValue, validator, mergeFunction);
            Preconditions.checkArgument(this.type.isInstance(newOption), "OptionFactory.newOption() must return an instance of %s.", this.type);
            this.options.put(name, (AbstractOption<?, ?, ?>)newOption);
            return newOption;
        }

        synchronized AbstractOption<?, ?, ?> get(String name) {
            AbstractOption option = (AbstractOption)this.options.get(name);
            if (option == null) {
                throw new NoSuchElementException('\'' + this.type.getName() + '#' + name + "' does not exist.");
            }
            return option;
        }

        synchronized Set<AbstractOption<?, ?, ?>> getAll() {
            return ImmutableSet.copyOf(this.options.values());
        }
    }

    @FunctionalInterface
    protected static interface Factory<T extends AbstractOption<T, U, V>, U extends AbstractOptionValue<U, T, V>, V> {
        public T get(String var1, V var2, Function<V, V> var3, BiFunction<U, U, U> var4);
    }
}

