/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.util;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.Listenable;
import com.linecorp.armeria.internal.common.util.IdentityHashStrategy;
import com.linecorp.armeria.internal.shaded.fastutil.objects.ObjectLinkedOpenCustomHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;

public abstract class AbstractListenable<T>
implements Listenable<T> {
    private static final Consumer[] EMPTY_LISTENERS = new Consumer[0];
    private final Set<Consumer<? super T>> updateListeners = new ObjectLinkedOpenCustomHashSet(IdentityHashStrategy.of());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void notifyListeners(T latestValue) {
        Consumer[] consumerArray = this.updateListeners;
        synchronized (this.updateListeners) {
            Consumer[] updateListeners = this.updateListeners.toArray(EMPTY_LISTENERS);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (Consumer listener : updateListeners) {
                listener.accept(latestValue);
            }
            return;
        }
    }

    @Nullable
    protected T latestValue() {
        return null;
    }

    @Override
    public final void addListener(Consumer<? super T> listener) {
        this.addListener(listener, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addListener(Consumer<? super T> listener, boolean notifyLatestValue) {
        Objects.requireNonNull(listener, "listener");
        Set<Consumer<? super T>> set = this.updateListeners;
        synchronized (set) {
            T latest;
            if (notifyLatestValue && (latest = this.latestValue()) != null) {
                listener.accept(latest);
            }
            this.updateListeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeListener(Consumer<?> listener) {
        Objects.requireNonNull(listener, "listener");
        Set<Consumer<? super T>> set = this.updateListeners;
        synchronized (set) {
            this.updateListeners.remove(listener);
        }
    }
}

