/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.stream;

import com.google.errorprone.annotations.CheckReturnValue;
import com.linecorp.armeria.common.stream.ClosedStreamException;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.function.Supplier;

public interface StreamWriter<T> {
    public boolean isOpen();

    default public void write(T o) {
        if (!this.tryWrite(o)) {
            throw ClosedStreamException.get();
        }
    }

    default public void write(Supplier<? extends T> o) {
        if (!this.tryWrite(o)) {
            throw ClosedStreamException.get();
        }
    }

    @CheckReturnValue
    public boolean tryWrite(T var1);

    @CheckReturnValue
    default public boolean tryWrite(Supplier<? extends T> o) {
        Objects.requireNonNull(o, "o");
        T obj = Objects.requireNonNull(o.get(), "o.get() returned null");
        return this.tryWrite(obj);
    }

    public CompletableFuture<Void> whenConsumed();

    public void close();

    public void close(Throwable var1);
}

