/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.stream;

import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.stream.AbortedStreamException;
import com.linecorp.armeria.common.stream.CancelledSubscriptionException;
import com.linecorp.armeria.common.stream.NoopSubscriber;
import com.linecorp.armeria.common.stream.StreamMessage;
import com.linecorp.armeria.common.stream.SubscriptionOption;
import com.linecorp.armeria.common.util.EventLoopCheckingFuture;
import com.linecorp.armeria.common.util.Exceptions;
import com.linecorp.armeria.internal.common.stream.InternalStreamMessageUtil;
import com.linecorp.armeria.internal.common.stream.NoopSubscription;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.internal.shaded.guava.math.LongMath;
import com.linecorp.armeria.server.ServiceRequestContext;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.concurrent.EventExecutor;
import java.io.IOException;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.CompletionHandler;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PathStreamMessage
implements StreamMessage<HttpData> {
    private static final Logger logger = LoggerFactory.getLogger(PathStreamMessage.class);
    private static final AtomicIntegerFieldUpdater<PathStreamMessage> subscribedUpdater = AtomicIntegerFieldUpdater.newUpdater(PathStreamMessage.class, "subscribed");
    static final int DEFAULT_FILE_BUFFER_SIZE = 8192;
    private static final Set<StandardOpenOption> READ_OPERATION = ImmutableSet.of(StandardOpenOption.READ);
    private final CompletableFuture<Void> completionFuture = new EventLoopCheckingFuture<Void>();
    private final Path path;
    private final ByteBufAllocator alloc;
    @Nullable
    private final ExecutorService blockingTaskExecutor;
    private final int bufferSize;
    private volatile int subscribed;
    @Nullable
    private volatile PathSubscription pathSubscription;

    PathStreamMessage(Path path, ByteBufAllocator alloc, @Nullable ExecutorService blockingTaskExecutor, int bufferSize) {
        this.path = Objects.requireNonNull(path, "path");
        this.alloc = Objects.requireNonNull(alloc, "alloc");
        this.blockingTaskExecutor = blockingTaskExecutor;
        this.bufferSize = bufferSize;
    }

    @Override
    public boolean isOpen() {
        return !this.completionFuture.isDone();
    }

    @Override
    public boolean isEmpty() {
        if (this.isOpen()) {
            return false;
        }
        PathSubscription pathSubscription = this.pathSubscription;
        return pathSubscription == null || pathSubscription.position == 0;
    }

    @Override
    public long demand() {
        PathSubscription pathSubscription = this.pathSubscription;
        if (pathSubscription != null) {
            return pathSubscription.requested;
        }
        return 0L;
    }

    @Override
    public CompletableFuture<Void> whenComplete() {
        return this.completionFuture;
    }

    @Override
    public void subscribe(Subscriber<? super HttpData> subscriber, EventExecutor executor, SubscriptionOption ... options) {
        Objects.requireNonNull(subscriber, "subscriber");
        Objects.requireNonNull(executor, "executor");
        Objects.requireNonNull(options, "options");
        if (!subscribedUpdater.compareAndSet(this, 0, 1)) {
            subscriber.onSubscribe((Subscription)NoopSubscription.get());
            subscriber.onError((Throwable)new IllegalStateException("Only single subscriber is allowed!"));
            return;
        }
        if (executor.inEventLoop()) {
            this.subscribe0(subscriber, executor, options);
        } else {
            executor.execute(() -> this.subscribe0(subscriber, executor, options));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void subscribe0(Subscriber<? super HttpData> subscriber, EventExecutor executor, SubscriptionOption ... options) {
        PathSubscription pathSubscription;
        ServiceRequestContext serviceRequestContext;
        ExecutorService blockingTaskExecutor = this.blockingTaskExecutor != null ? this.blockingTaskExecutor : ((serviceRequestContext = ServiceRequestContext.currentOrNull()) != null ? serviceRequestContext.blockingTaskExecutor() : null);
        AsynchronousFileChannel fileChannel = null;
        boolean success = false;
        try {
            fileChannel = AsynchronousFileChannel.open(this.path, READ_OPERATION, blockingTaskExecutor, new FileAttribute[0]);
            if (fileChannel.size() == 0L) {
                subscriber.onSubscribe((Subscription)NoopSubscription.get());
                if (this.completionFuture.isCompletedExceptionally()) {
                    this.completionFuture.handle((unused, cause) -> {
                        subscriber.onError(Exceptions.peel(cause));
                        return null;
                    });
                } else {
                    subscriber.onComplete();
                    this.completionFuture.complete(null);
                }
                return;
            }
            success = true;
        }
        catch (IOException e) {
            subscriber.onSubscribe((Subscription)NoopSubscription.get());
            subscriber.onError((Throwable)e);
            this.completionFuture.completeExceptionally(e);
            return;
        }
        finally {
            if (!success && fileChannel != null) {
                try {
                    fileChannel.close();
                }
                catch (IOException e) {
                    logger.warn("Unexpected exception while closing {}.", (Object)fileChannel, (Object)e);
                }
            }
        }
        this.pathSubscription = pathSubscription = new PathSubscription(fileChannel, subscriber, executor, this.bufferSize, InternalStreamMessageUtil.containsNotifyCancellation(options), InternalStreamMessageUtil.containsWithPooledObjects(options));
        subscriber.onSubscribe((Subscription)pathSubscription);
    }

    @Override
    public void abort() {
        this.abort(AbortedStreamException.get());
    }

    @Override
    public void abort(Throwable cause) {
        Objects.requireNonNull(cause, "cause");
        PathSubscription pathSubscription = this.pathSubscription;
        if (pathSubscription != null) {
            pathSubscription.maybeCloseFileChannel();
            pathSubscription.close(cause);
        }
        this.completionFuture.completeExceptionally(cause);
    }

    private final class PathSubscription
    implements CompletionHandler<Integer, ByteBuf>,
    Subscription {
        private final AsynchronousFileChannel fileChannel;
        private Subscriber<? super HttpData> downstream;
        private final int bufferSize;
        private final EventExecutor executor;
        private final boolean notifyCancellation;
        private final boolean withPooledObjects;
        private boolean reading;
        private boolean closed;
        private volatile long requested;
        private volatile int position;

        private PathSubscription(AsynchronousFileChannel fileChannel, Subscriber<? super HttpData> downstream, EventExecutor executor, int bufferSize, boolean notifyCancellation, boolean withPooledObjects) {
            this.fileChannel = fileChannel;
            this.downstream = downstream;
            this.executor = executor;
            this.bufferSize = bufferSize;
            this.notifyCancellation = notifyCancellation;
            this.withPooledObjects = withPooledObjects;
        }

        public void request(long n) {
            if (n <= 0L) {
                this.downstream.onError((Throwable)new IllegalArgumentException("Rule \u00a73.9 violated: non-positive subscription requests are forbidden."));
                this.cancel();
            } else {
                this.request0(n);
            }
        }

        private void request0(long n) {
            long requested = this.requested;
            if (requested == Long.MAX_VALUE) {
                return;
            }
            this.requested = n == Long.MAX_VALUE ? Long.MAX_VALUE : LongMath.saturatedAdd(requested, n);
            if (requested > 0L) {
                return;
            }
            this.read();
        }

        private void read() {
            if (!this.reading && !this.closed && this.requested > 0L) {
                --this.requested;
                this.reading = true;
                ByteBuf buffer = PathStreamMessage.this.alloc.buffer(this.bufferSize);
                this.fileChannel.read(buffer.nioBuffer(0, this.bufferSize), this.position, buffer, this);
            }
        }

        public void cancel() {
            if (this.executor.inEventLoop()) {
                this.cancel0();
            } else {
                this.executor.execute(this::cancel0);
            }
        }

        private void cancel0() {
            if (this.closed) {
                return;
            }
            this.closed = true;
            if (!this.reading) {
                this.maybeCloseFileChannel();
            }
            CancelledSubscriptionException cause = CancelledSubscriptionException.get();
            if (this.notifyCancellation) {
                this.downstream.onError((Throwable)cause);
            }
            PathStreamMessage.this.completionFuture.completeExceptionally(cause);
            this.downstream = NoopSubscriber.get();
        }

        @Override
        public void completed(Integer result, ByteBuf byteBuf) {
            this.executor.execute(() -> {
                if (this.closed) {
                    byteBuf.release();
                    this.maybeCloseFileChannel();
                } else if (result >= 0) {
                    HttpData data;
                    this.position += result.intValue();
                    if (this.withPooledObjects) {
                        byteBuf.writerIndex(result.intValue());
                        data = HttpData.wrap(byteBuf);
                    } else {
                        data = HttpData.wrap(ByteBufUtil.getBytes((ByteBuf)byteBuf, (int)0, (int)result));
                        byteBuf.release();
                    }
                    this.downstream.onNext((Object)data);
                    this.reading = false;
                    this.read();
                } else {
                    byteBuf.release();
                    this.maybeCloseFileChannel();
                    this.close0(null);
                }
            });
        }

        @Override
        public void failed(Throwable ex, ByteBuf byteBuf) {
            this.executor.execute(() -> {
                byteBuf.release();
                this.maybeCloseFileChannel();
                this.close0(ex);
            });
        }

        private void maybeCloseFileChannel() {
            if (this.fileChannel.isOpen()) {
                try {
                    this.fileChannel.close();
                }
                catch (IOException cause) {
                    logger.warn("Unexpected exception while closing {}.", (Object)this.fileChannel, (Object)cause);
                }
            }
        }

        private void close(@Nullable Throwable cause) {
            if (this.executor.inEventLoop()) {
                this.close0(cause);
            } else {
                this.executor.execute(() -> this.close0(cause));
            }
        }

        private void close0(@Nullable Throwable cause) {
            if (!this.closed) {
                this.closed = true;
                if (cause == null) {
                    this.downstream.onComplete();
                    PathStreamMessage.this.completionFuture.complete(null);
                } else {
                    this.downstream.onError(cause);
                    PathStreamMessage.this.completionFuture.completeExceptionally(cause);
                }
            }
        }
    }
}

