/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.stream;

import com.linecorp.armeria.common.stream.AbstractStreamMessage;
import com.linecorp.armeria.common.stream.ClosedStreamException;
import com.linecorp.armeria.common.stream.StreamMessageAndWriter;
import com.linecorp.armeria.internal.common.stream.StreamMessageUtil;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;

abstract class AbstractStreamMessageAndWriter<T>
extends AbstractStreamMessage<T>
implements StreamMessageAndWriter<T> {
    AbstractStreamMessageAndWriter() {
    }

    @Override
    public boolean tryWrite(T obj) {
        Objects.requireNonNull(obj, "obj");
        if (!this.isOpen()) {
            StreamMessageUtil.closeOrAbort(obj);
            return false;
        }
        this.addObject(obj);
        return true;
    }

    @Override
    public final CompletableFuture<Void> whenConsumed() {
        AwaitDemandFuture f = new AwaitDemandFuture();
        if (!this.isOpen()) {
            f.completeExceptionally(ClosedStreamException.get());
            return f;
        }
        this.addObjectOrEvent(f);
        return f;
    }

    abstract void addObject(T var1);

    abstract void addObjectOrEvent(Object var1);

    static final class AwaitDemandFuture
    extends CompletableFuture<Void> {
        AwaitDemandFuture() {
        }
    }

    static enum State {
        OPEN,
        CLOSED,
        CLEANUP;

    }
}

