/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.multipart;

import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.Iterables;
import java.util.Objects;

public final class Multiparts {
    public static String getBoundary(MediaType contentType) {
        Objects.requireNonNull(contentType, "contentType");
        Preconditions.checkArgument(contentType.isMultipart(), "Content-Type: %s (expected: multipart content type)", (Object)contentType);
        @Nullable String boundary = Iterables.getFirst((Iterable)contentType.parameters().get("boundary"), null);
        if (boundary == null) {
            throw new IllegalStateException("boundary parameter is missing on the Content-Type header");
        }
        return boundary;
    }

    private Multiparts() {
    }
}

