/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.multipart;

import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.multipart.AggregatedBodyPart;
import com.linecorp.armeria.common.multipart.BodyPart;
import com.linecorp.armeria.common.stream.StreamMessage;
import com.linecorp.armeria.common.stream.StreamMessages;
import com.linecorp.armeria.internal.common.HttpObjectAggregator;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.concurrent.EventExecutor;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import org.reactivestreams.Subscriber;

final class DefaultBodyPart
implements BodyPart {
    private final HttpHeaders headers;
    private final StreamMessage<? extends HttpData> content;

    DefaultBodyPart(HttpHeaders headers, StreamMessage<? extends HttpData> content) {
        this.headers = headers;
        this.content = content;
    }

    @Override
    public HttpHeaders headers() {
        return this.headers;
    }

    @Override
    public StreamMessage<HttpData> content() {
        return this.content;
    }

    @Override
    public CompletableFuture<Void> writeTo(Path path, EventExecutor eventExecutor, ExecutorService blockingTaskExecutor, OpenOption ... options) {
        return StreamMessages.writeTo(this.content, path, eventExecutor, blockingTaskExecutor, options);
    }

    @Override
    public CompletableFuture<Void> writeTo(Path path, OpenOption ... options) {
        return StreamMessages.writeTo(this.content, path, options);
    }

    @Override
    public CompletableFuture<AggregatedBodyPart> aggregate() {
        return this.aggregate0(this.content().defaultSubscriberExecutor(), null);
    }

    @Override
    public CompletableFuture<AggregatedBodyPart> aggregate(EventExecutor executor) {
        Objects.requireNonNull(executor, "executor");
        return this.aggregate0(executor, null);
    }

    @Override
    public CompletableFuture<AggregatedBodyPart> aggregateWithPooledObjects(ByteBufAllocator alloc) {
        Objects.requireNonNull(alloc, "alloc");
        return this.aggregate0(this.content().defaultSubscriberExecutor(), alloc);
    }

    @Override
    public CompletableFuture<AggregatedBodyPart> aggregateWithPooledObjects(EventExecutor executor, ByteBufAllocator alloc) {
        Objects.requireNonNull(executor, "executor");
        Objects.requireNonNull(alloc, "alloc");
        return this.aggregate0(executor, alloc);
    }

    private CompletableFuture<AggregatedBodyPart> aggregate0(EventExecutor executor, @Nullable ByteBufAllocator alloc) {
        CompletableFuture<AggregatedBodyPart> future = new CompletableFuture<AggregatedBodyPart>();
        this.content().subscribe((Subscriber<HttpData>)new ContentAggregator(this.headers, future, alloc), executor);
        return future;
    }

    public String toString() {
        return MoreObjects.toStringHelper(this).add("headers", this.headers).add("content", this.content).toString();
    }

    private static final class ContentAggregator
    extends HttpObjectAggregator<AggregatedBodyPart> {
        private final HttpHeaders headers;

        ContentAggregator(HttpHeaders headers, CompletableFuture<AggregatedBodyPart> future, @Nullable ByteBufAllocator alloc) {
            super(future, alloc);
            this.headers = headers;
        }

        @Override
        protected void onHeaders(HttpHeaders headers) {
        }

        @Override
        protected AggregatedBodyPart onSuccess(HttpData content) {
            return AggregatedBodyPart.of(this.headers, content);
        }

        @Override
        protected void onFailure() {
        }
    }
}

