/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.logging;

import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.logging.DefaultRequestLog;
import com.linecorp.armeria.common.logging.RequestLogBuilder;
import com.linecorp.armeria.common.logging.RequestOnlyLog;
import com.linecorp.armeria.common.util.Functions;
import java.util.Objects;
import java.util.function.BiFunction;

public interface RequestLog
extends RequestOnlyLog {
    public static RequestLogBuilder builder(RequestContext ctx) {
        Objects.requireNonNull(ctx, "ctx");
        return new DefaultRequestLog(ctx);
    }

    public long responseStartTimeMicros();

    public long responseStartTimeMillis();

    public long responseStartTimeNanos();

    @Nullable
    public Long responseFirstBytesTransferredTimeNanos();

    public long responseEndTimeNanos();

    default public long responseDurationNanos() {
        return this.responseEndTimeNanos() - this.responseStartTimeNanos();
    }

    default public long totalDurationNanos() {
        return this.responseEndTimeNanos() - this.requestStartTimeNanos();
    }

    default public HttpStatus responseStatus() {
        return this.responseHeaders().status();
    }

    public long responseLength();

    @Nullable
    public Throwable responseCause();

    public ResponseHeaders responseHeaders();

    @Nullable
    public Object responseContent();

    @Nullable
    public Object rawResponseContent();

    @Nullable
    public String responseContentPreview();

    public HttpHeaders responseTrailers();

    default public String toStringResponseOnly() {
        return this.toStringResponseOnly(Functions.second(), Functions.second(), Functions.second());
    }

    default public String toStringResponseOnly(BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable Object> headersSanitizer, BiFunction<? super RequestContext, Object, ? extends @Nullable Object> contentSanitizer) {
        return this.toStringResponseOnly(headersSanitizer, contentSanitizer, headersSanitizer);
    }

    public String toStringResponseOnly(BiFunction<? super RequestContext, ? super ResponseHeaders, ? extends @Nullable Object> var1, BiFunction<? super RequestContext, Object, ? extends @Nullable Object> var2, BiFunction<? super RequestContext, ? super HttpHeaders, ? extends @Nullable Object> var3);
}

