/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.encoding;

import com.linecorp.armeria.common.encoding.BrotliStreamDecoder;
import com.linecorp.armeria.common.encoding.StreamDecoder;
import com.linecorp.armeria.common.encoding.StreamDecoderFactory;
import com.linecorp.armeria.common.encoding.ZlibStreamDecoder;
import io.netty.buffer.ByteBufAllocator;
import io.netty.handler.codec.compression.BrotliDecoder;
import io.netty.handler.codec.compression.ZlibWrapper;

enum StreamDecoderFactories implements StreamDecoderFactory
{
    DEFLATE{

        @Override
        public String encodingHeaderValue() {
            return "deflate";
        }

        @Override
        public StreamDecoder newDecoder(ByteBufAllocator alloc) {
            return new ZlibStreamDecoder(ZlibWrapper.ZLIB, alloc);
        }
    }
    ,
    GZIP{

        @Override
        public String encodingHeaderValue() {
            return "gzip";
        }

        @Override
        public StreamDecoder newDecoder(ByteBufAllocator alloc) {
            return new ZlibStreamDecoder(ZlibWrapper.GZIP, alloc);
        }
    }
    ,
    BROTLI{

        @Override
        public String encodingHeaderValue() {
            return "br";
        }

        @Override
        public StreamDecoder newDecoder(ByteBufAllocator alloc) {
            return new BrotliStreamDecoder(new BrotliDecoder(), alloc);
        }
    };

}

