/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.CacheControl;
import com.linecorp.armeria.common.ServerCacheControlBuilder;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.ArmeriaHttpUtil;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;

public final class ServerCacheControl
extends CacheControl {
    public static final ServerCacheControl EMPTY = ServerCacheControl.builder().build();
    public static final ServerCacheControl DISABLED = ServerCacheControl.builder().noCache().noStore().mustRevalidate().build();
    public static final ServerCacheControl REVALIDATED = ServerCacheControl.builder().noCache().mustRevalidate().build();
    public static final ServerCacheControl IMMUTABLE = ServerCacheControl.builder().maxAgeSeconds(31536000L).cachePublic().immutable().build();
    private static final Map<String, BiConsumer<ServerCacheControlBuilder, String>> DIRECTIVES = ImmutableMap.builder().put("no-cache", (b, v) -> b.noCache()).put("no-store", (b, v) -> b.noStore()).put("no-transform", (b, v) -> b.noTransform()).put("max-age", (b, v) -> {
        long maxAgeSeconds = ArmeriaHttpUtil.parseDirectiveValueAsSeconds(v);
        if (maxAgeSeconds >= 0L) {
            b.maxAgeSeconds(maxAgeSeconds);
        }
    }).put("public", (b, v) -> b.cachePublic()).put("private", (b, v) -> b.cachePrivate()).put("immutable", (b, v) -> b.immutable()).put("must-revalidate", (b, v) -> b.mustRevalidate()).put("proxy-revalidate", (b, v) -> b.proxyRevalidate()).put("s-maxage", (b, v) -> {
        long sMaxAgeSeconds = ArmeriaHttpUtil.parseDirectiveValueAsSeconds(v);
        if (sMaxAgeSeconds >= 0L) {
            b.sMaxAgeSeconds(sMaxAgeSeconds);
        }
    }).build();
    private final boolean cachePublic;
    private final boolean cachePrivate;
    private final boolean immutable;
    private final boolean mustRevalidate;
    private final boolean proxyRevalidate;
    private final long sMaxAgeSeconds;
    @Nullable
    private String headerValue;

    public static ServerCacheControl parse(String ... directives) {
        return ServerCacheControl.parse(ImmutableList.copyOf(Objects.requireNonNull(directives, "directives")));
    }

    public static ServerCacheControl parse(Iterable<String> directives) {
        Objects.requireNonNull(directives, "directives");
        ServerCacheControlBuilder builder = ServerCacheControl.builder();
        for (String d : directives) {
            ArmeriaHttpUtil.parseDirectives(d, (name, value) -> {
                BiConsumer<ServerCacheControlBuilder, String> action = DIRECTIVES.get(name);
                if (action != null) {
                    action.accept(builder, (String)value);
                }
            });
        }
        return builder.build();
    }

    public static ServerCacheControlBuilder builder() {
        return new ServerCacheControlBuilder();
    }

    ServerCacheControl(boolean noCache, boolean noStore, boolean noTransform, long maxAgeSeconds, boolean cachePublic, boolean cachePrivate, boolean immutable, boolean mustRevalidate, boolean proxyRevalidate, long sMaxAgeSeconds) {
        super(noCache, noStore, noTransform, maxAgeSeconds);
        this.cachePublic = cachePublic;
        this.cachePrivate = cachePrivate;
        this.immutable = immutable;
        this.mustRevalidate = mustRevalidate;
        this.proxyRevalidate = proxyRevalidate;
        this.sMaxAgeSeconds = sMaxAgeSeconds;
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && !this.cachePublic && !this.cachePrivate && !this.immutable && !this.mustRevalidate && !this.proxyRevalidate && this.sMaxAgeSeconds < 0L;
    }

    public boolean cachePublic() {
        return this.cachePublic;
    }

    public boolean cachePrivate() {
        return this.cachePrivate;
    }

    public boolean immutable() {
        return this.immutable;
    }

    public boolean mustRevalidate() {
        return this.mustRevalidate;
    }

    public boolean proxyRevalidate() {
        return this.proxyRevalidate;
    }

    public long sMaxAgeSeconds() {
        return this.sMaxAgeSeconds;
    }

    @Override
    public ServerCacheControlBuilder toBuilder() {
        return new ServerCacheControlBuilder(this);
    }

    @Override
    public String asHeaderValue() {
        if (this.headerValue != null) {
            return this.headerValue;
        }
        StringBuilder buf = this.newHeaderValueBuffer();
        if (this.cachePublic) {
            buf.append(", public");
        }
        if (this.cachePrivate) {
            buf.append(", private");
        }
        if (this.immutable) {
            buf.append(", immutable");
        }
        if (this.mustRevalidate) {
            buf.append(", must-revalidate");
        }
        if (this.proxyRevalidate) {
            buf.append(", proxy-revalidate");
        }
        if (this.sMaxAgeSeconds >= 0L) {
            buf.append(", s-maxage=").append(this.sMaxAgeSeconds);
        }
        if (buf.length() == 0) {
            this.headerValue = "";
            return "";
        }
        this.headerValue = buf.substring(2);
        return this.headerValue;
    }

    @Override
    public boolean equals(@Nullable Object o) {
        if (!super.equals(o)) {
            return false;
        }
        ServerCacheControl that = (ServerCacheControl)o;
        return this.cachePublic == that.cachePublic && this.cachePrivate == that.cachePrivate && this.immutable == that.immutable && this.mustRevalidate == that.mustRevalidate && this.proxyRevalidate == that.proxyRevalidate && this.sMaxAgeSeconds == that.sMaxAgeSeconds;
    }

    @Override
    public int hashCode() {
        return (((((super.hashCode() * 31 + (this.cachePublic ? 1 : 0)) * 31 + (this.cachePrivate ? 1 : 0)) * 31 + (this.immutable ? 1 : 0)) * 31 + (this.mustRevalidate ? 1 : 0)) * 31 + (this.proxyRevalidate ? 1 : 0)) * 31 + (int)(this.sMaxAgeSeconds ^ this.sMaxAgeSeconds >>> 32);
    }
}

