/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.MediaTypeSet;
import com.linecorp.armeria.common.SerializationFormatProvider;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.Ascii;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.BiMap;
import com.linecorp.armeria.internal.shaded.guava.collect.HashBiMap;
import com.linecorp.armeria.internal.shaded.guava.collect.HashMultimap;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableBiMap;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.Lists;
import com.linecorp.armeria.internal.shaded.guava.collect.Multimap;
import java.util.Arrays;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SerializationFormat
implements Comparable<SerializationFormat> {
    private static final Logger logger = LoggerFactory.getLogger(SerializationFormat.class);
    private static final BiMap<String, SerializationFormat> uriTextToFormats;
    private static final Set<SerializationFormat> values;
    public static final SerializationFormat NONE;
    public static final SerializationFormat UNKNOWN;
    private final String uriText;
    private final MediaType primaryMediaType;
    private final MediaTypeSet mediaTypes;

    private static SerializationFormat register(BiMap<String, SerializationFormat> uriTextToFormats, Multimap<MediaType, SerializationFormat> simplifiedMediaTypeToFormats, SerializationFormatProvider.Entry entry) {
        Preconditions.checkState(!uriTextToFormats.containsKey(entry.uriText), "serialization format registered already: ", entry.uriText);
        SerializationFormat value = new SerializationFormat(entry.uriText, entry.primaryMediaType, entry.mediaTypes);
        for (MediaType type : entry.mediaTypes) {
            SerializationFormat.checkMediaType(simplifiedMediaTypeToFormats, type);
        }
        uriTextToFormats.put(entry.uriText, value);
        for (MediaType type : entry.mediaTypes) {
            simplifiedMediaTypeToFormats.put(type.withoutParameters(), value);
        }
        return value;
    }

    private static void checkMediaType(Multimap<MediaType, SerializationFormat> simplifiedMediaTypeToFormats, MediaType mediaType) {
        MediaType simplifiedMediaType = mediaType.withoutParameters();
        for (SerializationFormat format : simplifiedMediaTypeToFormats.get(simplifiedMediaType)) {
            for (MediaType registeredMediaType : format.mediaTypes()) {
                Preconditions.checkState(!registeredMediaType.is(mediaType) && !mediaType.is(registeredMediaType), "media type registered already: ", mediaType);
            }
        }
    }

    public static Set<SerializationFormat> values() {
        return values;
    }

    public static SerializationFormat of(String uriText) {
        SerializationFormat value = (SerializationFormat)uriTextToFormats.get(uriText = Ascii.toLowerCase(Objects.requireNonNull(uriText, "uriText")));
        Preconditions.checkArgument(value != null, "unknown serialization format: ", (Object)uriText);
        return value;
    }

    @Nullable
    public static SerializationFormat find(String uriText) {
        uriText = Ascii.toLowerCase(Objects.requireNonNull(uriText, "uriText"));
        return (SerializationFormat)uriTextToFormats.get(uriText);
    }

    @Nullable
    public static SerializationFormat find(MediaType ... ranges) {
        Objects.requireNonNull(ranges, "ranges");
        if (ranges.length == 0) {
            return null;
        }
        for (SerializationFormat f : SerializationFormat.values()) {
            if (!f.isAccepted(Arrays.asList(ranges))) continue;
            return f;
        }
        return null;
    }

    private SerializationFormat(String uriText, MediaType primaryMediaType, MediaTypeSet mediaTypes) {
        this.uriText = uriText;
        this.primaryMediaType = primaryMediaType;
        this.mediaTypes = mediaTypes;
    }

    public String uriText() {
        return this.uriText;
    }

    public MediaType mediaType() {
        return this.primaryMediaType;
    }

    public MediaTypeSet mediaTypes() {
        return this.mediaTypes;
    }

    public boolean isAccepted(MediaType range) {
        Objects.requireNonNull(range, "range");
        return this.mediaTypes.match(range) != null;
    }

    public boolean isAccepted(MediaType first, MediaType ... rest) {
        Objects.requireNonNull(first, "first");
        Objects.requireNonNull(rest, "rest");
        return this.isAccepted(Lists.asList(first, rest));
    }

    public boolean isAccepted(Iterable<MediaType> ranges) {
        Objects.requireNonNull(ranges, "ranges");
        return this.mediaTypes.match(ranges) != null;
    }

    public int hashCode() {
        return System.identityHashCode(this);
    }

    public boolean equals(@Nullable Object obj) {
        return this == obj;
    }

    @Override
    public int compareTo(SerializationFormat o) {
        return this.uriText.compareTo(o.uriText);
    }

    public String toString() {
        return this.uriText;
    }

    static {
        HashBiMap<String, SerializationFormat> mutableUriTextToFormats = HashBiMap.create();
        HashMultimap<MediaType, SerializationFormat> mutableSimplifiedMediaTypeToFormats = HashMultimap.create();
        NONE = SerializationFormat.register(mutableUriTextToFormats, mutableSimplifiedMediaTypeToFormats, new SerializationFormatProvider.Entry("none", MediaType.create("application", "x-none"), new MediaType[0]));
        UNKNOWN = SerializationFormat.register(mutableUriTextToFormats, mutableSimplifiedMediaTypeToFormats, new SerializationFormatProvider.Entry("unknown", MediaType.create("application", "x-unknown"), new MediaType[0]));
        ImmutableList<SerializationFormatProvider> providers = ImmutableList.copyOf(ServiceLoader.load(SerializationFormatProvider.class, SerializationFormatProvider.class.getClassLoader()));
        if (!providers.isEmpty()) {
            logger.debug("Available {}s: {}", (Object)SerializationFormatProvider.class.getSimpleName(), providers);
            providers.forEach(p -> p.entries().forEach(e -> SerializationFormat.register(mutableUriTextToFormats, mutableSimplifiedMediaTypeToFormats, e)));
        }
        uriTextToFormats = ImmutableBiMap.copyOf(mutableUriTextToFormats);
        values = uriTextToFormats.values();
    }
}

