/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.DefaultAttributeMap;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.HttpRequest;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.RequestId;
import com.linecorp.armeria.common.RpcRequest;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.common.ArmeriaHttpUtil;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import io.micrometer.core.instrument.MeterRegistry;
import io.netty.channel.Channel;
import io.netty.util.AttributeKey;
import java.net.SocketAddress;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import java.util.function.Supplier;

public abstract class NonWrappingRequestContext
implements RequestContext {
    private static final AtomicReferenceFieldUpdater<NonWrappingRequestContext, Supplier> contextHookUpdater = AtomicReferenceFieldUpdater.newUpdater(NonWrappingRequestContext.class, Supplier.class, "contextHook");
    private final MeterRegistry meterRegistry;
    private final DefaultAttributeMap attrs;
    private final SessionProtocol sessionProtocol;
    private final RequestId id;
    private final HttpMethod method;
    private final String path;
    @Nullable
    private String decodedPath;
    @Nullable
    private final String query;
    @Nullable
    private volatile HttpRequest req;
    @Nullable
    private volatile RpcRequest rpcReq;
    @Nullable
    private volatile Supplier<AutoCloseable> contextHook;

    protected NonWrappingRequestContext(MeterRegistry meterRegistry, SessionProtocol sessionProtocol, RequestId id, HttpMethod method, String path, @Nullable String query, @Nullable HttpRequest req, @Nullable RpcRequest rpcReq, @Nullable RequestContext rootAttributeMap) {
        this.meterRegistry = Objects.requireNonNull(meterRegistry, "meterRegistry");
        this.attrs = new DefaultAttributeMap(rootAttributeMap);
        this.sessionProtocol = Objects.requireNonNull(sessionProtocol, "sessionProtocol");
        this.id = Objects.requireNonNull(id, "id");
        this.method = Objects.requireNonNull(method, "method");
        this.path = Objects.requireNonNull(path, "path");
        this.query = query;
        this.req = req;
        this.rpcReq = rpcReq;
    }

    @Override
    public final HttpRequest request() {
        return this.req;
    }

    @Override
    public final RpcRequest rpcRequest() {
        return this.rpcReq;
    }

    @Override
    public final void updateRequest(HttpRequest req) {
        Objects.requireNonNull(req, "req");
        this.validateHeaders(req.headers());
        this.unsafeUpdateRequest(req);
    }

    @Override
    public final void updateRpcRequest(RpcRequest rpcReq) {
        Objects.requireNonNull(rpcReq, "rpcReq");
        this.rpcReq = rpcReq;
    }

    protected void validateHeaders(RequestHeaders headers) {
        Preconditions.checkArgument(headers.scheme() != null && headers.authority() != null, "must set ':scheme' and ':authority' headers");
    }

    protected final void unsafeUpdateRequest(HttpRequest req) {
        this.req = req;
    }

    @Override
    public final SessionProtocol sessionProtocol() {
        return this.sessionProtocol;
    }

    @Nullable
    protected abstract Channel channel();

    @Override
    @Nullable
    public <A extends SocketAddress> A remoteAddress() {
        Channel ch = this.channel();
        return (A)(ch != null ? ch.remoteAddress() : null);
    }

    @Override
    @Nullable
    public <A extends SocketAddress> A localAddress() {
        Channel ch = this.channel();
        return (A)(ch != null ? ch.localAddress() : null);
    }

    @Override
    public final RequestId id() {
        return this.id;
    }

    @Override
    public final HttpMethod method() {
        return this.method;
    }

    @Override
    public final String path() {
        return this.path;
    }

    @Override
    public final String decodedPath() {
        String decodedPath = this.decodedPath;
        if (decodedPath != null) {
            return decodedPath;
        }
        this.decodedPath = ArmeriaHttpUtil.decodePath(this.path);
        return this.decodedPath;
    }

    @Override
    public final String query() {
        return this.query;
    }

    @Override
    public final MeterRegistry meterRegistry() {
        return this.meterRegistry;
    }

    @Override
    @Nullable
    public <V> V attr(AttributeKey<V> key) {
        Objects.requireNonNull(key, "key");
        return this.attrs.attr(key);
    }

    @Override
    @Nullable
    public final <V> V ownAttr(AttributeKey<V> key) {
        Objects.requireNonNull(key, "key");
        return this.attrs.ownAttr(key);
    }

    @Override
    public final <V> V setAttr(AttributeKey<V> key, @Nullable V value) {
        Objects.requireNonNull(key, "key");
        return this.attrs.setAttr(key, value);
    }

    @Override
    public Iterator<Map.Entry<AttributeKey<?>, Object>> attrs() {
        return this.attrs.attrs();
    }

    @Override
    public final Iterator<Map.Entry<AttributeKey<?>, Object>> ownAttrs() {
        return this.attrs.ownAttrs();
    }

    public void hook(Supplier<? extends AutoCloseable> contextHook) {
        Supplier<? extends AutoCloseable> newContextHook;
        Supplier<AutoCloseable> oldContextHook;
        Objects.requireNonNull(contextHook, "contextHook");
        while (!contextHookUpdater.compareAndSet(this, oldContextHook, newContextHook = (oldContextHook = this.contextHook) == null ? contextHook : () -> {
            AutoCloseable oldHook = (AutoCloseable)oldContextHook.get();
            AutoCloseable newHook = (AutoCloseable)contextHook.get();
            return () -> {
                oldHook.close();
                newHook.close();
            };
        })) {
        }
    }

    @Nullable
    public Supplier<AutoCloseable> hook() {
        return this.contextHook;
    }
}

