/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.AggregatedHttpResponse;
import com.linecorp.armeria.common.HttpData;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.HttpStatus;
import com.linecorp.armeria.common.ResponseHeaders;
import com.linecorp.armeria.common.stream.StreamWriter;
import com.linecorp.armeria.internal.common.ArmeriaHttpUtil;
import java.util.Objects;

public interface HttpResponseWriter
extends HttpResponse,
StreamWriter<HttpObject> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public void close(AggregatedHttpResponse res) {
        boolean transferredContent = false;
        HttpData content = null;
        try {
            HttpHeaders trailers;
            Objects.requireNonNull(res, "res");
            ResponseHeaders headers = res.headers();
            HttpStatus status = headers.status();
            content = res.content();
            boolean contentAlwaysEmpty = ArmeriaHttpUtil.isContentAlwaysEmptyWithValidation(status, content);
            if (!this.tryWrite(headers)) {
                return;
            }
            if (!contentAlwaysEmpty && !content.isEmpty()) {
                transferredContent = true;
                if (!this.tryWrite(content)) {
                    return;
                }
            }
            if (!(trailers = res.trailers()).isEmpty()) {
                boolean bl = this.tryWrite(trailers);
            }
        }
        finally {
            this.close();
            if (!transferredContent && content != null) {
                content.close();
            }
        }
    }
}

