/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import com.linecorp.armeria.common.ByteArrayHttpData;
import com.linecorp.armeria.common.ByteBufAccessMode;
import com.linecorp.armeria.common.ByteBufHttpData;
import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.util.SafeCloseable;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;

public interface HttpData
extends HttpObject,
SafeCloseable {
    public static HttpData empty() {
        return ByteArrayHttpData.EMPTY;
    }

    public static HttpData wrap(byte[] data) {
        Objects.requireNonNull(data, "data");
        if (data.length == 0) {
            return HttpData.empty();
        }
        return new ByteArrayHttpData(data);
    }

    public static HttpData wrap(byte[] data, int offset, int length) {
        Objects.requireNonNull(data, "data");
        if (offset < 0 || length < 0 || offset > data.length - length) {
            throw new IndexOutOfBoundsException("offset: " + offset + ", length: " + length + ", data.length: " + data.length);
        }
        if (length == 0) {
            return HttpData.empty();
        }
        if (data.length == length) {
            return new ByteArrayHttpData(data);
        }
        return new ByteBufHttpData(Unpooled.wrappedBuffer((byte[])data, (int)offset, (int)length), false);
    }

    public static HttpData wrap(ByteBuf buf) {
        Objects.requireNonNull(buf, "buf");
        int length = buf.readableBytes();
        if (length == 0) {
            buf.release();
            return ByteArrayHttpData.EMPTY;
        }
        ByteBufHttpData data = new ByteBufHttpData(buf, true);
        buf.touch((Object)data);
        return data;
    }

    public static HttpData copyOf(byte[] data) {
        Objects.requireNonNull(data, "data");
        if (data.length == 0) {
            return HttpData.empty();
        }
        return new ByteArrayHttpData((byte[])data.clone());
    }

    public static HttpData copyOf(byte[] data, int offset, int length) {
        Objects.requireNonNull(data);
        if (offset < 0 || length < 0 || offset > data.length - length) {
            throw new ArrayIndexOutOfBoundsException("offset: " + offset + ", length: " + length + ", data.length: " + data.length);
        }
        if (length == 0) {
            return HttpData.empty();
        }
        return new ByteArrayHttpData(Arrays.copyOfRange(data, offset, offset + length));
    }

    public static HttpData copyOf(ByteBuf data) {
        Objects.requireNonNull(data, "data");
        data.touch((Object)data);
        if (!data.isReadable()) {
            return HttpData.empty();
        }
        return HttpData.wrap(ByteBufUtil.getBytes((ByteBuf)data));
    }

    public static HttpData of(Charset charset, CharSequence text) {
        Objects.requireNonNull(charset, "charset");
        Objects.requireNonNull(text, "text");
        if (text instanceof String) {
            return HttpData.of(charset, (String)text);
        }
        if (text.length() == 0) {
            return HttpData.empty();
        }
        CharBuffer cb = CharBuffer.wrap(text);
        ByteBuffer buf = charset.encode(cb);
        if (buf.arrayOffset() == 0 && buf.remaining() == buf.array().length) {
            return HttpData.wrap(buf.array());
        }
        return HttpData.copyOf(buf.array(), buf.arrayOffset(), buf.remaining());
    }

    public static HttpData of(Charset charset, String text) {
        Objects.requireNonNull(charset, "charset");
        Objects.requireNonNull(text, "text");
        if (text.isEmpty()) {
            return HttpData.empty();
        }
        return HttpData.wrap(text.getBytes(charset));
    }

    @FormatMethod
    public static HttpData of(Charset charset, @FormatString String format, Object ... args) {
        Objects.requireNonNull(charset, "charset");
        Objects.requireNonNull(format, "format");
        Objects.requireNonNull(args, "args");
        if (format.isEmpty()) {
            return HttpData.empty();
        }
        return HttpData.wrap(String.format(Locale.ENGLISH, format, args).getBytes(charset));
    }

    public static HttpData ofUtf8(CharSequence text) {
        return HttpData.of(StandardCharsets.UTF_8, text);
    }

    public static HttpData ofUtf8(String text) {
        return HttpData.of(StandardCharsets.UTF_8, text);
    }

    @FormatMethod
    public static HttpData ofUtf8(@FormatString String format, Object ... args) {
        return HttpData.of(StandardCharsets.UTF_8, format, args);
    }

    public static HttpData ofAscii(CharSequence text) {
        return HttpData.of(StandardCharsets.US_ASCII, text);
    }

    public static HttpData ofAscii(String text) {
        return HttpData.of(StandardCharsets.US_ASCII, text);
    }

    @FormatMethod
    public static HttpData ofAscii(@FormatString String format, Object ... args) {
        return HttpData.of(StandardCharsets.US_ASCII, format, args);
    }

    public byte[] array();

    public int length();

    default public boolean isEmpty() {
        return this.length() == 0;
    }

    public String toString(Charset var1);

    default public String toStringUtf8() {
        return this.toString(StandardCharsets.UTF_8);
    }

    default public String toStringAscii() {
        return this.toString(StandardCharsets.US_ASCII);
    }

    public InputStream toInputStream();

    default public Reader toReader(Charset charset) {
        Objects.requireNonNull(charset, "charset");
        return new InputStreamReader(this.toInputStream(), charset);
    }

    default public Reader toReaderUtf8() {
        return this.toReader(StandardCharsets.UTF_8);
    }

    default public Reader toReaderAscii() {
        return this.toReader(StandardCharsets.US_ASCII);
    }

    default public HttpData withEndOfStream() {
        return this.withEndOfStream(true);
    }

    public HttpData withEndOfStream(boolean var1);

    public boolean isPooled();

    default public ByteBuf byteBuf() {
        return this.byteBuf(ByteBufAccessMode.DUPLICATE);
    }

    public ByteBuf byteBuf(ByteBufAccessMode var1);

    public ByteBuf byteBuf(int var1, int var2, ByteBufAccessMode var3);

    default public void touch(@Nullable Object hint) {
    }

    @Override
    public void close();
}

