/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.HttpObject;
import com.linecorp.armeria.common.HttpResponse;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.stream.DeferredStreamMessage;
import com.linecorp.armeria.common.util.Exceptions;
import io.netty.util.concurrent.EventExecutor;
import java.util.Objects;
import java.util.concurrent.CompletionStage;

final class DeferredHttpResponse
extends DeferredStreamMessage<HttpObject>
implements HttpResponse {
    @Nullable
    private final EventExecutor executor;

    DeferredHttpResponse() {
        this.executor = null;
    }

    DeferredHttpResponse(EventExecutor executor) {
        this.executor = executor;
    }

    void delegate(HttpResponse delegate) {
        super.delegate(delegate);
    }

    void delegateWhenComplete(CompletionStage<? extends HttpResponse> stage) {
        Objects.requireNonNull(stage, "stage");
        stage.handle((delegate, thrown) -> {
            if (thrown != null) {
                this.close(Exceptions.peel(thrown));
            } else if (delegate == null) {
                this.close(new NullPointerException("delegate stage produced a null response: " + stage));
            } else {
                this.delegate((HttpResponse)delegate);
            }
            return null;
        });
    }

    @Override
    public EventExecutor defaultSubscriberExecutor() {
        if (this.executor != null) {
            return this.executor;
        }
        return super.defaultSubscriberExecutor();
    }
}

