/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.AbstractHttpHeadersBuilder;
import com.linecorp.armeria.common.Cookie;
import com.linecorp.armeria.common.Cookies;
import com.linecorp.armeria.common.DefaultRequestHeaders;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeadersBase;
import com.linecorp.armeria.common.HttpMethod;
import com.linecorp.armeria.common.MediaType;
import com.linecorp.armeria.common.RequestHeaders;
import com.linecorp.armeria.common.RequestHeadersBuilder;
import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableList;
import com.linecorp.armeria.internal.shaded.guava.collect.ImmutableSet;
import com.linecorp.armeria.internal.shaded.guava.collect.Iterables;
import java.net.URI;
import java.util.List;
import java.util.Locale;
import java.util.Objects;

final class DefaultRequestHeadersBuilder
extends AbstractHttpHeadersBuilder<RequestHeadersBuilder>
implements RequestHeadersBuilder {
    DefaultRequestHeadersBuilder() {
    }

    DefaultRequestHeadersBuilder(DefaultRequestHeaders headers) {
        super(headers);
    }

    @Override
    public RequestHeaders build() {
        HttpHeadersBase delegate = (HttpHeadersBase)this.delegate();
        if (delegate != null) {
            Preconditions.checkState(delegate.contains(HttpHeaderNames.METHOD), ":method header does not exist.");
            Preconditions.checkState(delegate.contains(HttpHeaderNames.PATH), ":path header does not exist.");
            return new DefaultRequestHeaders((HttpHeadersBase)this.promoteDelegate());
        }
        HttpHeadersBase parent = (HttpHeadersBase)this.parent();
        if (parent != null) {
            if (parent instanceof RequestHeaders) {
                return (RequestHeaders)((Object)parent);
            }
            return this.updateParent(new DefaultRequestHeaders(parent));
        }
        throw new IllegalStateException("must set ':method' and ':path' headers");
    }

    @Override
    public URI uri() {
        HttpHeadersBase getters = (HttpHeadersBase)this.getters();
        Preconditions.checkState(getters != null, "must set ':scheme', ':authority' and ':path' headers");
        return getters.uri();
    }

    @Override
    public HttpMethod method() {
        HttpHeadersBase getters = (HttpHeadersBase)this.getters();
        Preconditions.checkState(getters != null, ":method header does not exist.");
        return getters.method();
    }

    @Override
    public RequestHeadersBuilder method(HttpMethod method) {
        ((HttpHeadersBase)this.setters()).method(method);
        return this;
    }

    @Override
    public String path() {
        HttpHeadersBase getters = (HttpHeadersBase)this.getters();
        Preconditions.checkState(getters != null, ":path header does not exist.");
        return getters.path();
    }

    @Override
    public RequestHeadersBuilder path(String path) {
        ((HttpHeadersBase)this.setters()).path(path);
        return this;
    }

    @Override
    @Nullable
    public String scheme() {
        HttpHeadersBase getters = (HttpHeadersBase)this.getters();
        return getters != null ? getters.scheme() : null;
    }

    @Override
    public RequestHeadersBuilder scheme(String scheme) {
        ((HttpHeadersBase)this.setters()).scheme(scheme);
        return this;
    }

    @Override
    @Nullable
    public String authority() {
        HttpHeadersBase getters = (HttpHeadersBase)this.getters();
        return getters != null ? getters.authority() : null;
    }

    @Override
    public RequestHeadersBuilder authority(String authority) {
        ((HttpHeadersBase)this.setters()).authority(authority);
        return this;
    }

    @Override
    @Nullable
    public List<Locale.LanguageRange> acceptLanguages() {
        HttpHeadersBase getters = (HttpHeadersBase)this.getters();
        return getters != null ? getters.acceptLanguages() : null;
    }

    @Override
    public RequestHeadersBuilder acceptLanguages(Iterable<Locale.LanguageRange> acceptLanguages) {
        Objects.requireNonNull(acceptLanguages, "acceptLanguages");
        Preconditions.checkArgument(!Iterables.isEmpty(acceptLanguages), "acceptLanguages cannot be empty");
        ((HttpHeadersBase)this.setters()).acceptLanguages(acceptLanguages);
        return (RequestHeadersBuilder)this.self();
    }

    @Override
    @Nullable
    public Locale selectLocale(Iterable<Locale> supportedLocales) {
        HttpHeadersBase getters = (HttpHeadersBase)this.getters();
        return getters != null ? getters.selectLocale(supportedLocales) : null;
    }

    @Override
    public RequestHeadersBuilder cookie(Cookie cookie) {
        Objects.requireNonNull(cookie, "cookie");
        return this.cookies(ImmutableSet.of(cookie));
    }

    @Override
    public Cookies cookies() {
        HttpHeadersBase getters = (HttpHeadersBase)this.getters();
        if (getters == null) {
            return Cookies.of();
        }
        return getters.cookie();
    }

    @Override
    public RequestHeadersBuilder cookies(Iterable<? extends Cookie> cookies) {
        Objects.requireNonNull(cookies, "cookie");
        ((HttpHeadersBase)this.setters()).cookie(cookies);
        return this;
    }

    @Override
    public RequestHeadersBuilder cookies(Cookie ... cookies) {
        Objects.requireNonNull(cookies, "cookie");
        return this.cookies(ImmutableSet.copyOf(cookies));
    }

    @Override
    public List<MediaType> accept() {
        HttpHeadersBase getters = (HttpHeadersBase)this.getters();
        if (getters == null) {
            return ImmutableList.of();
        }
        return getters.accept();
    }

    @Override
    public RequestHeadersBuilder accept(MediaType ... mediaTypes) {
        Objects.requireNonNull(mediaTypes, "mediaTypes");
        return this.accept(ImmutableList.copyOf(mediaTypes));
    }

    @Override
    public RequestHeadersBuilder accept(Iterable<MediaType> mediaTypes) {
        ((HttpHeadersBase)this.setters()).accept(mediaTypes);
        return this;
    }
}

