/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.ContextAwareEventLoop;
import com.linecorp.armeria.common.ContextAwareFuture;
import com.linecorp.armeria.common.ContextAwareProgressivePromise;
import com.linecorp.armeria.common.ContextAwarePromise;
import com.linecorp.armeria.common.DefaultContextAwareExecutorService;
import com.linecorp.armeria.common.RequestContext;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelPromise;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.ProgressivePromise;
import io.netty.util.concurrent.Promise;
import io.netty.util.concurrent.ScheduledFuture;
import java.util.Iterator;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;

final class DefaultContextAwareEventLoop
extends DefaultContextAwareExecutorService
implements ContextAwareEventLoop {
    private final EventLoop eventLoop;

    DefaultContextAwareEventLoop(RequestContext context, EventLoop eventLoop) {
        super(context, (ExecutorService)eventLoop);
        this.eventLoop = eventLoop;
    }

    @Override
    public EventLoop withoutContext() {
        return this.eventLoop;
    }

    public EventLoop next() {
        return this;
    }

    public EventLoopGroup parent() {
        return this.eventLoop.parent();
    }

    public boolean inEventLoop() {
        return this.eventLoop.inEventLoop();
    }

    public boolean inEventLoop(Thread thread) {
        return this.eventLoop.inEventLoop(thread);
    }

    public <V> Promise<V> newPromise() {
        return new ContextAwarePromise(this.context(), this.eventLoop.newPromise());
    }

    public <V> ProgressivePromise<V> newProgressivePromise() {
        return new ContextAwareProgressivePromise(this.context(), this.eventLoop.newProgressivePromise());
    }

    public <V> Future<V> newSucceededFuture(V result) {
        return new ContextAwareFuture(this.context(), this.eventLoop.newSucceededFuture(result));
    }

    public <V> Future<V> newFailedFuture(Throwable cause) {
        return new ContextAwareFuture(this.context(), this.eventLoop.newFailedFuture(cause));
    }

    public boolean isShuttingDown() {
        return this.eventLoop.isShuttingDown();
    }

    public Future<?> shutdownGracefully() {
        return this.eventLoop.shutdownGracefully();
    }

    public Future<?> shutdownGracefully(long quietPeriod, long timeout, TimeUnit unit) {
        return this.eventLoop.shutdownGracefully(quietPeriod, timeout, unit);
    }

    public Future<?> terminationFuture() {
        return this.eventLoop.terminationFuture();
    }

    public Iterator<EventExecutor> iterator() {
        return this.eventLoop.iterator();
    }

    @Override
    public Future<?> submit(Runnable task) {
        return (Future)super.submit(task);
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        return (Future)super.submit(task, result);
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        return (Future)super.submit(task);
    }

    public ScheduledFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        return this.eventLoop.schedule(this.context().makeContextAware(command), delay, unit);
    }

    public <V> ScheduledFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        return this.eventLoop.schedule(this.context().makeContextAware(callable), delay, unit);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        return this.eventLoop.scheduleAtFixedRate(this.context().makeContextAware(command), initialDelay, period, unit);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        return this.eventLoop.scheduleWithFixedDelay(this.context().makeContextAware(command), initialDelay, delay, unit);
    }

    public ChannelFuture register(Channel channel) {
        return this.eventLoop.register(channel);
    }

    public ChannelFuture register(ChannelPromise channelPromise) {
        return this.eventLoop.register(channelPromise);
    }

    public ChannelFuture register(Channel channel, ChannelPromise channelPromise) {
        return this.eventLoop.register(channel, channelPromise);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("context", this.context()).add("eventLoop", this.eventLoop).toString();
    }
}

